/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.provision;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import io.privacyresearch.equation.EquationManager;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.signal.libsignal.protocol.ecc.Curve;
import org.signal.libsignal.protocol.ecc.ECKeyPair;
import org.signal.libsignal.protocol.ecc.ECPrivateKey;
import org.signal.libsignal.protocol.ecc.ECPublicKey;
import org.signal.libsignal.protocol.kdf.HKDFv3;
import org.whispersystems.signalservice.internal.ProvisioningProtos;

public class ProvisioningCipher {
    private final ECKeyPair ourKeyPair;
    private final EquationManager waveManager;

    public ProvisioningCipher(EquationManager w) {
        this.waveManager = w;
        this.ourKeyPair = Curve.generateKeyPair();
    }

    public ECKeyPair getOurKeyPair() {
        return this.ourKeyPair;
    }

    public ProvisioningProtos.ProvisionMessage decrypt(ProvisioningProtos.ProvisionEnvelope envelope) throws org.signal.libsignal.protocol.InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, InvalidProtocolBufferException {
        ByteString masterEphemeral = envelope.getPublicKey();
        ECPublicKey ecPub = Curve.decodePoint((byte[])masterEphemeral.toByteArray(), (int)0);
        ByteString message = envelope.getBody();
        if (message.byteAt(0) != 1) {
            throw new RuntimeException("First byte should be 1 in provisioningenvelope");
        }
        int mSize = message.size();
        ByteString iv = message.substring(1, 17);
        ByteString mach = message.substring(mSize - 32, mSize);
        ByteString versionAndivAndCipherText = message.substring(0, mSize - 32);
        ByteString cipherText = message.substring(17, mSize - 32);
        byte[] ecRes = Curve.calculateAgreement((ECPublicKey)ecPub, (ECPrivateKey)this.ourKeyPair.getPrivateKey());
        new HKDFv3();
        byte[] totkeys = HKDFv3.deriveSecrets((byte[])ecRes, (byte[])"TextSecure Provisioning Message".getBytes(), (int)64);
        byte[][] keys = new byte[2][32];
        System.arraycopy(totkeys, 0, keys[0], 0, 32);
        System.arraycopy(totkeys, 32, keys[1], 0, 32);
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(new SecretKeySpec(keys[1], "HmacSHA256"));
        byte[] calcMac = mac.doFinal(versionAndivAndCipherText.toByteArray());
        boolean macMatch = Arrays.equals(calcMac, mach.toByteArray());
        if (!macMatch) {
            throw new IllegalArgumentException("provisioning body has wrong mac");
        }
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        IvParameterSpec ivSpec = new IvParameterSpec(iv.toByteArray());
        cipher.init(2, (Key)new SecretKeySpec(keys[0], "AES"), ivSpec);
        byte[] doFinal = cipher.doFinal(cipherText.toByteArray());
        ProvisioningProtos.ProvisionMessage pm = ProvisioningProtos.ProvisionMessage.parseFrom((byte[])doFinal);
        return pm;
    }
}

