/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.model;

import io.privacyresearch.clientdata.channel.ChannelKey;
import io.privacyresearch.clientdata.message.BodyRange;
import io.privacyresearch.clientdata.message.InfoMessage;
import io.privacyresearch.clientdata.message.MessageKey;
import io.privacyresearch.clientdata.message.ReceiptType;
import io.privacyresearch.clientdata.message.StoryType;
import io.privacyresearch.clientdata.recipient.RecipientKey;
import io.privacyresearch.equation.user.UserRecord;
import java.util.List;

public record MessageRecord(MessageKey key, ChannelKey channelKey, UserRecord sender, RecipientKey receiverKey, String body, List<BodyRange> bodyRanges, long dateSent, long dateReceived, ReceiptType receiptType, long receiptTimestamp, int expiresIn, long expireStarted, StoryType storyType, InfoMessage infoMessage, boolean read, boolean viewOnce, long flags, MessageKey originalMessageKey) {
    public boolean isDeleted() {
        long mask = 1L;
        return (this.flags() & mask) != 0L;
    }

    public static class Builder {
        MessageKey key = new MessageKey();
        ChannelKey channelKey;
        UserRecord sender;
        RecipientKey receiverKey;
        String body;
        List<BodyRange> bodyRanges;
        long dateSent;
        long dateReceived;
        ReceiptType receiptType;
        long receiptTimestamp;
        int expiresIn;
        long expireStarted;
        StoryType storyType;
        InfoMessage infoMessage;
        boolean read;
        long flags;
        MessageKey originalMessageKey;
        boolean viewOnce;

        public Builder sender(UserRecord val) {
            this.sender = val;
            return this;
        }

        public Builder receiverKey(RecipientKey val) {
            this.receiverKey = val;
            return this;
        }

        public Builder body(String val) {
            this.body = val;
            return this;
        }

        public Builder infoMessage(InfoMessage val) {
            this.infoMessage = val;
            return this;
        }

        public Builder dateSent(long v) {
            this.dateSent = v;
            return this;
        }

        public Builder dateReceived(long v) {
            this.dateReceived = v;
            return this;
        }

        public MessageRecord build() {
            if (this.key == null) {
                throw new IllegalStateException("MessageKey has been set to null.");
            }
            return new MessageRecord(this.key, this.channelKey, this.sender, this.receiverKey, this.body, this.bodyRanges, this.dateSent, this.dateReceived, this.receiptType, this.receiptTimestamp, this.expiresIn, this.expireStarted, this.storyType, this.infoMessage, this.read, this.viewOnce, this.flags, this.originalMessageKey);
        }
    }
}

