/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.incoming;

import com.google.protobuf.ByteString;
import com.google.protobuf.ProtocolStringList;
import io.privacyresearch.clientdata.EntityKey;
import io.privacyresearch.clientdata.SqliteStorageBean;
import io.privacyresearch.clientdata.channel.ChannelRecord;
import io.privacyresearch.clientdata.group.GroupRecord;
import io.privacyresearch.clientdata.message.MessageDbRecord;
import io.privacyresearch.clientdata.recipient.RecipientKey;
import io.privacyresearch.clientdata.recipient.RecipientRecord;
import io.privacyresearch.clientdata.user.UserDbRecord;
import io.privacyresearch.equation.EquationManager;
import io.privacyresearch.equation.message.MessagingClient;
import io.privacyresearch.equation.signal.SignalBridge;
import io.privacyresearch.equation.user.Account;
import io.privacyresearch.equation.user.UserRecord;
import io.privacyresearch.equation.user.UserService;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import org.signal.libsignal.protocol.InvalidMessageException;
import org.signal.libsignal.protocol.ServiceId;
import org.whispersystems.signalservice.api.kbs.MasterKey;
import org.whispersystems.signalservice.api.storage.StorageKey;
import org.whispersystems.signalservice.internal.SignalServiceProtos;

public class SyncMessageProcessor {
    Logger LOG = Logger.getLogger(SyncMessageProcessor.class.getName());
    private final EquationManager equation;
    private final SqliteStorageBean sqliteStorageBean;
    private final SignalBridge signalBridge;
    private final UserService userService;

    public SyncMessageProcessor(EquationManager equation) {
        this.equation = equation;
        this.sqliteStorageBean = equation.getSqliteStorageBean();
        this.signalBridge = equation.getSignalBridge();
        this.userService = equation.getUserService();
    }

    public MessagingClient getClient() {
        return this.equation.getMessageListener();
    }

    public void processSyncMessage(SignalServiceProtos.Envelope envelope, SignalServiceProtos.SyncMessage sssm, UserDbRecord sender, RecipientRecord threadRecipient) throws InvalidMessageException, IOException {
        this.LOG.info("Processing incoming SyncMessage for threadRecipient = " + String.valueOf(threadRecipient));
        boolean processed = false;
        if (sssm.hasContacts()) {
            this.asyncProcessContactsMessage(sssm.getContacts());
            processed = true;
        }
        if (sssm.hasSent()) {
            this.processSentTranscriptMessage(envelope, sssm.getSent(), sender, threadRecipient);
            processed = true;
        }
        if (sssm.hasKeys()) {
            this.asyncProcessKeysMessage(sssm.getKeys());
            processed = true;
        }
        if (sssm.getReadCount() > 0) {
            this.processReadMessages(sssm.getReadList(), envelope.getTimestamp());
            processed = true;
        }
        if (sssm.getViewedCount() > 0) {
            this.processViewedStories(sssm.getViewedList());
            processed = true;
        }
        if (sssm.hasBlocked()) {
            this.processSyncBlocked(sssm.getBlocked(), true);
            processed = true;
        }
        if (sssm.hasFetchLatest()) {
            this.processFetchTypeMessage(sssm.getFetchLatest());
            processed = true;
        }
        if (sssm.getStickerPackOperationCount() > 0) {
            this.signalBridge.processStickerPackOperationMessage(sssm.getStickerPackOperationList());
            processed = true;
        }
        if (sssm.hasConfiguration()) {
            this.processConfigurationMessage(sssm.getConfiguration());
            processed = true;
        }
        if (sssm.hasRequest()) {
            this.LOG.warning("Sync Request message received, we ignore that.");
            this.LOG.info("Request = " + String.valueOf(sssm.getRequest()));
            processed = true;
        }
        if (sssm.hasCallEvent()) {
            this.equation.getWaveCallManager().processCallEvent(sssm.getCallEvent());
            processed = true;
        }
        if (sssm.hasCallLogEvent()) {
            this.equation.getWaveCallManager().processCallLogEvent(sssm.getCallLogEvent());
            processed = true;
        }
        if (!processed) {
            System.err.println("DIDN'T PROCESS " + String.valueOf(sssm));
            throw new RuntimeException("Unprocessed sync msg ");
        }
        this.LOG.info("Processed INCOMING SyncMessage.");
    }

    private void processReadMessages(List<SignalServiceProtos.SyncMessage.Read> messages, long expireStarted) {
        HashMap<RecipientKey, Long> receiverKey_timestamp = new HashMap<RecipientKey, Long>();
        boolean notifyCollector = false;
        for (SignalServiceProtos.SyncMessage.Read read : messages) {
            Long v;
            ServiceId.Aci senderId = new ServiceId.Aci(UUID.fromString(read.getSenderAci()));
            UserDbRecord sender = this.sqliteStorageBean.getUserData().getUserForServiceId((ServiceId)senderId);
            MessageDbRecord message = this.sqliteStorageBean.getMessageData().getByFromRecipientKeyAndDateSent(sender.recipientKey(), read.getTimestamp());
            if (message == null) {
                this.LOG.info("Can't find message from read notification, might be expired and deleted");
                return;
            }
            this.LOG.info("Got read message for " + String.valueOf(message.receiverKey()) + " with expin = " + message.expiresIn() + " and started = " + message.expireStarted());
            if (message.expiresIn() > 0 && message.expireStarted() == 0L) {
                this.sqliteStorageBean.getMessageData().updateExpireStarted(message.key(), expireStarted);
                this.LOG.info("expireStarted = " + expireStarted + " and exp = " + message.expiresIn() + " for " + String.valueOf(message.key()));
                notifyCollector = true;
            }
            if ((v = (Long)receiverKey_timestamp.get(message.receiverKey())) != null && v >= read.getTimestamp()) continue;
            receiverKey_timestamp.put(message.receiverKey(), read.getTimestamp());
        }
        if (notifyCollector) {
            this.equation.getMessageCollector().trigger();
        }
        for (Map.Entry entry : receiverKey_timestamp.entrySet()) {
            ChannelRecord channelRecord;
            RecipientKey receiverKey = (RecipientKey)entry.getKey();
            long time = (Long)entry.getValue();
            if (time <= (channelRecord = this.equation.getChannelByRecipientKey(receiverKey)).lastRead()) continue;
            this.sqliteStorageBean.getChannelData().updateLastRead(channelRecord.key(), time);
            int unreadCount = this.sqliteStorageBean.getMessageData().getNumberOfMessagesAfter(receiverKey, time);
            this.LOG.info("check unread messages will return " + unreadCount);
            if (this.getClient() == null) continue;
            this.getClient().gotReadUpdate(receiverKey, time, unreadCount);
        }
    }

    private void processSentTranscriptMessage(SignalServiceProtos.Envelope envelope, SignalServiceProtos.SyncMessage.Sent transcriptMsg, UserDbRecord sender, RecipientRecord channelRecipient) {
        this.LOG.info("ProcessSentTranscriptMessage for message with ID " + transcriptMsg.getTimestamp());
        this.LOG.info("sender = " + String.valueOf(sender.key()) + " and channelRecipient = " + String.valueOf(channelRecipient.key()));
        RecipientRecord realDestination = null;
        if (transcriptMsg.hasDestinationServiceId()) {
            String destid = transcriptMsg.getDestinationServiceId();
            ServiceId.Aci destAci = new ServiceId.Aci(UUID.fromString(destid));
            Optional<UserDbRecord> destUser = this.userService.getDbUserByAci(destAci);
            realDestination = (RecipientRecord)this.sqliteStorageBean.getRecipientData().findByKey((EntityKey)destUser.get().recipientKey());
        }
        if (transcriptMsg.hasMessage()) {
            int flag;
            GroupRecord group;
            SignalServiceProtos.DataMessage message = transcriptMsg.getMessage();
            if (message.hasGroupCallUpdate()) {
                this.LOG.warning("GROUPCALLUPDATE");
            }
            GroupRecord groupRecord = group = message.hasGroupV2() ? (GroupRecord)this.equation.getGroupByMasterKey(message.getGroupV2().getMasterKey().toByteArray()).orElse(null) : null;
            if (group != null) {
                realDestination = group.recipient();
            }
            boolean handled = false;
            if (message.hasFlags() && (flag = message.getFlags()) == 2) {
                this.LOG.info("This is an update to the expiration timer");
            }
            if (!handled) {
                this.signalBridge.processDataMessage(envelope, message, sender, realDestination);
            }
        }
        if (transcriptMsg.hasStoryMessage()) {
            throw new RuntimeException("NYI");
        }
        if (transcriptMsg.hasEditMessage()) {
            GroupRecord group;
            SignalServiceProtos.EditMessage editMessage = transcriptMsg.getEditMessage();
            SignalServiceProtos.DataMessage dataMessage = editMessage.getDataMessage();
            GroupRecord groupRecord = group = dataMessage.hasGroupV2() ? (GroupRecord)this.equation.getGroupByMasterKey(dataMessage.getGroupV2().getMasterKey().toByteArray()).orElse(null) : null;
            if (group != null) {
                realDestination = group.recipient();
            }
            this.signalBridge.processDataMessage(envelope, editMessage.getDataMessage(), sender, realDestination, editMessage.getTargetSentTimestamp());
        }
    }

    private void processSyncBlocked(SignalServiceProtos.SyncMessage.Blocked blocked, boolean block) {
        ProtocolStringList acisList = blocked.getAcisList();
        for (String aci : acisList) {
            this.blockUserByAci(new ServiceId.Aci(UUID.fromString(aci)), true);
        }
        List groupIdsList = blocked.getGroupIdsList();
        for (ByteString bs : groupIdsList) {
            this.blockGroupById(bs.toByteArray(), block);
        }
    }

    private boolean blockUserByAci(ServiceId.Aci aci, boolean blocked) {
        Optional<UserDbRecord> user = this.userService.getDbUserByAci(aci);
        if (user.isPresent()) {
            this.LOG.info("We have to " + (blocked ? " block " : " accept ") + String.valueOf(aci));
            this.sqliteStorageBean.getRecipientData().setBlocked(user.get().recipientKey(), blocked);
            this.getClient().updateUser(this.userService.getUserRecordFromDb((UserDbRecord)this.sqliteStorageBean.getUserData().findByKey((EntityKey)user.get().key())));
            return true;
        }
        this.LOG.info("We have to " + (blocked ? " block " : " accept ") + String.valueOf(aci) + " but have no clue about this user.");
        return false;
    }

    private boolean blockGroupById(byte[] groupIdentifier, boolean block) {
        GroupRecord target = this.equation.getGroupByGroupIdentifier(groupIdentifier);
        this.LOG.info("Need to " + (block ? "block " : "unblock ") + String.valueOf(target));
        if (target == null) {
            this.LOG.info("We don't know a group with identifier " + Arrays.toString(groupIdentifier));
            return false;
        }
        this.sqliteStorageBean.getRecipientData().setBlocked(target.recipient().key(), block);
        if (this.getClient() != null) {
            this.getClient().updateGroupRecord(this.equation.getGroupByGroupIdentifier(groupIdentifier));
        }
        return true;
    }

    private void processConfigurationMessage(SignalServiceProtos.SyncMessage.Configuration msg) {
        Boolean cf;
        if (msg.hasReadReceipts()) {
            cf = msg.getReadReceipts();
            this.LOG.info("Process readReceipt configuration: " + cf);
            if (this.getClient() != null) {
                this.getClient().setConfigProperty("readReceiptEnable", cf.toString());
            }
        }
        if (msg.hasTypingIndicators()) {
            cf = msg.getTypingIndicators();
            this.LOG.info("Process typingIndicator configuration: " + cf);
            if (this.getClient() != null) {
                this.getClient().setConfigProperty("typingIndicatorEnable", cf.toString());
            }
        }
    }

    private void processFetchTypeMessage(SignalServiceProtos.SyncMessage.FetchLatest fetchType) {
        if (SignalServiceProtos.SyncMessage.FetchLatest.Type.LOCAL_PROFILE == fetchType.getType()) {
            this.LOG.info("Request our profile");
            Account account = this.equation.getAccount();
            ((CompletableFuture)this.equation.retrieveAndStoreProfile(account.getUser().aci(), account.getUser().profileKey()).thenAccept(myProfile -> {
                this.LOG.info("Got our profile/account, notify client");
                UserRecord userRecord = this.userService.getUserByAci(account.getUser().aci()).get();
                account.setUser(userRecord);
                if (this.getClient() != null) {
                    this.getClient().updateProfile(userRecord);
                    this.getClient().updateAccount(account);
                }
            })).exceptionally(ex -> {
                this.LOG.severe("Error getting local profile: " + String.valueOf(ex));
                return null;
            });
        }
        if (SignalServiceProtos.SyncMessage.FetchLatest.Type.STORAGE_MANIFEST == fetchType.getType()) {
            this.equation.syncStorage();
        }
    }

    private void asyncProcessContactsMessage(final SignalServiceProtos.SyncMessage.Contacts msg) {
        Thread t = new Thread(this, "asyncContact"){
            final /* synthetic */ SyncMessageProcessor this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            public void run() {
                this.this$0.LOG.info("AsyncProcessContact scheduled processContactsMessage, execute now on " + String.valueOf(this));
                this.this$0.processContactsMessage(msg);
                this.this$0.LOG.info("AsyncProcessContact scheduled processContactsMessage, executed.");
            }
        };
        this.LOG.info("Scheduling processContactsMessage, delegated to " + String.valueOf(t));
        t.start();
    }

    private void processContactsMessage(SignalServiceProtos.SyncMessage.Contacts msg) {
        this.LOG.info("DONT Processing contactsync msg");
        this.LOG.info("WaveManager has done reading/sync contacts ");
    }

    private void asyncProcessKeysMessage(final SignalServiceProtos.SyncMessage.Keys msg) {
        Thread t = new Thread(this, "asyncKeys"){
            final /* synthetic */ SyncMessageProcessor this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            public void run() {
                this.this$0.LOG.info("AsyncProcessKeys scheduled processKeysMessage, execute now on " + String.valueOf(this));
                this.this$0.processKeysMessage(msg);
                this.this$0.LOG.info("AsyncProcessKey scheduled processKeysMessage, executed.");
            }
        };
        this.LOG.info("Scheduling processKeysMessage, delegated to " + String.valueOf(t));
        t.start();
    }

    private void processKeysMessage(SignalServiceProtos.SyncMessage.Keys keysMessage) {
        this.LOG.info("ProcessKeysMessage");
        if (keysMessage.hasMaster()) {
            this.LOG.info("Set master key");
            byte[] mkb = keysMessage.getMaster().toByteArray();
            this.sqliteStorageBean.account().setMasterKey(mkb);
            MasterKey masterKey = new MasterKey(mkb);
            StorageKey storageKey = masterKey.deriveStorageServiceKey();
            this.sqliteStorageBean.storage().setStorageKey(storageKey);
            this.LOG.info("Also stored storage key");
            this.equation.syncStorage();
        }
        if (keysMessage.hasStorageService()) {
            this.LOG.warning("Keys message still has a storageKey, but we ignore this.");
        }
    }

    private void processViewedStories(List<SignalServiceProtos.SyncMessage.Viewed> stories) {
        for (SignalServiceProtos.SyncMessage.Viewed msg : stories) {
            this.LOG.info("TODO! process viewed story for " + String.valueOf(msg));
        }
    }
}

