/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation;

import io.privacyresearch.clientdata.SqliteStorageBean;
import io.privacyresearch.clientdata.keys.IdentityData;
import io.privacyresearch.clientdata.keys.IdentityStoreRecord;
import io.privacyresearch.clientdata.user.UserKey;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.signal.libsignal.protocol.IdentityKey;
import org.signal.libsignal.protocol.IdentityKeyPair;
import org.signal.libsignal.protocol.InvalidKeyIdException;
import org.signal.libsignal.protocol.NoSessionException;
import org.signal.libsignal.protocol.ServiceId;
import org.signal.libsignal.protocol.SignalProtocolAddress;
import org.signal.libsignal.protocol.groups.state.SenderKeyRecord;
import org.signal.libsignal.protocol.state.IdentityKeyStore;
import org.signal.libsignal.protocol.state.KyberPreKeyRecord;
import org.signal.libsignal.protocol.state.PreKeyRecord;
import org.signal.libsignal.protocol.state.SessionRecord;
import org.signal.libsignal.protocol.state.SignedPreKeyRecord;
import org.whispersystems.signalservice.api.SignalServiceAccountDataStore;
import org.whispersystems.signalservice.api.util.CredentialsProvider;

public class WaveStore
implements SignalServiceAccountDataStore {
    private ServiceId serviceId;
    private IdentityKeyPair identityKeyPair;
    private CredentialsProvider credentialsProvider;
    private boolean initialized;
    private final Map<SignalProtocolAddress, IdentityKey> trustedKeys = new HashMap<SignalProtocolAddress, IdentityKey>();
    private int deviceId;
    private String myUuid = "nobody";
    private final SqliteStorageBean sqliteStorageBean;
    private static final Logger LOG = Logger.getLogger(WaveStore.class.getName());
    private final Type type;
    private static final int TIMESTAMP_THRESHOLD_SECONDS = 5;

    public WaveStore(Type kind, SqliteStorageBean sqliteStorageBean) {
        this.type = kind;
        LOG.info("info create Wavestore " + String.valueOf(this) + " with kind " + String.valueOf((Object)kind));
        this.sqliteStorageBean = sqliteStorageBean;
        this.initialize();
    }

    public void reinitialize() {
        LOG.warning("Asked to reinitialize wavestore. Should only happen for testing.");
        LOG.info("Current serviceid = " + String.valueOf(this.serviceId) + " and aci = " + String.valueOf(this.credentialsProvider.getAci()));
        this.initialize();
    }

    private void initialize() {
        this.credentialsProvider = new DynamicCredentialsProvider(this.sqliteStorageBean);
        boolean bl = this.initialized = this.credentialsProvider.getAci() != null || this.credentialsProvider.getPni() != null;
        if (this.initialized) {
            ServiceId.Aci myAci = this.credentialsProvider.getAci();
            if (this.type == Type.ACI && myAci != null) {
                this.serviceId = myAci;
                this.myUuid = this.credentialsProvider.getAci().toServiceIdString();
            }
            ServiceId.Pni myPni = this.credentialsProvider.getPni();
            if (this.type == Type.PNI && myPni != null) {
                this.serviceId = myPni;
            }
            try {
                this.deviceId = this.sqliteStorageBean.account().getDeviceId();
                LOG.info("My deviceid = " + this.deviceId);
                this.retrieveIdentityKeyPair();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            LOG.info("Initialized wavestore with serviceid = " + String.valueOf(this.serviceId) + " of type " + String.valueOf((Object)this.type));
        } else {
            LOG.info("This wavestore is not initialized.");
        }
    }

    public void setServiceId(ServiceId me) {
        LOG.info("Set ServiceId for " + String.valueOf(this) + " to " + String.valueOf(me));
        if (this.serviceId != null) {
            if (this.serviceId.equals((Object)me)) {
                LOG.info("We already have this service id already, only do this when relinking!");
                return;
            }
            throw new IllegalArgumentException("Can't change serviceId from a WaveStore!");
        }
        this.serviceId = me;
        this.initialize();
    }

    public ServiceId getServiceId() {
        return this.serviceId;
    }

    public boolean isInitialized() {
        LOG.fine("WaveStore.isInitialized asked, will return " + this.initialized);
        return this.initialized;
    }

    public void setMyUuid(String v) {
        this.myUuid = v;
    }

    public String getMyUuid() {
        return this.myUuid;
    }

    public void setDeviceId(int devid) {
        this.deviceId = devid;
    }

    public IdentityKeyPair getIdentityKeyPair() {
        if (this.identityKeyPair == null) {
            try {
                this.retrieveIdentityKeyPair();
            }
            catch (IOException ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
        }
        LOG.info("get keypair for me = " + String.valueOf(this.serviceId) + " on store with type " + String.valueOf((Object)this.type) + " will return " + String.valueOf(this.identityKeyPair));
        return this.identityKeyPair;
    }

    public int getLocalRegistrationId() {
        return Integer.parseInt(this.sqliteStorageBean.account().getRegistrationId());
    }

    public boolean saveIdentity(SignalProtocolAddress address, IdentityKey identityKey) {
        return this.saveIdentity(address, identityKey, false);
    }

    public boolean saveIdentity(SignalProtocolAddress address, IdentityKey identityKey, boolean nonBlockingApproval) {
        boolean identityKeyChanged;
        LOG.info("Save identity for " + String.valueOf(address) + " with nonblockingApproval = " + nonBlockingApproval);
        IdentityStoreRecord record = this.sqliteStorageBean.getIdentityData().findByAddress(address);
        if (record == null) {
            LOG.info("Saving new identity for " + String.valueOf(address));
            this.sqliteStorageBean.getIdentityData().add(address, identityKey, 0, true, System.currentTimeMillis(), nonBlockingApproval);
            return true;
        }
        boolean bl = identityKeyChanged = !record.identityKey().equals((Object)identityKey);
        if (identityKeyChanged) {
            LOG.info("IdentityKey changed for " + address.getName());
            ServiceId serviceId = address.getServiceId();
            UserKey userKey = this.sqliteStorageBean.getUserData().getOrCreateUserKeyForServiceId(serviceId);
            this.sqliteStorageBean.getIdentityData().update(address, identityKey, 0, false, System.currentTimeMillis(), nonBlockingApproval);
            this.sqliteStorageBean.getSenderKeySharedWithData().deleteAllFor(userKey);
            this.deleteAllSessions(address.getName());
        }
        return true;
    }

    public boolean isTrustedIdentity(SignalProtocolAddress address, IdentityKey identityKey, IdentityKeyStore.Direction direction) {
        String name = address.getName();
        ServiceId.Aci aci = this.sqliteStorageBean.account().getAci();
        String aciName = aci != null ? aci.toString() : "";
        ServiceId.Pni pni = this.sqliteStorageBean.account().getPni();
        String pniName = pni != null ? pni.toString() : "";
        String e164 = this.sqliteStorageBean.account().getE164();
        boolean isSelf = name.equals(aciName) || name.equals(pniName) || name.equals(e164);
        LOG.info("IsTrusted Identity asked for " + String.valueOf(address) + " and identity = " + String.valueOf(identityKey) + " and name = " + name + " and self = " + isSelf + " and direction = " + String.valueOf(direction));
        if (isSelf) {
            return identityKey.equals((Object)this.sqliteStorageBean.account().getAciIdentityKey().getPublicKey());
        }
        IdentityStoreRecord record = this.sqliteStorageBean.getIdentityData().findByAddress(address);
        switch (direction) {
            case SENDING: {
                return this.isTrustedForSending(identityKey, record);
            }
            case RECEIVING: {
                return true;
            }
        }
        throw new IllegalArgumentException("Illegal direction " + String.valueOf(direction));
    }

    public IdentityKey getIdentity(SignalProtocolAddress address) {
        IdentityStoreRecord isRecord = this.sqliteStorageBean.getIdentityData().findByAddress(address);
        if (isRecord != null) {
            return isRecord.identityKey();
        }
        return null;
    }

    private boolean isTrustedForSending(IdentityKey key, IdentityStoreRecord record) {
        if (record == null) {
            LOG.warning("No record found, assume trusted for sending");
            return true;
        }
        if (!key.equals((Object)record.identityKey())) {
            LOG.warning("Key different from stored one on " + record.name() + ", don't trust!");
            return false;
        }
        if (record.verifiedStatus() == IdentityData.VerifiedStatus.UNVERIFIED.ordinal()) {
            LOG.warning("Needs unverified approval");
            return false;
        }
        if (this.isNonBlockingApprovalRequired(record)) {
            LOG.warning("Needs non-blocking approval");
            return false;
        }
        return true;
    }

    private boolean isNonBlockingApprovalRequired(IdentityStoreRecord record) {
        LOG.info("do we need nonblocking approval for " + record.name() + " with nba = " + record.nonBlockingApproval() + " and firstuse = " + record.firstUse());
        LOG.info("Timestamp = " + record.timestamp() + " and diff = " + (System.currentTimeMillis() - record.timestamp()));
        return !record.firstUse() && !record.nonBlockingApproval() && System.currentTimeMillis() - record.timestamp() < TimeUnit.SECONDS.toMillis(5L);
    }

    public PreKeyRecord loadPreKey(int i) throws InvalidKeyIdException {
        PreKeyRecord answer = this.sqliteStorageBean.getPreKeyData().findById(this.serviceId, i);
        LOG.info("PreKey " + i + " requested, return " + String.valueOf(answer));
        return answer;
    }

    public void storePreKey(int i, PreKeyRecord pkr) {
        if (pkr.getId() != i) {
            throw new IllegalArgumentException("PreKeyRecord has id different from passed id");
        }
        try {
            this.sqliteStorageBean.getPreKeyData().add(this.serviceId, pkr);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    public boolean containsPreKey(int i) {
        PreKeyRecord answer = this.sqliteStorageBean.getPreKeyData().findById(this.serviceId, i);
        LOG.info("PREKEY " + i + "? " + String.valueOf(answer));
        return answer != null;
    }

    public void removePreKey(int keyId) {
        LOG.info("Need to remove PreKey with id " + keyId);
        this.sqliteStorageBean.getPreKeyData().deleteByKeyId(keyId);
    }

    public SignedPreKeyRecord loadSignedPreKey(int i) throws InvalidKeyIdException {
        SignedPreKeyRecord answer = this.sqliteStorageBean.getSignedPreKeyData().findById(this.serviceId, i);
        LOG.info("Return signedprekey " + i + ": " + String.valueOf(answer));
        return answer;
    }

    public List<SignedPreKeyRecord> loadSignedPreKeys() {
        try {
            List all = this.sqliteStorageBean.getSignedPreKeyData().findAll();
            LOG.info("Load all signed prekeys, answer = " + String.valueOf(all));
            return all;
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
    }

    public void storeSignedPreKey(int i, SignedPreKeyRecord spkr) {
        try {
            this.sqliteStorageBean.getSignedPreKeyData().add(this.serviceId, spkr);
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    public boolean containsSignedPreKey(int i) {
        SignedPreKeyRecord answer = this.sqliteStorageBean.getSignedPreKeyData().findById(this.serviceId, i);
        return answer != null;
    }

    public void removeSignedPreKey(int i) {
        this.sqliteStorageBean.getSignedPreKeyData().deleteByKeyId(i);
    }

    public synchronized SessionRecord loadSession(SignalProtocolAddress remoteAddress) {
        SessionRecord answer = this.sqliteStorageBean.getSessionData().loadSession(this.serviceId, remoteAddress);
        LOG.finer("loadSession asked for " + String.valueOf(remoteAddress) + " results in " + String.valueOf(answer));
        if (answer == null) {
            answer = new SessionRecord();
        }
        return answer;
    }

    public synchronized List<Integer> getSubDeviceSessions(String name) {
        List answer = this.sqliteStorageBean.getSessionData().getSubDevices(this.serviceId, name);
        LOG.info("GetSubDeviceSessions asked for " + name + ", mydeviceid = " + this.deviceId + ", answer = " + String.valueOf(answer));
        return answer;
    }

    public synchronized void storeSession(SignalProtocolAddress address, SessionRecord record) {
        try {
            LOG.info("Storing session for " + String.valueOf(address) + " with senderchain? " + record.hasSenderChain());
            this.sqliteStorageBean.getSessionData().store(this.serviceId, address, record);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    public synchronized boolean containsSession(SignalProtocolAddress address) {
        SessionRecord sessionRecord = this.loadSession(address);
        boolean answer = sessionRecord != null;
        LOG.finer("asked for " + String.valueOf(address) + ", answer = " + answer);
        if (answer) {
            try {
                LOG.finest("will check senderChain on " + String.valueOf(address));
                answer = sessionRecord.hasSenderChain();
                LOG.info("Did check senderChain on " + String.valueOf(address) + ", answer = " + answer);
                if (!answer) {
                    LOG.info("Invalid session for " + String.valueOf(address));
                    LOG.info("has senderChain? " + sessionRecord.hasSenderChain() + " and version = " + sessionRecord.getSessionVersion());
                    if (sessionRecord.hasSenderChain()) {
                        LOG.info("Session has senderchain, but version is unexpected. Overrule, and allow this to pass");
                        answer = true;
                    }
                }
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "Error checking session", ex);
                ex.printStackTrace();
                answer = false;
            }
        }
        return answer;
    }

    public synchronized void deleteSession(SignalProtocolAddress address) {
        LOG.info("Delete session for " + address.getName());
        this.sqliteStorageBean.getSessionData().delete(this.serviceId, address);
    }

    public synchronized void deleteAllSessions(String name) {
        LOG.info("Delete all sessions for " + name);
        this.sqliteStorageBean.getSessionData().deleteAllFor(this.serviceId, name);
    }

    public void archiveSession(SignalProtocolAddress address) {
        LOG.info("We need to archive session with address " + address.getName());
        SessionRecord session = this.loadSession(address);
        if (session != null) {
            session.archiveCurrentState();
            this.storeSession(address, session);
        }
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public void setPni(String myPni) {
        try {
            this.sqliteStorageBean.account().setPni(ServiceId.Pni.parseFromString((String)myPni));
        }
        catch (ServiceId.InvalidServiceIdException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    private boolean retrieveIdentityKeyPair() throws IOException {
        if (this.serviceId == null) {
            return false;
        }
        LOG.info("Get identityKeypair for store " + String.valueOf(this) + " and sid = " + String.valueOf(this.serviceId) + " of class " + String.valueOf(this.serviceId.getClass()));
        if (this.serviceId instanceof ServiceId.Aci) {
            this.identityKeyPair = this.sqliteStorageBean.account().getAciIdentityKey();
        } else if (this.serviceId instanceof ServiceId.Pni) {
            this.identityKeyPair = this.sqliteStorageBean.account().getPniIdentityKey();
        } else {
            throw new IllegalArgumentException("No ACI/PNI identity found!");
        }
        return this.identityKeyPair != null;
    }

    public Set<SignalProtocolAddress> getAllAddressesWithActiveSessions(List<String> addressNames) {
        LOG.info("Need to get all SignalProtocolAddresses for " + addressNames.size() + " addressnames ");
        LOG.fine("Need to get all SignalProtocolAddresses for address named " + String.valueOf(addressNames));
        HashSet records = new HashSet();
        for (String name : addressNames) {
            List one = this.sqliteStorageBean.getSessionData().getAllFor(this.serviceId, name);
            records.addAll(one);
        }
        Set<SignalProtocolAddress> answer = records.stream().filter(entry -> entry.getRecord().hasSenderChain()).map(entry -> new SignalProtocolAddress(entry.getName(), entry.getDeviceId())).collect(Collectors.toSet());
        LOG.info("Will return " + answer.size() + " answers.");
        LOG.fine("Will return " + String.valueOf(answer));
        return answer;
    }

    public Set<SignalProtocolAddress> getSenderKeySharedWith(UUID distributionId) {
        LOG.info("get senderkey for " + String.valueOf(distributionId));
        Set answer = this.sqliteStorageBean.getSenderKeySharedWithData().getSharedWith(distributionId);
        LOG.info("answer = " + String.valueOf(answer));
        return answer;
    }

    public void markSenderKeySharedWith(UUID distributionId, Collection<SignalProtocolAddress> addresses) {
        this.sqliteStorageBean.getSenderKeySharedWithData().markAsShared(distributionId, addresses);
    }

    public void clearSenderKeySharedWith(Collection<SignalProtocolAddress> addresses) {
        LOG.info("[WS] clearSenderKeys for " + String.valueOf(addresses));
        for (SignalProtocolAddress address : addresses) {
            this.sqliteStorageBean.getSenderKeySharedWithData().deleteAllFor(address);
        }
    }

    public void storeSenderKey(SignalProtocolAddress sender, UUID distributionId, SenderKeyRecord record) {
        LOG.info("store senderKey for spa = " + String.valueOf(sender) + " and did = " + String.valueOf(distributionId));
        this.sqliteStorageBean.getSenderKeyData().add(sender, distributionId, record);
    }

    public SenderKeyRecord loadSenderKey(SignalProtocolAddress sender, UUID distributionId) {
        LOG.info("senderKey asked for spa = " + String.valueOf(sender) + " and did = " + String.valueOf(distributionId));
        return this.sqliteStorageBean.getSenderKeyData().load(sender, distributionId);
    }

    public boolean isMultiDevice() {
        return true;
    }

    public List<SessionRecord> loadExistingSessions(List<SignalProtocolAddress> addresses) throws NoSessionException {
        LOG.info("asked for " + addresses.size() + " addresses");
        LinkedList<SessionRecord> answer = new LinkedList<SessionRecord>();
        for (SignalProtocolAddress addy : addresses) {
            if (this.containsSession(addy)) {
                SessionRecord record = this.loadSession(addy);
                answer.add(record);
                continue;
            }
            LOG.warning("No valid session for address " + String.valueOf(addy) + ". Do not Archive and retry");
        }
        LOG.info("Return for " + answer.size() + " addresses");
        if (addresses.size() != answer.size()) {
            LOG.severe("mismatch between " + addresses.size() + " addresses and " + answer.size() + " sessions.");
            String message = "Mismatch! Asked for " + addresses.size() + " sessions, but only found " + answer.size();
            throw new NoSessionException(message);
        }
        return answer;
    }

    public KyberPreKeyRecord loadKyberPreKey(int kyberPreKeyId) throws InvalidKeyIdException {
        KyberPreKeyRecord answer = this.sqliteStorageBean.getKyberPreKeyData().findById(this.serviceId, kyberPreKeyId);
        LOG.info("PreKey " + kyberPreKeyId + " requested, return " + String.valueOf(answer));
        return answer;
    }

    public List<KyberPreKeyRecord> loadKyberPreKeys() {
        return this.sqliteStorageBean.getKyberPreKeyData().findAllByServiceId(this.serviceId);
    }

    public void storeKyberPreKey(int kyberPreKeyId, KyberPreKeyRecord record) {
        LOG.info("Storing kyberprekey with id " + kyberPreKeyId + " with recordid = " + record.getId());
        this.sqliteStorageBean.getKyberPreKeyData().add(this.serviceId, kyberPreKeyId, record, false);
    }

    public boolean containsKyberPreKey(int kyberPreKeyId) {
        return this.sqliteStorageBean.getKyberPreKeyData().findById(this.serviceId, kyberPreKeyId) != null;
    }

    public void markKyberPreKeyUsed(int kyberPreKeyId) {
        LOG.info("Mark KyberPreKey used for id = " + kyberPreKeyId);
        this.sqliteStorageBean.getKyberPreKeyData().deleteIfNotLastResort(this.serviceId, kyberPreKeyId);
    }

    public void markAllOneTimeEcPreKeysStaleIfNecessary(long staleTime) {
        this.sqliteStorageBean.getKyberPreKeyData().markAllStaleIfNecessary(this.serviceId, staleTime);
    }

    public void deleteAllStaleOneTimeEcPreKeys(long threshold, int minCount) {
        this.sqliteStorageBean.getKyberPreKeyData().deleteAllStaleBefore(this.serviceId, threshold, minCount);
    }

    public void storeLastResortKyberPreKey(int kyberPreKeyId, KyberPreKeyRecord record) {
        LOG.info("Store lastResortKyberPreKey");
        this.sqliteStorageBean.getKyberPreKeyData().add(this.serviceId, kyberPreKeyId, record, true);
    }

    public List<KyberPreKeyRecord> loadLastResortKyberPreKeys() {
        return this.sqliteStorageBean.getKyberPreKeyData().getAllLastResort(this.serviceId);
    }

    public void removeKyberPreKey(int kyberPreKeyId) {
        this.sqliteStorageBean.getKyberPreKeyData().delete(this.serviceId, kyberPreKeyId);
    }

    public void markAllOneTimeKyberPreKeysStaleIfNecessary(long staleTime) {
        this.sqliteStorageBean.getKyberPreKeyData().markAllStaleIfNecessary(this.serviceId, staleTime);
    }

    public void deleteAllStaleOneTimeKyberPreKeys(long threshold, int minCount) {
        this.sqliteStorageBean.getKyberPreKeyData().deleteAllStaleBefore(this.serviceId, threshold, minCount);
    }

    boolean deleteDirectoryIfExists(Path target) throws IOException {
        if (target == null || !Files.exists(target, new LinkOption[0])) {
            System.err.println("didn't exist");
            return false;
        }
        File[] children = target.toFile().listFiles();
        if (children != null) {
            for (File child : children) {
                this.deleteDirectoryIfExists(child.toPath());
            }
        }
        return Files.deleteIfExists(target);
    }

    private void makeDirectoryPrivate(File f) {
        f.setReadable(false);
        f.setWritable(false);
        f.setExecutable(false);
        f.setReadable(true, true);
        f.setWritable(true, true);
        f.setExecutable(true, true);
        String modus = "rwx------";
        Set<PosixFilePermission> permissions = PosixFilePermissions.fromString(modus);
        try {
            Files.setPosixFilePermissions(f.toPath(), permissions);
        }
        catch (UnsupportedOperationException uo) {
            LOG.info("Posix unsupported.");
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    private Set<SignalProtocolAddress> fromStringAddress(Set<String> orig) {
        return orig.stream().map(s -> WaveStore.fromStringAddress(s)).collect(Collectors.toSet());
    }

    protected static SignalProtocolAddress fromStringAddress(String s) {
        int c = s.indexOf(":");
        if (c < 0) {
            c = s.indexOf(".");
        }
        return new SignalProtocolAddress(s.substring(0, c), Integer.parseInt(s.substring(c + 1)));
    }

    static enum Type {
        ACI,
        PNI;

    }

    static class DynamicCredentialsProvider
    implements CredentialsProvider {
        private final SqliteStorageBean sqliteStorageBean;
        ServiceId.Aci aci = null;
        ServiceId.Pni pni = null;
        String e164 = null;
        int deviceId = -1;

        public DynamicCredentialsProvider(SqliteStorageBean sqliteStorageBean) {
            this.sqliteStorageBean = sqliteStorageBean;
        }

        public ServiceId.Aci getAci() {
            if (this.aci == null) {
                this.aci = this.sqliteStorageBean.account().getAci();
            }
            return this.aci;
        }

        public ServiceId.Pni getPni() {
            if (this.pni == null) {
                this.pni = this.sqliteStorageBean.account().getPni();
            }
            return this.pni;
        }

        public String getE164() {
            if (this.e164 == null) {
                this.e164 = this.sqliteStorageBean.account().getE164();
            }
            return this.e164;
        }

        public int getDeviceId() {
            if (this.deviceId == -1) {
                this.deviceId = this.sqliteStorageBean.account().getDeviceId();
            }
            return this.deviceId;
        }

        public String getPassword() {
            LOG.info("Get password from bean " + String.valueOf(this.sqliteStorageBean));
            return this.sqliteStorageBean.account().getServicePassword();
        }

        public String getDeviceUuid() {
            int devid = this.getDeviceId();
            return this.getAci().toServiceIdString() + (String)(devid > 1 ? "." + devid : "");
        }
    }
}

