/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation;

import com.google.protobuf.ByteString;
import io.privacyresearch.clientdata.EntityKey;
import io.privacyresearch.clientdata.call.CallData;
import io.privacyresearch.clientdata.call.CallDbRecord;
import io.privacyresearch.clientdata.call.CallKey;
import io.privacyresearch.clientdata.recipient.RecipientKey;
import io.privacyresearch.clientdata.user.UserDbRecord;
import io.privacyresearch.clientdata.util.UUIDUtil;
import io.privacyresearch.equation.EquationManager;
import io.privacyresearch.equation.WaveStore;
import io.privacyresearch.equation.call.CallRecord;
import io.privacyresearch.equation.model.Call;
import io.privacyresearch.equation.model.GroupCall;
import io.privacyresearch.equation.ring.AttachCameraManager;
import io.privacyresearch.equation.ring.CameraManager;
import io.privacyresearch.equation.signal.SignalBridge;
import io.privacyresearch.equation.user.UserRecord;
import io.privacyresearch.equation.user.UserService;
import io.privacyresearch.tringapi.PeekInfo;
import io.privacyresearch.tringapi.TringApi;
import io.privacyresearch.tringapi.TringBridge;
import io.privacyresearch.tringapi.TringFrame;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.signal.libsignal.protocol.ServiceId;
import org.signal.libsignal.protocol.SignalProtocolAddress;
import org.whispersystems.signalservice.api.messages.calls.AnswerMessage;
import org.whispersystems.signalservice.api.messages.calls.IceUpdateMessage;
import org.whispersystems.signalservice.api.messages.calls.OfferMessage;
import org.whispersystems.signalservice.api.messages.calls.SignalServiceCallMessage;
import org.whispersystems.signalservice.api.messages.calls.TurnServerInfo;
import org.whispersystems.signalservice.api.push.SignalServiceAddress;
import org.whispersystems.signalservice.internal.SignalServiceProtos;

public class WaveCallManager
implements TringApi {
    private static final Logger LOG = Logger.getLogger(WaveCallManager.class.getName());
    private final EquationManager waveManager;
    private final WaveStore waveStore;
    private final CallData callDb;
    private final UserService userService;
    private final SignalBridge signalBridge;
    private final CameraManager cameraManager;
    private Call activeCall;
    private boolean acceptVideo = true;
    private boolean outgoingVideo = false;
    TringBridge tringBridge;
    private List demuxIds;

    public void groupCallUpdateRing(byte[] groupId, long ringId, byte[] senderBytes, byte status) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void receivedGroupCallPeekForRingingCheck(PeekInfo peekInfo) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public byte[] requestGroupMembershipToken(byte[] groupId) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public byte[] requestGroupMemberInfo(byte[] groupId) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void sendOpaqueCallMessage(UUID recipient, byte[] opaque, int urgency) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public WaveCallManager(EquationManager waveManager, CallData callDb, UserService userService, SignalBridge signalBridge) {
        this.waveManager = waveManager;
        this.waveStore = waveManager.getWaveStore();
        this.userService = userService;
        this.signalBridge = signalBridge;
        this.callDb = callDb;
        this.cameraManager = new AttachCameraManager();
    }

    public Call handleCallOfferMessage(SignalServiceProtos.Content content, SignalServiceProtos.CallMessage.Offer message, UserDbRecord dbSender, int senderDeviceId, long timestamp) {
        long callId = message.getId();
        if (this.dbHasCallId(callId)) {
            LOG.info("We already have this call in our db. Ignore");
            return null;
        }
        UserRecord sender = this.userService.getUserRecordFromDb(dbSender);
        ServiceId serviceId = sender.getServiceId().get();
        SignalServiceAddress senderAddress = new SignalServiceAddress(serviceId);
        LOG.info("Got callOffser from " + String.valueOf(serviceId));
        CallDbRecord.Type type = CallDbRecord.Type.UNKNOWN;
        if (message.getType() == SignalServiceProtos.CallMessage.Offer.Type.OFFER_AUDIO_CALL) {
            type = CallDbRecord.Type.AUDIO_CALL;
        } else if (message.getType() == SignalServiceProtos.CallMessage.Offer.Type.OFFER_VIDEO_CALL) {
            type = CallDbRecord.Type.VIDEO_CALL;
        }
        CallKey callKey = this.callDb.createIncomingCall(callId, sender.recipient().key(), sender.recipient().key(), type);
        long timediff = System.currentTimeMillis() - timestamp;
        if (timediff > 60000L) {
            LOG.info("Incoming call stored, don't process anymore, ts = " + timestamp + " and diff = " + timediff);
            return null;
        }
        Call call = new Call(callKey, Call.Direction.IN, callId, sender, senderDeviceId);
        call.setType(type);
        this.receivedOffer(call, content, message, senderAddress, senderDeviceId);
        return call;
    }

    void receivedOffer(Call call, SignalServiceProtos.Content content, SignalServiceProtos.CallMessage.Offer message, SignalServiceAddress senderAddress, int senderDeviceId) {
        this.ensureTringBridge();
        this.activeCall = call;
        byte[] opaque = message.getOpaque().toByteArray();
        int localDeviceId = this.getLocalDeviceId();
        SignalProtocolAddress addy = new SignalProtocolAddress(senderAddress.getIdentifier(), senderDeviceId);
        byte[] senderKey = this.waveStore.getIdentity(addy).getPublicKey().getPublicKeyBytes();
        byte[] receiverKey = this.waveStore.getIdentityKeyPair().getPublicKey().getPublicKey().getPublicKeyBytes();
        this.tringBridge.receivedOffer("REMOTEPEER", call.getCallId(), senderDeviceId, localDeviceId, senderKey, receiverKey, opaque);
    }

    void receivedAnswer(long callId, SignalServiceProtos.Content content, SignalServiceProtos.CallMessage.Answer message, SignalServiceAddress senderAddress, int senderDeviceId) {
        LOG.info("Process receivedAnswer");
        this.ensureTringBridge();
        byte[] opaque = message.getOpaque().toByteArray();
        int localDeviceId = this.getLocalDeviceId();
        SignalProtocolAddress addy = new SignalProtocolAddress(senderAddress.getIdentifier(), senderDeviceId);
        byte[] senderKey = this.waveStore.getIdentity(addy).getPublicKey().getPublicKeyBytes();
        byte[] receiverKey = this.waveStore.getIdentityKeyPair().getPublicKey().getPublicKey().getPublicKeyBytes();
        this.tringBridge.receivedAnswer("REMOTEPEER", callId, senderDeviceId, senderKey, receiverKey, opaque);
    }

    Call receivedOpaqueMessage(ServiceId.Aci aci, int senderDeviceId, byte[] omsg) {
        LOG.info("Process opaquemessage");
        this.ensureTringBridge();
        if (this.activeCall != null) {
            LOG.info("We have a matching call");
            LOG.info("ar = " + String.valueOf(this.activeCall.getRecipient()));
            LOG.info("ars = " + String.valueOf(this.activeCall.getRecipient().getServiceId()));
            LOG.info("Aci = " + String.valueOf(aci));
            LOG.info("eq? " + this.activeCall.getRecipient().getServiceId().equals(aci));
            LOG.info("eq?2 " + this.activeCall.getRecipient().getServiceId().get().equals((Object)aci));
        } else {
            LOG.info("We will create a new call object for this one");
            long id = new Random().nextLong();
            this.activeCall = this.userService.getUserByAci(aci).map(user -> {
                CallKey callKey = this.callDb.createIncomingCall(id, user.recipient().key(), user.recipient().key(), CallDbRecord.Type.GROUP_CALL);
                return new GroupCall(callKey, Call.Direction.IN, id, (UserRecord)user);
            }).orElse(null);
        }
        this.waveManager.getMessageListener().gotCallUpdate(this.activeCall);
        LOG.warning("CHECK ME, sending aci as bytes to tringbridge, hope that works?");
        this.tringBridge.receivedOpaqueMessage(aci.toServiceIdBinary(), senderDeviceId, this.getLocalDeviceId(), omsg, 0L);
        return this.activeCall;
    }

    void acceptCall() {
        this.ensureTringBridge();
        LOG.info("App accepts call, tell ringtc and use call " + String.valueOf(this.activeCall));
        if (this.activeCall instanceof GroupCall) {
            byte[] groupId = new byte[]{};
            this.tringBridge.createGroupCallClient(groupId, "https://sfu.voip.signal.org", new byte[0]);
            this.startSendingVideo();
        } else {
            this.tringBridge.acceptCall();
        }
        LOG.info("App accepts call, told ringtc");
        this.activeCall.state().set((Object)Call.CallState.CONNECTED);
    }

    void ignoreCall() {
        this.ensureTringBridge();
        this.tringBridge.ignoreCall();
    }

    void hangupCall(Call call) {
        Thread.dumpStack();
        Call.CallState status = (Call.CallState)((Object)call.state().get());
        LOG.info("WaveManager is asked to hangup a call with status " + String.valueOf((Object)status));
        if (status == Call.CallState.REMOTE_RINGING) {
            SignalServiceProtos.CallMessage message = SignalServiceProtos.CallMessage.newBuilder().setHangup(SignalServiceProtos.CallMessage.Hangup.newBuilder().setType(SignalServiceProtos.CallMessage.Hangup.Type.HANGUP_NORMAL).setDeviceId(0).setId(call.getCallId())).build();
            this.signalBridge.sendCallMessage(call.getRecipient(), message);
        }
        try {
            CallKey callKey = this.callDb.findByCallId(call.getCallId());
            if (callKey != null) {
                this.callDb.updateState(callKey, CallDbRecord.State.COMPLETED);
            }
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
        this.hangupCall();
    }

    void hangupCall() {
        LOG.info("App hangsup call, tell ringtc");
        this.cameraManager.stopListening();
        if (this.tringBridge != null) {
            this.tringBridge.enableOutgoingVideo(false);
            this.tringBridge.hangupCall();
        }
        LOG.info("App hangsup call, told ringtc");
    }

    public void enableVideoCall(Call call, boolean enableVideo) {
        LOG.info("Toggle video to " + enableVideo);
        if (call == null) {
            throw new IllegalArgumentException("Don't invoke enableVideoCall with null call");
        }
        LOG.info("we are asked to " + (enableVideo ? "enable" : "disable") + " video, call = " + String.valueOf(call) + " and activecall = " + String.valueOf(this.activeCall));
        if (this.activeCall == null) {
            this.activeCall = call;
        }
        if (((Call.CallState)((Object)this.activeCall.state().get())).equals((Object)Call.CallState.TERMINATED)) {
            this.activeCall = call;
        }
        if (!this.activeCall.equals(call)) {
            throw new IllegalArgumentException("Cannot enable video for this call as we have another active call in state " + String.valueOf(this.activeCall.state()));
        }
        LOG.info("CallState = " + String.valueOf(call.state().get()));
        this.ensureTringBridge();
        if (enableVideo) {
            this.cameraManager.startListening(frame -> this.gotSelfFrame((CameraManager.Frame)frame));
            this.startSendingVideo();
        } else {
            this.cameraManager.stopListening();
            this.stopSendingVideo();
        }
        this.outgoingVideo = enableVideo;
    }

    public Call startOutgoingCall(RecipientKey recipientKey, boolean enableVideo) {
        LOG.info("Start outgoing call: recipientKey = " + String.valueOf(recipientKey) + " and enableVideo = " + enableVideo);
        UserRecord user = this.userService.getUserByRecipientKey(recipientKey);
        CallDbRecord.Type type = enableVideo ? CallDbRecord.Type.VIDEO_CALL : CallDbRecord.Type.AUDIO_CALL;
        long callId = new Random().nextInt();
        CallKey callKey = this.callDb.createOutgoingCall(callId, recipientKey, this.waveManager.getAccount().getUser().recipient().key(), type);
        Call call = new Call(callKey, Call.Direction.OUT, callId, user);
        call.setType(type);
        this.startOutgoingCall(call, user.getServiceId().get().toString(), enableVideo);
        return call;
    }

    public void startOutgoingCall(Call call, String peerId, boolean enableVideo) {
        this.ensureTringBridge();
        LOG.info("App starts outgoing call with id = " + call.getCallId() + " and recipient = " + String.valueOf(call.getRecipient()) + " and peer = " + peerId);
        this.activeCall = call;
        this.tringBridge.startOutgoingCall(call.getCallId(), peerId, this.getLocalDeviceId(), enableVideo);
        this.outgoingVideo = enableVideo;
    }

    void handleReceivedIceCandidates(int senderDeviceId, List<SignalServiceProtos.CallMessage.IceUpdate> iceMessages) {
        if (iceMessages.size() < 1) {
            LOG.warning("Got an empty receivedIce update, ignoring.");
            return;
        }
        if (this.activeCall == null) {
            LOG.warning("We received ice candidates but have no active call. Ignore.");
            return;
        }
        long callid = -1L;
        ArrayList<byte[]> ice = new ArrayList<byte[]>();
        for (SignalServiceProtos.CallMessage.IceUpdate msg : iceMessages) {
            callid = msg.getId();
            ice.add(msg.getOpaque().toByteArray());
        }
        LOG.info("Dealing with received icecandidates, callid = " + callid + " and activecallid = " + this.activeCall.getCallId());
        this.tringBridge.receivedIce(callid, senderDeviceId, ice);
    }

    void ensureTringBridge() {
        if (this.tringBridge == null) {
            byte[] me = UUIDUtil.toByteArray((UUID)this.waveManager.getAccount().getUser().aci().getRawUUID());
            this.tringBridge = new TringBridge((TringApi)this, me);
        }
    }

    public byte[] getCallLinkBytes(String url) {
        this.ensureTringBridge();
        return this.tringBridge.getCallLinkBytes(url);
    }

    void cleanupCall() {
        LOG.info("CLEANCALL, state = " + String.valueOf(this.activeCall.state().get()));
        this.stopSendingVideo();
        this.stopAcceptingVideo();
        try {
            CallKey callKey = this.callDb.findByCallId(this.activeCall.getCallId());
            CallDbRecord record = (CallDbRecord)this.callDb.findByKey((EntityKey)callKey);
            this.waveManager.processCallEnded(record);
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    public void statusCallback(long callId, long peerId, int direction, int type) {
        LOG.info("Got statusCall with dir = " + direction + " and callId = " + callId + " and activeCallId = " + this.activeCall.getCallId());
        if (direction == 0) {
            this.handleIncomingCall(callId);
            return;
        }
        if (direction == 1) {
            this.handleOutgoingCall(callId);
            return;
        }
        if (direction == 10) {
            this.activeCall.state().set((Object)(this.activeCall.getDirection() == Call.Direction.IN ? Call.CallState.LOCAL_RINGING : Call.CallState.REMOTE_RINGING));
        }
        if (direction == 20) {
            this.activeCall.state().set((Object)Call.CallState.CONNECTED);
            LOG.info("We are notified about state CONNECTED. Enable outgoing video? " + this.outgoingVideo);
            if (this.outgoingVideo) {
                this.tringBridge.enableOutgoingVideo(true);
            }
        }
        if (direction == 40) {
            this.activeCall.state().set((Object)Call.CallState.TERMINATED);
            this.cleanupCall();
        }
        if (direction == 70) {
            LOG.info("call state changed to ended, but no signaling needed");
        }
        if (direction == 22) {
            if (type == 31) {
                LOG.info("Remote video enabled.");
                this.startAcceptingVideo();
            }
            if (type == 32) {
                LOG.info("Remote video disabled.");
                this.stopAcceptingVideo();
            }
        }
    }

    public void answerCallback(byte[] opaque) {
        boolean broadcast = this.activeCall.getOtherDeviceId() < 0;
        boolean multiring = true;
        LOG.info("We are asked by tring to send answer to the other side.");
        long callId = this.activeCall.getCallId();
        AnswerMessage answerMessage = new AnswerMessage(callId, null, opaque);
        SignalServiceProtos.CallMessage message = SignalServiceProtos.CallMessage.newBuilder().setAnswer(SignalServiceProtos.CallMessage.Answer.newBuilder().setOpaque(ByteString.copyFrom((byte[])opaque)).setId(callId)).build();
        this.sendCallMessage(message);
        LOG.info("Done sending answer to the other side");
    }

    public void offerCallback(byte[] opaque) {
        boolean broadcast = this.activeCall.getOtherDeviceId() < 0;
        boolean multiring = true;
        LOG.info("Send offer, opaque = " + Arrays.toString(opaque));
        LOG.info("And activeCall = " + String.valueOf(this.activeCall) + " with recipient = " + String.valueOf(this.activeCall.getRecipient()) + " and otherdevice = " + this.activeCall.getOtherDeviceId());
        long callId = this.activeCall.getCallId();
        OfferMessage offerMessage = new OfferMessage(callId, null, OfferMessage.Type.AUDIO_CALL, opaque);
        SignalServiceProtos.CallMessage message = SignalServiceProtos.CallMessage.newBuilder().setOffer(SignalServiceProtos.CallMessage.Offer.newBuilder().setId(callId).setType(SignalServiceProtos.CallMessage.Offer.Type.OFFER_AUDIO_CALL).setOpaque(ByteString.copyFrom((byte[])opaque))).build();
        SignalServiceCallMessage sscm = SignalServiceCallMessage.forOffer((OfferMessage)offerMessage, (boolean)multiring, broadcast ? null : Integer.valueOf(this.activeCall.getOtherDeviceId()));
        this.sendCallMessage(message);
        LOG.info("Done sending answer");
    }

    public void iceUpdateCallback(List<byte[]> iceCandidates) {
        LOG.info("App is notified by ringrtc that we have local iceCandidates");
        boolean broadcast = this.activeCall.getOtherDeviceId() < 0;
        long callId = this.activeCall.getCallId();
        SignalServiceProtos.CallMessage.Builder callMessageBuilder = SignalServiceProtos.CallMessage.newBuilder();
        for (byte[] iceBytes : iceCandidates) {
            callMessageBuilder.addIceUpdate(SignalServiceProtos.CallMessage.IceUpdate.newBuilder().setId(callId).setOpaque(ByteString.copyFrom((byte[])iceBytes)));
        }
        List<IceUpdateMessage> iceUpdateMessages = iceCandidates.stream().map(c -> new IceUpdateMessage(this.activeCall.getCallId(), c, null)).toList();
        if (!broadcast) {
            callMessageBuilder.setDestinationDeviceId(this.activeCall.getOtherDeviceId());
        }
        SignalServiceProtos.CallMessage callMessage = callMessageBuilder.build();
        LOG.info("sending " + iceUpdateMessages.size() + " iceupdates to other party, other deviceId = " + this.activeCall.getOtherDeviceId());
        LOG.info("Sending iceUpdate to other party");
        this.sendCallMessage(callMessage);
        LOG.info("Done sending iceUpdate to other party");
    }

    public void updateRemoteDevices(List<Integer> demuxIds) {
    }

    private void handleIncomingCall(long callId) {
        LOG.info("startCall asked with callId = " + callId + " and activeCallId = " + this.activeCall.getCallId());
        TurnServerInfo tsi = this.retrieveTurnServers();
        LOG.info("statusCall will now invoke proceed");
        this.tringBridge.proceed(callId, tsi.getUsername(), tsi.getPassword(), "", tsi.getUrls());
        LOG.info("statusCall proceeded");
    }

    private void handleOutgoingCall(long callId) {
        LOG.info("startCall asked with callId = " + callId);
        if (this.activeCall.getCallId() != callId) {
            LOG.severe("Wrong callId!");
        }
        TurnServerInfo tsi = this.retrieveTurnServers();
        LOG.info("statusCall will now invoke proceed");
        this.tringBridge.proceed(callId, tsi.getUsername(), tsi.getPassword(), "", tsi.getUrls());
        LOG.info("statusCall proceeded, outgoing video = " + this.outgoingVideo);
        if (this.outgoingVideo) {
            this.tringBridge.enableOutgoingVideo(true);
            this.startSendingVideo();
        }
    }

    private void startSendingVideo() {
        this.tringBridge.enableOutgoingVideo(true);
        LOG.warning("VIDEO STILL DISABLED");
    }

    private void stopSendingVideo() {
        this.cameraManager.stopListening();
        this.tringBridge.enableOutgoingVideo(false);
    }

    private void startAcceptingVideo() {
        this.acceptVideo = true;
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    long l0 = System.currentTimeMillis();
                    long c0 = 0L;
                    long c1 = 0L;
                    while (WaveCallManager.this.acceptVideo) {
                        TringFrame frame;
                        int demuxId = 0;
                        if (WaveCallManager.this.demuxIds != null && !WaveCallManager.this.demuxIds.isEmpty()) {
                            demuxId = (Integer)WaveCallManager.this.demuxIds.get(0);
                        }
                        if ((frame = WaveCallManager.this.tringBridge.getRemoteVideoFrame(demuxId)) != null) {
                            LOG.info("Got frame w = " + frame.width + " and h = " + frame.height);
                            WaveCallManager.this.activeCall.addImage(frame.width, frame.height, frame.data);
                            ++c0;
                        } else {
                            ++c1;
                        }
                        long l1 = System.currentTimeMillis();
                        LOG.info("took " + (l1 - l0) + " ms, c0 = " + c0 + ", c1 = " + c1);
                        l0 = l1;
                        Thread.sleep(10L);
                    }
                    if (WaveCallManager.this.activeCall != null) {
                        WaveCallManager.this.activeCall.addImage(0, 0, new byte[0]);
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        };
        t.start();
    }

    private void stopAcceptingVideo() {
        this.acceptVideo = false;
    }

    private void gotSelfFrame(CameraManager.Frame frame) {
        LOG.info("We got a self frame, callstate = " + String.valueOf(this.activeCall.state().get()));
        this.activeCall.addMyImage(frame.getWidth(), frame.getHeight(), frame.getPixelFormat(), frame.getData());
        if (this.activeCall.state().get() == Call.CallState.CONNECTED) {
            if (frame.getPixelFormat() > 100) {
                frame = new CameraManager.Frame(frame.getWidth(), frame.getHeight(), 0, frame.getData());
            }
            this.sendVideoFrame(frame);
        }
    }

    private void sendVideoFrame(CameraManager.Frame frame) {
        LOG.info("Send videoFrame from Equation to Tring, pixelFormat = " + frame.getPixelFormat());
        this.tringBridge.sendVideoFrame(frame.getWidth(), frame.getHeight(), frame.getPixelFormat(), frame.getData());
    }

    TurnServerInfo retrieveTurnServers() {
        try {
            TurnServerInfo turnServerInfo = this.waveManager.getAccountManager().getTurnServerInfo();
            return turnServerInfo;
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private int getLocalDeviceId() {
        return this.waveStore.getCredentialsProvider().getDeviceId();
    }

    void sendCallMessage(SignalServiceProtos.CallMessage sscm) {
        this.signalBridge.sendCallMessage(this.activeCall.getRecipient(), sscm);
    }

    public void processCallEvent(SignalServiceProtos.SyncMessage.CallEvent callEvent) {
        if (this.dbHasCallId(callEvent.getId())) {
            LOG.info("We already have a call in db with this id, don't store again.");
            return;
        }
        ByteString bs = callEvent.getConversationId();
        UUID uuid = UUIDUtil.bytesToUuid((byte[])bs.toByteArray());
        ServiceId.Aci aci = new ServiceId.Aci(uuid);
        if (aci != null) {
            Optional<UserDbRecord> dbUser = this.userService.getDbUserByAci(aci);
            dbUser.ifPresent(userdb -> {
                long callId = callEvent.getId();
                RecipientKey recipientKey = userdb.recipientKey();
                CallDbRecord.Type callType = switch (callEvent.getType()) {
                    case SignalServiceProtos.SyncMessage.CallEvent.Type.AUDIO_CALL -> CallDbRecord.Type.AUDIO_CALL;
                    case SignalServiceProtos.SyncMessage.CallEvent.Type.VIDEO_CALL -> CallDbRecord.Type.VIDEO_CALL;
                    default -> CallDbRecord.Type.UNKNOWN;
                };
                this.callDb.createIncomingCall(callId, recipientKey, recipientKey, callType);
            });
        }
    }

    public void processCallLogEvent(SignalServiceProtos.SyncMessage.CallLogEvent callLogEvent) {
        LOG.info("Process callLogEvent " + String.valueOf(callLogEvent));
        LOG.log(Level.SEVERE, "CallLogEvent not yet supported");
    }

    boolean dbHasCallId(long callId) {
        try {
            if (this.callDb.findByCallId(callId) != null) {
                LOG.info("We already have a call in db with this id, don't store again.");
                return true;
            }
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        return false;
    }

    public List<CallRecord> getAllCalls() {
        try {
            return this.callDb.findAll().stream().map(this::getCallRecordFromDb).toList();
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public CallRecord getCallRecordFromDb(CallDbRecord db) {
        UserRecord userRecord = this.userService.getUserByRecipientKey(db.ringerRecipient().key());
        return new CallRecord(db.key(), db.outgoing(), db.conversationRecipient(), userRecord, db.type(), db.state(), db.timestamp());
    }
}

