/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation;

import com.google.protobuf.InvalidProtocolBufferException;
import io.privacyresearch.clientdata.EntityKey;
import io.privacyresearch.clientdata.group.GroupRecord;
import io.privacyresearch.clientdata.message.InsertMessageRequest;
import io.privacyresearch.clientdata.message.MessageData;
import io.privacyresearch.clientdata.message.MessageDbRecord;
import io.privacyresearch.clientdata.message.MessageKey;
import io.privacyresearch.clientdata.message.StoryType;
import io.privacyresearch.clientdata.recipient.RecipientKey;
import io.privacyresearch.clientdata.recipient.RecipientRecord;
import io.privacyresearch.clientdata.user.UserDbRecord;
import io.privacyresearch.equation.EquationManager;
import io.privacyresearch.equation.attachment.AttachmentPointerUtil;
import io.privacyresearch.equation.attachment.SignalServiceAttachmentPointer;
import io.privacyresearch.equation.model.Story;
import io.privacyresearch.equation.user.UserRecord;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.signal.libsignal.protocol.ServiceId;
import org.whispersystems.signalservice.api.InvalidMessageStructureException;
import org.whispersystems.signalservice.internal.SignalServiceProtos;

public class StoryService {
    private static final Logger LOG = Logger.getLogger(StoryService.class.getName());
    private final EquationManager wave;
    private final MessageData messageData;
    private final Path SIGNAL_FX_ATTACHMENT_DIR;

    public StoryService(EquationManager wave, MessageData messageData) {
        this.wave = wave;
        this.messageData = messageData;
        this.SIGNAL_FX_ATTACHMENT_DIR = wave.getStorageRoot().resolve("attachments");
        this.SIGNAL_FX_ATTACHMENT_DIR.toFile().mkdirs();
    }

    void processIncomingStory(SignalServiceProtos.Envelope envelope, UserDbRecord sender, SignalServiceProtos.StoryMessage msg) {
        boolean allowReplies;
        LOG.info("Got Story message " + msg.toString() + " with timestamp " + envelope.getTimestamp());
        UserRecord senderUserRecord = this.wave.getUserByRecipientKey(sender.recipientKey());
        InsertMessageRequest messageRequest = new InsertMessageRequest();
        messageRequest.setSenderKey(senderUserRecord.key());
        if (msg.hasGroup()) {
            Optional<GroupRecord> optGroup = this.wave.getGroupByMasterKey(msg.getGroup().getMasterKey().toByteArray());
            if (optGroup.isEmpty()) {
                LOG.severe("Got story for unknown group!");
                return;
            }
            GroupRecord groupRecord = optGroup.get();
            messageRequest.setReceiverKey(groupRecord.recipient().key());
        } else {
            messageRequest.setReceiverKey(this.wave.getAccount().getUser().recipient().key());
        }
        long timestamp = envelope.getTimestamp();
        messageRequest.setTimestamp(timestamp);
        messageRequest.setExpireTimestamp(timestamp);
        messageRequest.setExpiration(86400);
        boolean bl = allowReplies = msg.hasAllowsReplies() && msg.getAllowsReplies();
        if (msg.hasTextAttachment()) {
            messageRequest.setStoryType(allowReplies ? StoryType.TEXT_STORY_WITH_REPLIES : StoryType.TEXT_STORY_WITHOUT_REPLIES);
            messageRequest.setContent(this.textAttachmentToString(msg.getTextAttachment()));
        }
        if (msg.hasFileAttachment()) {
            SignalServiceProtos.AttachmentPointer fileAttachment = msg.getFileAttachment();
            messageRequest.setStoryType(allowReplies ? StoryType.STORY_WITH_REPLIES : StoryType.STORY_WITHOUT_REPLIES);
            try {
                SignalServiceAttachmentPointer ssap = AttachmentPointerUtil.createSignalAttachmentPointer(fileAttachment);
                String name = "media" + timestamp;
                Path dest = this.SIGNAL_FX_ATTACHMENT_DIR.resolve("stories").resolve(name);
                Files.createDirectories(dest.getParent(), new FileAttribute[0]);
                this.wave.getSignalBridge().downloadAndStoreAttachmentMedia(ssap, dest);
                messageRequest.setContent(this.fileAttachmentToString(fileAttachment));
            }
            catch (InvalidMessageStructureException ex) {
                Logger.getLogger(StoryService.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(StoryService.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        LOG.info("Got story from author " + (sender == null ? "UNKNOWN" : ((ServiceId)sender.getServiceId().get()).toString()) + " with group? " + msg.hasGroup());
        this.storeAndNotifyListener(messageRequest);
    }

    public void storeStory(SignalServiceProtos.StoryMessage sssm, RecipientRecord recipient) {
        throw new RuntimeException("NYI");
    }

    List<Story> getStories() {
        List records = this.messageData.getStories();
        List<Story> answer = records.stream().map(r -> this.getStoryFromMessageDbRecord((MessageDbRecord)r)).filter(s -> s != null).toList();
        LOG.info("Equation will return " + answer.size() + " stories.");
        return answer;
    }

    public void deleteStoryContents(MessageDbRecord dbRecord) {
        LOG.info("Need to delete story " + dbRecord.dateSent());
        Story story = this.getStoryFromMessageDbRecord(dbRecord);
        story.fileStory().ifPresent(fileStory -> {
            try {
                LOG.info("Will delete file " + String.valueOf(fileStory.getDestination()));
                StoryService.deletePath(fileStory.getDestination());
            }
            catch (IOException ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
        });
    }

    private void storeAndNotifyListener(InsertMessageRequest messageRequest) {
        MessageKey insertedKey = this.messageData.insertMessage(messageRequest);
        MessageDbRecord messageDbRecord = (MessageDbRecord)this.messageData.findByKey((EntityKey)insertedKey);
        Story story = this.getStoryFromMessageDbRecord(messageDbRecord);
        this.wave.getMessageListener().gotStory(story);
    }

    private Story getStoryFromMessageDbRecord(MessageDbRecord record) {
        StoryType type = record.storyType();
        if (type == StoryType.NONE) {
            LOG.warning("Cannot create story if messagedbrecord has no storytype");
            return null;
        }
        if (record.body() == null) {
            LOG.warning("Cannot create story with null body on messagedb record");
            return null;
        }
        long mask = 1L;
        if ((record.flags() & mask) != 0L) {
            LOG.warning("Story was deleted");
            return null;
        }
        Story story = new Story();
        story.setMessageKey(record.key());
        story.setTimestamp(record.dateSent());
        story.setExpiration(record.dateSent() + 86400000L);
        story.setAuthor(this.wave.getUserService().getUserByUserKey(record.senderKey()));
        RecipientKey receiverKey = record.receiverKey();
        GroupRecord groupRecord = this.wave.getGroupRecordByRecipientKey(receiverKey);
        if (groupRecord != null) {
            story.setGroup(groupRecord);
        }
        if (type == StoryType.TEXT_STORY_WITHOUT_REPLIES || type == StoryType.TEXT_STORY_WITH_REPLIES) {
            SignalServiceProtos.TextAttachment textAttachment = this.stringToTextAttachment(record.body());
            Story.TextStory textStory = new Story.TextStory(textAttachment);
            story.setTextStory(textStory);
        } else {
            SignalServiceProtos.AttachmentPointer ap = this.stringToFileAttachment(record.body());
            String name = "media" + record.dateSent();
            Path dest = this.SIGNAL_FX_ATTACHMENT_DIR.resolve("stories").resolve(name);
            Story.FileStory fileStory = new Story.FileStory(dest, ap.getContentType(), ap.hasCaption() ? Optional.of(ap.getCaption()) : Optional.empty());
            story.setFileStory(fileStory);
        }
        return story;
    }

    private String textAttachmentToString(SignalServiceProtos.TextAttachment t) {
        return Base64.getEncoder().encodeToString(t.toByteArray());
    }

    private String fileAttachmentToString(SignalServiceProtos.AttachmentPointer t) {
        return Base64.getEncoder().encodeToString(t.toByteArray());
    }

    private SignalServiceProtos.TextAttachment stringToTextAttachment(String s) {
        try {
            return SignalServiceProtos.TextAttachment.parseFrom((byte[])Base64.getDecoder().decode(s));
        }
        catch (InvalidProtocolBufferException ex) {
            LOG.log(Level.SEVERE, null, ex);
            ex.printStackTrace();
            throw new IllegalArgumentException("Can't decode story");
        }
    }

    private SignalServiceProtos.AttachmentPointer stringToFileAttachment(String s) {
        try {
            return SignalServiceProtos.AttachmentPointer.parseFrom((byte[])Base64.getDecoder().decode(s));
        }
        catch (InvalidProtocolBufferException ex) {
            LOG.log(Level.SEVERE, null, ex);
            ex.printStackTrace();
            throw new IllegalArgumentException("Can't decode story");
        }
    }

    private static void deletePath(Path path) throws IOException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            try (Stream<Path> paths = Files.walk(path, new FileVisitOption[0]);){
                paths.sorted(Comparator.reverseOrder()).forEach(p -> {
                    try {
                        Files.delete(p);
                    }
                    catch (IOException e) {
                        LOG.warning("Failed to delete " + String.valueOf(p) + ": " + String.valueOf(e));
                    }
                });
            }
        } else {
            Files.delete(path);
        }
    }
}

