/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation;

import io.privacyresearch.clientdata.SqliteStorageBean;
import io.privacyresearch.clientdata.recipient.RecipientKey;
import io.privacyresearch.clientdata.user.UserDbRecord;
import io.privacyresearch.equation.EquationManager;
import io.privacyresearch.equation.WaveStore;
import io.privacyresearch.equation.net.NetworkAPI;
import java.io.IOException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.signal.libsignal.protocol.IdentityKey;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.protocol.ServiceId;
import org.signal.libsignal.protocol.SignalProtocolAddress;
import org.signal.libsignal.protocol.state.SessionRecord;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.profiles.ProfileKey;
import org.whispersystems.signalservice.api.profiles.SignalServiceProfile;

public class ProfileManager {
    private static final Logger LOG = Logger.getLogger(ProfileManager.class.getName());
    private final EquationManager wave;
    private final SqliteStorageBean sqliteStorageBean;
    private final NetworkAPI networkApi;
    private final WaveStore store;

    public ProfileManager(EquationManager wave, SqliteStorageBean sqliteStorageBean) {
        this.wave = wave;
        this.sqliteStorageBean = sqliteStorageBean;
        this.networkApi = wave.getSignalBridge().getNetworkAPI();
        this.store = wave.getWaveStore();
    }

    public CompletableFuture<SignalServiceProfile> retrieveAndStoreProfile(ServiceId.Aci aci, byte[] profileKeyBytes, RecipientKey recipientKey) {
        LOG.info("Retrieve profile for " + String.valueOf(aci) + " with recipientKey " + String.valueOf(recipientKey));
        if (recipientKey == null) {
            Thread.dumpStack();
            throw new IllegalArgumentException("RecipientKey can not be null");
        }
        UserDbRecord oldRecord = this.sqliteStorageBean.getUserData().findByAci(aci);
        try {
            CompletableFuture<SignalServiceProfile> retrievedVersionedProfile = this.networkApi.retrieveVersionedProfile(aci, new ProfileKey(profileKeyBytes), Optional.empty(), Locale.getDefault());
            CompletionStage answer = ((CompletableFuture)retrievedVersionedProfile.thenApply(profile -> {
                String avatarProfilePath;
                LOG.info("Got callbacked with our request profile.");
                LOG.info("Profile has capabilities: " + String.valueOf(profile.getCapabilities()));
                String identityKeyString = profile.getIdentityKey();
                byte[] res = Base64.getDecoder().decode(identityKeyString);
                this.storeIdentityKeyIfDifferent(aci.toString(), res);
                LOG.info("Will now ask dbexecutor to store profile for " + String.valueOf(aci));
                this.sqliteStorageBean.getUserData().storeProfile((ServiceId)aci, profile, profileKeyBytes);
                this.sqliteStorageBean.getBadgeData().deleteByUserKey(oldRecord.key());
                profile.getBadges().forEach(signalBadge -> this.sqliteStorageBean.getBadgeData().createBadge(oldRecord.key(), signalBadge));
                LOG.info("Stored profile for " + String.valueOf(aci));
                if (recipientKey != null && (avatarProfilePath = profile.getAvatar()) != null) {
                    LOG.info("AvatarProfilePath = " + avatarProfilePath + ", oldpath = " + oldRecord.profileAvatarUrl());
                    if (avatarProfilePath.equals(oldRecord.profileAvatarUrl())) {
                        LOG.info("Avatar not changed");
                    } else {
                        LOG.info("will CHANGE AVATAR");
                        try {
                            this.wave.storeAvatar(avatarProfilePath, new ProfileKey(profileKeyBytes), recipientKey);
                        }
                        catch (IOException | InvalidInputException ex) {
                            LOG.log(Level.SEVERE, null, ex);
                            ex.printStackTrace();
                        }
                    }
                }
                return profile;
            })).exceptionally(ex -> {
                LOG.severe("Got exception " + String.valueOf(ex));
                throw new RuntimeException((Throwable)ex);
            });
            LOG.info("Started retrieving profile, return completablefuture now");
            return answer;
        }
        catch (Exception ex2) {
            return CompletableFuture.failedFuture(ex2);
        }
    }

    public boolean storeIdentityKeyIfDifferent(String user, byte[] key) {
        LOG.info("Compare and maybe store IdentityKey for " + user);
        SignalProtocolAddress address = new SignalProtocolAddress(user, 1);
        if (this.store.containsSession(address)) {
            LOG.info("We have a session for " + user);
            SessionRecord sessionRecord = this.store.loadSession(address);
            IdentityKey remoteKey = sessionRecord.getRemoteIdentityKey();
            IdentityKey localKey = sessionRecord.getLocalIdentityKey();
            if (remoteKey != null && Arrays.equals(remoteKey.serialize(), key)) {
                LOG.info("keys are equal, don't store for " + user);
                return false;
            }
            LOG.info("Profile for " + user + " has a new identitykey!");
        } else {
            LOG.info("We don't have a session for .1 device of " + user);
        }
        this.storeIdentityKey(user, key);
        return true;
    }

    public void storeIdentityKey(String user, byte[] key) {
        LOG.info("Do store new identityKey for " + user);
        try {
            SignalProtocolAddress address = new SignalProtocolAddress(user, 1);
            IdentityKey identityKey = new IdentityKey(key);
            this.store.saveIdentity(address, identityKey);
            LOG.info("Saved new key");
            if (this.store.containsSession(address)) {
                SessionRecord sessionRecord = this.store.loadSession(address);
                sessionRecord.archiveCurrentState();
                this.store.storeSession(address, sessionRecord);
            }
        }
        catch (InvalidKeyException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException("Can't store an illegal key! ", ex);
        }
    }
}

