/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation;

import io.privacyresearch.clientdata.EntityKey;
import io.privacyresearch.clientdata.SqliteStorageBean;
import io.privacyresearch.clientdata.canvas.CanvasDbRecord;
import io.privacyresearch.clientdata.canvas.CreateCanvasRequest;
import io.privacyresearch.clientdata.canvas.UpdateCanvasRequest;
import io.privacyresearch.clientdata.channel.ChannelKey;
import io.privacyresearch.equation.EquationManager;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

public class CanvasService {
    private static final Logger LOG = Logger.getLogger(CanvasService.class.getName());
    private final SqliteStorageBean sqliteStorageBean;
    private final EquationManager equation;

    public CanvasService(EquationManager equation, SqliteStorageBean sqliteStorageBean) {
        this.sqliteStorageBean = sqliteStorageBean;
        this.equation = equation;
    }

    public List<CanvasDbRecord> getCanvasListByChannel(ChannelKey channelKey) {
        List list = this.sqliteStorageBean.getCanvasData().getByChannel(channelKey);
        HashMap map = new HashMap();
        for (CanvasDbRecord record : list) {
            String identifier = record.identifier();
            if (!map.containsKey(identifier)) {
                map.put(identifier, new LinkedList());
            }
            ((List)map.get(identifier)).add(record);
        }
        LinkedList<CanvasDbRecord> answer = new LinkedList<CanvasDbRecord>();
        for (String identifier : map.keySet()) {
            CanvasDbRecord one = (CanvasDbRecord)((List)map.get(identifier)).stream().sorted((a, b) -> a.version() > b.version() ? -1 : 1).findFirst().orElseThrow();
            answer.add(one);
        }
        return answer;
    }

    CanvasDbRecord storeRecord(CanvasDbRecord record) {
        CanvasDbRecord exists = (CanvasDbRecord)this.sqliteStorageBean.getCanvasData().findByKey((EntityKey)record.key());
        ChannelKey channelKey = record.channelKey();
        String id = record.identifier();
        LOG.info("exists = " + String.valueOf(exists) + " and key = " + String.valueOf(record.key()) + " and channelkey = " + String.valueOf(record.channelKey()));
        if (exists == null) {
            CreateCanvasRequest request = new CreateCanvasRequest(record.channelKey(), id, this.equation.getAccount().getUser().recipient().key(), record.body(), record.bodyRanges(), (int)record.version());
            this.sqliteStorageBean.getCanvasData().createCanvas(request);
        } else {
            UpdateCanvasRequest request = new UpdateCanvasRequest(record.key(), this.equation.getAccount().getUser().recipient().key(), record.body(), record.bodyRanges(), (int)record.version());
            this.sqliteStorageBean.getCanvasData().updateCanvas(request);
        }
        return this.sqliteStorageBean.getCanvasData().getByChannel(channelKey).stream().filter(candidate -> candidate.identifier().equals(id)).findFirst().orElseThrow();
    }
}

