/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation;

import io.privacyresearch.clientdata.EntityKey;
import io.privacyresearch.clientdata.SqliteStorageBean;
import io.privacyresearch.clientdata.channel.ChannelRecord;
import io.privacyresearch.clientdata.group.GroupKey;
import io.privacyresearch.clientdata.group.GroupRecord;
import io.privacyresearch.clientdata.keyvalue.PreferenceStorage;
import io.privacyresearch.clientdata.message.BodyRange;
import io.privacyresearch.clientdata.message.InsertInternalMessageRequest;
import io.privacyresearch.clientdata.message.InternalMessageKey;
import io.privacyresearch.clientdata.message.ReceiptType;
import io.privacyresearch.clientdata.quote.InsertInternalQuoteRequest;
import io.privacyresearch.clientdata.quote.QuoteRecord;
import io.privacyresearch.clientdata.reaction.CreateInternalReactionRequest;
import io.privacyresearch.clientdata.recipient.RecipientKey;
import io.privacyresearch.clientdata.user.UserDbRecord;
import io.privacyresearch.clientdata.user.UserKey;
import io.privacyresearch.equation.EquationManager;
import io.privacyresearch.equation.message.MessagingClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.signal.libsignal.messagebackup.BackupKey;
import org.signal.libsignal.messagebackup.MessageBackupKey;
import org.signal.libsignal.protocol.ServiceId;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.groups.GroupMasterKey;
import org.signal.storageservice.protos.groups.local.DecryptedGroup;
import org.signal.storageservice.protos.groups.local.DecryptedMember;
import org.thoughtcrime.securesms.backup.v2.proto.Backup;
import org.whispersystems.signalservice.internal.storage.GroupV2Record;

public class BackupImporter {
    private static final Logger LOG = Logger.getLogger(BackupImporter.class.getName());
    private final SqliteStorageBean bean;
    private final Map<Long, RecipientKey> idRecipientMap = new HashMap<Long, RecipientKey>();
    private final Map<Long, Integer> idRecipientIdMap = new HashMap<Long, Integer>();
    private final Map<String, Integer> authorIdAndTimestampToMessageId = new HashMap<String, Integer>();
    private final Map<Long, RecipientKey> chatIdRecipientKeyMap = new HashMap<Long, RecipientKey>();
    private final Map<Long, Integer> chatIdRecipientIdMap = new HashMap<Long, Integer>();
    private MessageBackupKey mbk;
    private MessagingClient client;
    private EquationManager equation;
    private Consumer<String> updates;
    private long nMessageFrames = 0L;
    boolean firstChat = true;

    public BackupImporter(SqliteStorageBean bean, byte[] ephemeral, ServiceId.Aci aci) {
        this.bean = bean;
        try {
            BackupKey backupKey = new BackupKey(ephemeral);
            this.mbk = new MessageBackupKey(backupKey, backupKey.deriveBackupId(aci));
        }
        catch (InvalidInputException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException("Invalid input in ephemeral", ex);
        }
    }

    public BackupImporter(SqliteStorageBean bean) {
        this.bean = bean;
    }

    public void setMessageClient(MessagingClient client) {
        this.client = client;
    }

    public void setEquation(EquationManager wave) {
        this.equation = wave;
    }

    public void setUpdates(Consumer<String> updates) {
        this.updates = updates;
    }

    public void importBackup(Path backupPath) throws IOException {
        File backupFile = backupPath.toFile();
        long length = backupFile.length();
        LOG.info("BackupLength = " + length);
        try (RandomAccessFile raf = new RandomAccessFile(backupFile, "r");){
            raf.seek(backupFile.length() - 32L);
            byte[] mac = new byte[32];
            raf.read(mac);
            File dataFile = BackupImporter.copyFileWithoutMac(backupFile);
            try {
                byte[] calcmac = BackupImporter.getMacFromFile(dataFile, this.mbk.getHmacKey());
                if (!Arrays.equals(mac, calcmac)) {
                    LOG.severe("Wrong mac for backupfile");
                    throw new IllegalArgumentException("Cannot process this backupfile at " + String.valueOf(backupPath));
                }
                LOG.info("Backup file has expected MAC");
            }
            catch (InvalidKeyException | NoSuchAlgorithmException ex) {
                LOG.log(Level.SEVERE, null, ex);
                throw new IllegalArgumentException("Wrong datafile or keys", ex);
            }
            try {
                InputStream cis = BackupImporter.getCipherInputStream(dataFile, this.mbk.getAesKey());
                GZIPInputStream gis = new GZIPInputStream(cis);
                this.importBackup(gis, 2L * length);
            }
            catch (InvalidAlgorithmParameterException | NoSuchPaddingException ex) {
                LOG.log(Level.SEVERE, null, ex);
                throw new IOException("Error creating cipherInputStream", ex);
            }
        }
    }

    public void importBackup(InputStream is) throws IOException {
        this.importBackup(is, -1L);
    }

    public void importBackup(InputStream is, long origSize) throws IOException {
        long startMillis = System.currentTimeMillis();
        int size = BackupImporter.readVarInt32(is);
        byte[] infoBlock = this.readChunk(is, size);
        long totalRead = 4 + size;
        double coveredTreshold = 0.1;
        Backup.BackupInfo backupInfo = Backup.BackupInfo.parseFrom((byte[])infoBlock);
        LOG.info("BackupInfo: " + String.valueOf(backupInfo) + " with version = " + backupInfo.getVersion() + " and backuptime = " + backupInfo.getBackupTimeMs());
        boolean go = true;
        int framesProcessedInTransaction = 0;
        int framesPerTransaction = 1000;
        if (this.updates != null) {
            this.updates.accept("Received backupfile, start parsing now");
        }
        try {
            this.bean.getConnection().setAutoCommit(false);
            while (go) {
                size = BackupImporter.readVarInt32(is);
                if (size < 0) {
                    go = false;
                    break;
                }
                Backup.Frame frame = Backup.Frame.parseFrom((byte[])this.readChunk(is, size));
                this.parseFrame(frame);
                totalRead = totalRead + 4L + (long)size;
                LOG.info("Process frame with size = " + size + ", available = " + is.available() + " totalRead = " + totalRead);
                double covered = (double)totalRead / (double)origSize;
                if (covered > coveredTreshold) {
                    if (this.updates != null) {
                        this.updates.accept("Done ca " + (int)(covered * 100.0) + "% (" + this.nMessageFrames + " message frames)");
                    }
                    coveredTreshold += 0.1;
                }
                if (++framesProcessedInTransaction < framesPerTransaction) continue;
                framesProcessedInTransaction = 0;
                try {
                    this.bean.getConnection().commit();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            LOG.info("Got exception: " + String.valueOf(e));
            e.printStackTrace();
        }
        try {
            LOG.info("Update last-read time for all channels");
            this.updateChannelsLastRead(System.currentTimeMillis());
            LOG.info("Commit transaction");
            this.bean.getConnection().commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        try {
            this.bean.getConnection().setAutoCommit(true);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        LOG.info("Backup imported.");
    }

    public boolean importPlainDataBackup(Path path) {
        LOG.info("START IMPORT from " + String.valueOf(path));
        try {
            List allChannels = this.bean.getChannelData().findAll();
            LOG.info("all channels = " + String.valueOf(allChannels));
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        File file = path.toFile();
        try {
            FileInputStream fis = new FileInputStream(file);
            LOG.info("Created fis to " + String.valueOf(file) + ", and available = " + fis.available());
            while (fis.available() > 0) {
                Backup.Frame frame = Backup.Frame.parseDelimitedFrom((InputStream)fis);
                LOG.finest("Got frame: " + String.valueOf(frame));
                this.parseFrame(frame);
            }
            this.updateChannelsLastRead(System.currentTimeMillis());
        }
        catch (Throwable ex) {
            LOG.log(Level.SEVERE, null, ex);
            ex.printStackTrace();
        }
        return true;
    }

    public void parseFrame(Backup.Frame frame) {
        if (frame.hasAccount()) {
            this.parseAccount(frame.getAccount());
        }
        if (frame.hasRecipient()) {
            this.parseRecipient(frame.getRecipient());
        }
        if (frame.hasChat()) {
            this.parseChat(frame.getChat());
        }
        if (frame.hasChatItem()) {
            this.parseChatItem(frame.getChatItem());
        }
    }

    private void parseAccount(Backup.AccountData backup) {
        Backup.AccountData.AccountSettings backupSettings = backup.getAccountSettings();
        PreferenceStorage preference = this.bean.preference();
        preference.putBoolean("preference.read_receipts", backupSettings.getReadReceipts());
        preference.putBoolean("preference.stories_enabled", !backupSettings.getStoriesDisabled());
        preference.putBoolean("preference.typing_indicators", backupSettings.getTypingIndicators());
    }

    private void parseRecipient(Backup.Recipient recipient) {
        if (recipient.hasContact()) {
            this.parseContact(recipient);
        }
        if (recipient.hasSelf()) {
            this.parseSelf(recipient);
        }
        if (recipient.hasGroup()) {
            this.parseGroup(recipient);
        }
        if (recipient.hasReleaseNotes()) {
            this.parseReleaseNotes(recipient);
        }
    }

    public void parseContact(Backup.Recipient recipient) {
        long id = recipient.getId();
        LOG.info("Parse contact for recipient " + String.valueOf(recipient));
        Backup.Contact contact = recipient.getContact();
        LOG.finest("Parsed contact " + String.valueOf(contact));
        UserKey stored = this.bean.getUserData().storeContactFromBackup(contact);
        UserDbRecord user = (UserDbRecord)this.bean.getUserData().findByKey((EntityKey)stored);
        this.idRecipientMap.put(id, user.recipientKey());
        try {
            int recipientId = (Integer)this.bean.getRecipientData().getIdByKey((EntityKey)user.recipientKey());
            this.idRecipientIdMap.put(id, recipientId);
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        if (this.equation != null && user.aci() != null) {
            this.equation.retrieveAndStoreProfile(user.aci(), user.profileKey());
        }
    }

    private void parseSelf(Backup.Recipient recipient) {
        UserDbRecord self;
        ServiceId.Aci me = this.bean.account().getAci();
        if (me == null) {
            LOG.warning("We don't have an own ACI yet. Creating one.");
            UUID uuid = UUID.randomUUID();
            ServiceId.Aci aci = new ServiceId.Aci(uuid);
            this.bean.account().setAci(aci);
        }
        if ((self = this.bean.getUserCache().getSelf()) == null) {
            LOG.warning("We don't have an own user yet. Creating one.");
            UUID uuid = UUID.randomUUID();
            ServiceId.Aci aci = new ServiceId.Aci(uuid);
            UserKey store = this.bean.getUserData().store((ServiceId)aci, null);
            self = (UserDbRecord)this.bean.getUserData().findByKey((EntityKey)store);
        }
        this.idRecipientMap.put(recipient.getId(), self.recipientKey());
        try {
            int recipientId = (Integer)this.bean.getRecipientData().getIdByKey((EntityKey)self.recipientKey());
            this.idRecipientIdMap.put(recipient.getId(), recipientId);
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        if (this.equation != null && self.aci() != null) {
            this.equation.retrieveAndStoreProfile(self.aci(), self.profileKey());
        }
    }

    private void parseGroup(Backup.Recipient recipient) {
        long id = recipient.getId();
        Backup.Group bGroup = recipient.getGroup();
        GroupV2Record.Builder builder = GroupV2Record.newBuilder().setMasterKey(bGroup.getMasterKey()).setWhitelisted(bGroup.getWhitelisted()).setArchived(false).setHideStory(bGroup.getHideStory()).setStorySendModeValue(bGroup.getStorySendModeValue());
        Backup.Group.GroupSnapshot snapshot = bGroup.getSnapshot();
        DecryptedGroup.Builder dBuilder = DecryptedGroup.newBuilder();
        if (snapshot.hasTitle()) {
            dBuilder.setTitle(snapshot.getTitle().getTitle());
        }
        if (snapshot.hasDescription()) {
            dBuilder.setDescription(snapshot.getDescription().getDescriptionText());
        }
        List membersList = snapshot.getMembersList();
        ArrayList<DecryptedMember> dMembersList = new ArrayList<DecryptedMember>();
        for (Backup.Group.Member member : membersList) {
            DecryptedMember dMember = DecryptedMember.newBuilder().setAciBytes(member.getUserId()).setRoleValue(member.getRoleValue()).setJoinedAtRevision(member.getJoinedAtVersion()).build();
            dMembersList.add(dMember);
        }
        LOG.info("Imported members = " + String.valueOf(dMembersList));
        dBuilder.addAllMembers(dMembersList);
        GroupMasterKey masterKey = null;
        try {
            masterKey = new GroupMasterKey(bGroup.getMasterKey().toByteArray());
        }
        catch (InvalidInputException ex) {
            LOG.log(Level.SEVERE, "Can't create a valid masterkey, ignore this group", ex);
            Thread.dumpStack();
            return;
        }
        Optional group = this.bean.getGroupData().getGroupByMasterKeyBytes(bGroup.getMasterKey().toByteArray());
        if (group.isEmpty()) {
            LOG.info("No group found for masterkey in recipient with id " + id);
            GroupKey groupKey = this.bean.getGroupData().create(bGroup);
            this.bean.getGroupData().update(masterKey, dBuilder.build());
            GroupRecord groupRecord = (GroupRecord)this.bean.getGroupData().findByKey((EntityKey)groupKey);
            this.idRecipientMap.put(id, groupRecord.recipient().key());
            try {
                int recipientId = (Integer)this.bean.getRecipientData().getIdByKey((EntityKey)groupRecord.recipient().key());
                this.idRecipientIdMap.put(id, recipientId);
            }
            catch (SQLException ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
        } else {
            LOG.warning("We already have a group with this masterkey!");
        }
    }

    private void parseReleaseNotes(Backup.Recipient recipient) {
        LOG.info("Recipient with id " + recipient.getId() + " is releasenotes");
    }

    private void parseChat(Backup.Chat chat) {
        long id;
        RecipientKey recipientKey;
        if (this.firstChat && this.updates != null) {
            this.updates.accept("Done parsing " + this.idRecipientMap.size() + " recipients");
            this.firstChat = false;
        }
        if ((recipientKey = this.idRecipientMap.get(id = chat.getRecipientId())) == null) {
            LOG.warning("Can't find recipient for chat " + String.valueOf(chat));
            return;
        }
        this.chatIdRecipientKeyMap.put(chat.getId(), recipientKey);
        this.chatIdRecipientIdMap.put(chat.getId(), this.idRecipientIdMap.get(id));
    }

    private void parseChatItem(Backup.ChatItem chatItem) {
        long chatId = chatItem.getChatId();
        RecipientKey channelRecipientKey = this.chatIdRecipientKeyMap.get(chatId);
        if (channelRecipientKey == null) {
            LOG.warning("Can't find a channel for chatitem");
            return;
        }
        long authorId = chatItem.getAuthorId();
        RecipientKey authorRecipientKey = this.idRecipientMap.get(authorId);
        if (authorRecipientKey == null) {
            LOG.warning("Can't find author recipient for chatitem");
            return;
        }
        UserDbRecord author = this.bean.getUserData().findByRecipientKey(authorRecipientKey);
        if (author == null) {
            LOG.warning("Can't find author user for chatitem");
            return;
        }
        int authorRecipientId = this.idRecipientIdMap.get(authorId);
        int channelRecipientId = this.chatIdRecipientIdMap.get(chatId);
        if (chatItem.hasStandardMessage()) {
            Backup.StandardMessage standardMessage = chatItem.getStandardMessage();
            InsertInternalMessageRequest messageRequest = new InsertInternalMessageRequest();
            messageRequest.setContent(standardMessage.getText().getBody());
            messageRequest.setBodyRanges(this.createBodyRanges(standardMessage.getText().getBodyRangesList()));
            messageRequest.setSenderRecipientId(authorRecipientId);
            messageRequest.setReceiverRecipientId(channelRecipientId);
            messageRequest.setTimestamp(chatItem.getDateSent());
            InternalMessageKey messageKey = this.bean.getMessageData().insertMessageInternal(messageRequest);
            this.authorIdAndTimestampToMessageId.put(authorId + "_" + chatItem.getDateSent(), messageKey.messageId());
            for (Backup.Reaction reaction : standardMessage.getReactionsList()) {
                long reactionAuthorId = reaction.getAuthorId();
                int reactionAuthorRecipientId = this.idRecipientIdMap.get(reactionAuthorId);
                this.bean.getReactionData().addReactionInternal(CreateInternalReactionRequest.newBuilder().messageId(messageKey.messageId()).authorRecipientId(reactionAuthorRecipientId).dateSent(reaction.getSentTimestamp()).emoji(reaction.getEmoji()).build());
            }
            if (standardMessage.hasQuote()) {
                Object originalMessageId = null;
                Backup.Quote quote = standardMessage.getQuote();
                if (quote.hasTargetSentTimestamp()) {
                    long origTimestamp;
                    long origAuthorId = quote.getAuthorId();
                    originalMessageId = this.authorIdAndTimestampToMessageId.get(origAuthorId + "_" + (origTimestamp = quote.getTargetSentTimestamp()));
                    if (originalMessageId != null) {
                        LOG.info("Got original message: " + (Integer)originalMessageId);
                    } else {
                        LOG.info("quote has a reference to message but that doesn't exist (anymore)");
                    }
                } else {
                    LOG.info("quote has no reference to message");
                }
                InsertInternalQuoteRequest request = new InsertInternalQuoteRequest();
                request.setMessageId(messageKey.messageId());
                request.setQuotedMessageId(originalMessageId);
                request.setBody(quote.getText().getBody());
                request.setMentions(null);
                request.setType(QuoteRecord.Type.NORMAL);
                this.bean.getQuoteData().addQuoteInternal(request);
            }
            if (standardMessage.getAttachmentsCount() > 0) {
                for (Backup.MessageAttachment att : standardMessage.getAttachmentsList()) {
                    LOG.info("HAS ATTACHMENT: " + String.valueOf(att));
                }
            }
            if (chatItem.hasOutgoing()) {
                Backup.ChatItem.OutgoingMessageDetails outgoingDetails = chatItem.getOutgoing();
                outgoingDetails.getSendStatusList().stream().findAny().ifPresent(sendStatus -> {
                    ReceiptType ourStatus = ReceiptType.UNKNOWN;
                    if (sendStatus.hasDelivered()) {
                        ourStatus = ReceiptType.DELIVERY;
                    }
                    if (sendStatus.hasRead()) {
                        ourStatus = ReceiptType.READ;
                    }
                    if (sendStatus.hasViewed()) {
                        ourStatus = ReceiptType.VIEWED;
                    }
                    this.bean.getMessageData().updateReceiptStatusInternal(messageKey.messageId(), ourStatus, sendStatus.getTimestamp());
                });
            }
            ++this.nMessageFrames;
        }
    }

    public void updateChannelsLastRead(long time) {
        try {
            List channels = this.bean.getChannelData().findAll();
            for (ChannelRecord channel : channels) {
                this.bean.getChannelData().updateLastRead(channel.key(), time);
            }
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    private List<BodyRange> createBodyRanges(List<Backup.BodyRange> ranges) {
        return ranges.stream().map(this::createBodyRange).toList();
    }

    private BodyRange createBodyRange(Backup.BodyRange range) {
        if (range.hasStyle()) {
            return BodyRange.fromStyleId((int)range.getStyleValue(), (int)range.getStart(), (int)range.getLength());
        }
        Object sid = null;
        ServiceId.Aci aci = null;
        byte[] aciBytes = range.getMentionAci().toByteArray();
        try {
            if (aciBytes != null && aciBytes.length == 16) {
                aci = ServiceId.Aci.parseFromBinary((byte[])aciBytes);
            }
        }
        catch (ServiceId.InvalidServiceIdException ex) {
            LOG.info("Could nto parse aci, bytes = " + Arrays.toString(aciBytes));
            LOG.log(Level.SEVERE, null, ex);
        }
        return BodyRange.fromMentionAci((String)(aci == null ? "" : aci.toServiceIdString()), (int)range.getStart(), (int)range.getLength());
    }

    private byte[] readChunk(InputStream is, int size) throws IOException {
        if (size < 1) {
            throw new IllegalArgumentException("No point in reading 0 bytes");
        }
        byte[] block = new byte[size];
        int offset = 0;
        int len = size;
        int read = is.read(block, offset, len);
        offset += read;
        while (read != -1 && offset < size) {
            read = is.read(block, offset, len -= read);
            offset += read;
        }
        if (offset < size) {
            LOG.info("Not enough bytes on is. Needed " + size + " but got " + offset);
            return new byte[0];
        }
        return block;
    }

    private static int readVarInt32(InputStream stream) throws IOException {
        int result = 0;
        int shift = 0;
        do {
            int b;
            if ((b = stream.read()) == -1) {
                return -1;
            }
            result |= (b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        } while ((shift += 7) < 32);
        throw new IllegalArgumentException("VarInt32 is too long");
    }

    static File copyFileWithoutMac(File orig) throws IOException {
        Path targetPath = Files.createTempFile("backup", ".nomac", new FileAttribute[0]);
        File answer = targetPath.toFile();
        try (RandomAccessFile macFile = new RandomAccessFile(orig, "r");
             FileOutputStream newFile = new FileOutputStream(answer);){
            int read;
            long origSize = macFile.length();
            long targetSize = origSize - 32L;
            macFile.seek(0L);
            byte[] buffer = new byte[4096];
            for (long left = targetSize; left > 0L && (read = macFile.read(buffer, 0, (int)Math.min((long)buffer.length, left))) != -1; left -= (long)read) {
                newFile.write(buffer, 0, read);
            }
        }
        return answer;
    }

    static byte[] getMacFromFile(File f, byte[] mackey) throws NoSuchAlgorithmException, IOException, InvalidKeyException {
        try (FileInputStream fis = new FileInputStream(f);){
            int read;
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(mackey, "HmacSHA256"));
            byte[] buff = new byte[4096];
            while ((read = fis.read(buff)) != -1) {
                mac.update(buff, 0, read);
            }
            byte[] byArray = mac.doFinal();
            return byArray;
        }
    }

    public static InputStream getCipherInputStream(File encfile, byte[] aes) throws IOException, NoSuchPaddingException, InvalidAlgorithmParameterException {
        FileInputStream is = new FileInputStream(encfile);
        byte[] iv = new byte[16];
        int read = is.read(iv);
        if (read < 16) {
            System.err.println("NOT ENOUGH IV");
        }
        LOG.info("IV = " + Arrays.toString(iv));
        Cipher cipher = BackupImporter.createCipherFromKeyMaterial(aes, iv, true);
        return new CipherInputStream(is, cipher);
    }

    static Cipher createCipherFromKeyMaterial(byte[] aes, byte[] iv, boolean decrypt) throws NoSuchPaddingException, InvalidAlgorithmParameterException {
        try {
            SecretKeySpec spec = new SecretKeySpec(aes, "AES");
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            int mode = decrypt ? 2 : 1;
            cipher.init(mode, (Key)spec, ivSpec);
            return cipher;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException("Wrong key material, couldn't create cipher", ex);
        }
    }
}

