/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.snl;

import com.gluonhq.snl.ConnectivityListener;
import com.gluonhq.snl.LegacyNetworkClient;
import com.gluonhq.snl.NetworkClient;
import com.gluonhq.snl.QuicSignalLayer;
import com.gluonhq.snl.Response;
import com.google.protobuf.ByteString;
import io.privacyresearch.equation.NetworkMonitor;
import io.privacyresearch.equation.net.SignalUrl;
import io.privacyresearch.equation.proxystub.SignalRpcMessage;
import io.privacyresearch.equation.proxystub.SignalRpcReply;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpRequest;
import java.net.http.WebSocket;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.whispersystems.signalservice.api.push.OutgoingPushMessageList;
import org.whispersystems.signalservice.api.util.CredentialsProvider;
import org.whispersystems.signalservice.internal.websocket.WebSocketProtos;

public class QuicNetworkClient
extends NetworkClient {
    private static final Logger LOG = Logger.getLogger(QuicNetworkClient.class.getName());
    private final QuicSignalLayer quicSignalLayer;
    final String kwikAddress;
    LegacyNetworkClient fallback;

    public QuicNetworkClient(NetworkMonitor monitor, SignalUrl url, String agent, boolean allowStories, String proxy) {
        this(monitor, url, Optional.empty(), agent, Optional.empty(), allowStories, proxy);
    }

    public QuicNetworkClient(NetworkMonitor monitor, SignalUrl url, Optional<CredentialsProvider> cp, String signalAgent, Optional<ConnectivityListener> connectivityListener, boolean allowStories, String proxy) {
        super(monitor, url, cp, signalAgent, connectivityListener, allowStories);
        this.fallback = new LegacyNetworkClient(monitor, url, cp, signalAgent, connectivityListener, allowStories);
        URI uri = null;
        this.kwikAddress = proxy;
        LOG.info("Created quicnetworkclient with address " + this.kwikAddress);
        try {
            uri = new URI(this.kwikAddress);
        }
        catch (URISyntaxException ex) {
            LOG.log(Level.SEVERE, "wrong format for quic address", ex);
            LOG.warning("Fallback to non-quic transport");
        }
        this.quicSignalLayer = uri == null ? null : new QuicSignalLayer(uri);
    }

    @Override
    protected CompletableFuture<Response> implAsyncSendRequest(URI uri, String method, byte[] body, Map<String, List<String>> headers) throws IOException {
        if (uri.getHost().contains("cdn3")) {
            LOG.info("FALLBACK to non-quic until we support response headers");
            return this.fallback.implAsyncSendRequest(uri, method, body, headers);
        }
        SignalRpcMessage.Builder requestBuilder = SignalRpcMessage.newBuilder();
        requestBuilder.setUrlfragment(uri.toString());
        requestBuilder.setBody(body == null ? ByteString.EMPTY : ByteString.copyFrom((byte[])body));
        headers.entrySet().forEach(header -> ((List)header.getValue()).forEach(hdr -> requestBuilder.addHeader((String)header.getKey() + "=" + hdr)));
        requestBuilder.setMethod(method);
        int bodyLength = body == null ? -1 : body.length;
        LOG.info("Getting ready to send DM to kwikproxy with uri = " + String.valueOf(uri) + ", method = " + method + ", body length = " + bodyLength + " and hl = " + headers.size());
        CompletableFuture<SignalRpcReply> sReplyFuture = this.sendSignalMessage(requestBuilder.build());
        CompletionStage answer = sReplyFuture.thenApply(reply -> new Response(reply.getMessage().toByteArray(), reply.getStatuscode()));
        return answer;
    }

    private CompletableFuture<SignalRpcReply> sendSignalMessage(SignalRpcMessage msg) {
        return this.quicSignalLayer.sendSignalMessage(msg);
    }

    @Override
    protected CompletableFuture<Response> implAsyncSendRequest(HttpRequest request, byte[] raw) throws IOException {
        LOG.info("Send request, using Kwik");
        URI uri = request.uri();
        String method = request.method();
        Map<String, List<String>> headers = request.headers().map();
        CompletableFuture<Response> response = this.implAsyncSendRequest(uri, method, raw, headers);
        LOG.info("Got request, using kwik");
        return response;
    }

    @Override
    CompletableFuture<WebSocket> implSendToStream(WebSocketProtos.WebSocketMessage msg, OutgoingPushMessageList list) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

