/*
 * Decompiled with CFR 0.152.
 */
package org.thoughtcrime.securesms.groups.v2.processing;

import java.util.Collection;
import java.util.List;
import org.signal.storageservice.protos.groups.local.DecryptedGroup;
import org.thoughtcrime.securesms.groups.v2.processing.ServerGroupLogEntry;

final class GlobalGroupState {
    private final DecryptedGroup localState;
    private final List<ServerGroupLogEntry> serverHistory;

    GlobalGroupState(DecryptedGroup localState, List<ServerGroupLogEntry> serverHistory) {
        this.localState = localState;
        this.serverHistory = serverHistory;
    }

    DecryptedGroup getLocalState() {
        return this.localState;
    }

    Collection<ServerGroupLogEntry> getServerHistory() {
        return this.serverHistory;
    }

    int getEarliestRevisionNumber() {
        if (this.localState != null) {
            return this.localState.getRevision();
        }
        if (this.serverHistory.isEmpty()) {
            throw new AssertionError();
        }
        return this.serverHistory.get(0).getRevision();
    }

    int getLatestRevisionNumber() {
        if (this.serverHistory.isEmpty()) {
            if (this.localState == null) {
                throw new AssertionError();
            }
            return this.localState.getRevision();
        }
        return this.serverHistory.get(this.serverHistory.size() - 1).getRevision();
    }
}

