/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.user;

import io.privacyresearch.clientdata.EntityKey;
import io.privacyresearch.clientdata.badge.BadgeData;
import io.privacyresearch.clientdata.badge.BadgeDbRecord;
import io.privacyresearch.clientdata.recipient.RecipientData;
import io.privacyresearch.clientdata.recipient.RecipientKey;
import io.privacyresearch.clientdata.recipient.RecipientRecord;
import io.privacyresearch.clientdata.user.UserData;
import io.privacyresearch.clientdata.user.UserDbRecord;
import io.privacyresearch.clientdata.user.UserKey;
import io.privacyresearch.equation.user.BadgeRecord;
import io.privacyresearch.equation.user.UserRecord;
import io.privacyresearch.equation.util.AvatarHelper;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import org.signal.libsignal.protocol.ServiceId;

public class UserService {
    private static final Logger LOG = Logger.getLogger(UserService.class.getName());
    private final BadgeData badgeData;
    private final RecipientData recipientData;
    private final UserData userData;
    private final AvatarHelper avatarHelper;

    public UserService(BadgeData badgeData, RecipientData recipientData, UserData userData, AvatarHelper avatarHelper) {
        this.badgeData = badgeData;
        this.recipientData = recipientData;
        this.userData = userData;
        this.avatarHelper = avatarHelper;
    }

    public UserDbRecord createUserWithAci(ServiceId.Aci aci) {
        UserKey stored = this.userData.store((ServiceId)aci, null);
        return this.userData.findByAci(aci);
    }

    public String getNameForUser(UserDbRecord db) {
        String name = Objects.toString(db.systemGivenName(), "") + " " + Objects.toString(db.systemFamilyName(), "");
        if (name.trim().isEmpty()) {
            name = Objects.toString(db.profileGivenName(), "") + " " + Objects.toString(db.profileFamilyName(), "");
        }
        return name.trim();
    }

    public Optional<UserDbRecord> getDbUserByAci(ServiceId.Aci aci) {
        if (aci != null) {
            UserKey userKey = this.userData.getByAci(aci);
            LOG.info("UserKey? " + String.valueOf(userKey));
            if (userKey != null) {
                return Optional.of((UserDbRecord)this.userData.findByKey((EntityKey)userKey));
            }
        }
        return Optional.empty();
    }

    public Optional<UserRecord> getUserByAci(ServiceId.Aci aci) {
        return this.getDbUserByAci(aci).map(this::getUserRecordFromDb);
    }

    public UserRecord getUserByRecipientKey(RecipientKey recipientKey) {
        return this.getUserRecordFromDb(this.userData.findByRecipientKey(recipientKey));
    }

    public UserRecord getUserByUserKey(UserKey userKey) {
        return this.getUserRecordFromDb((UserDbRecord)this.userData.findByKey((EntityKey)userKey));
    }

    public UserRecord getUserRecordFromDb(UserDbRecord db) {
        String name = this.getNameForUser(db);
        Optional<String> avatarPath = this.getAvatarPathForUser(db);
        RecipientRecord recipient = (RecipientRecord)this.recipientData.findByKey((EntityKey)db.recipientKey());
        List<BadgeRecord> badges = this.badgeData.getByUserKey(db.key()).stream().map(this::getBadgeRecordFromDb).toList();
        return new UserRecord(db.key(), recipient, db.aci(), db.pni(), db.e164(), db.profileKey(), name, db.profileGivenName(), db.profileFamilyName(), db.username(), db.systemGivenName(), db.systemFamilyName(), avatarPath, db.about(), db.aboutEmoji(), db.nickGivenName(), db.nickFamilyName(), db.nickNote(), db.profileAvatarUrl(), db.sealedSenderMode(), db.phoneNumberSharing(), badges);
    }

    public static boolean isSameUserRecord(UserRecord a, UserRecord b) {
        if (a == b) {
            return true;
        }
        if (a == null && b == null) {
            return true;
        }
        if (a == null != (b == null)) {
            return false;
        }
        if (a.equals(b)) {
            return true;
        }
        if (!UserService.bothNullOrEquals(a.key(), b.key())) {
            return false;
        }
        if (!UserService.bothNullOrEquals(a.recipient(), b.recipient())) {
            return false;
        }
        if (!UserService.bothNullOrEquals(a.aci(), b.aci())) {
            return false;
        }
        if (!UserService.bothNullOrEquals(a.pni(), b.pni())) {
            return false;
        }
        if (!UserService.bothNullOrEquals(a.e164(), b.e164())) {
            return false;
        }
        if (!UserService.bothNullOrEquals(a.profileKey(), b.profileKey())) {
            return false;
        }
        if (!UserService.bothNullOrEquals(a.profileGivenName(), b.profileGivenName())) {
            return false;
        }
        if (!UserService.bothNullOrEquals(a.profileFamilyName(), b.profileFamilyName())) {
            return false;
        }
        if (!UserService.bothNullOrEquals(a.username(), b.username())) {
            return false;
        }
        if (!UserService.bothNullOrEquals(a.systemGivenName(), b.systemGivenName())) {
            return false;
        }
        if (!UserService.bothNullOrEquals(a.systemFamilyName(), b.systemFamilyName())) {
            return false;
        }
        if (!UserService.bothNullOrEquals(a.avatarPath(), b.avatarPath())) {
            return false;
        }
        if (!UserService.bothNullOrEquals(a.about(), b.about())) {
            return false;
        }
        if (!UserService.bothNullOrEquals(a.aboutEmoji(), b.aboutEmoji())) {
            return false;
        }
        if (!UserService.bothNullOrEquals(a.nickGivenName(), b.nickGivenName())) {
            return false;
        }
        if (!UserService.bothNullOrEquals(a.nickFamilyName(), b.nickFamilyName())) {
            return false;
        }
        if (!UserService.bothNullOrEquals(a.nickNote(), b.nickNote())) {
            return false;
        }
        if (!UserService.bothNullOrEquals(a.profileAvatarUrl(), b.profileAvatarUrl())) {
            return false;
        }
        if (!UserService.bothNullOrEquals(a.sealedSenderMode(), b.sealedSenderMode())) {
            return false;
        }
        if (!UserService.bothNullOrEquals(a.phoneNumberSharing(), b.phoneNumberSharing())) {
            return false;
        }
        return UserService.bothNullOrEquals(a.badges(), b.badges());
    }

    private static boolean bothNullOrEquals(Object a, Object b) {
        if (a == null != (b == null)) {
            return false;
        }
        if (a == null && b == null) {
            return true;
        }
        if (a instanceof byte[]) {
            byte[] ba = (byte[])a;
            if (b instanceof byte[]) {
                byte[] bb = (byte[])b;
                return Arrays.equals(ba, bb);
            }
            return false;
        }
        return a.equals(b);
    }

    private Optional<String> getAvatarPathForUser(UserDbRecord user) {
        File avatarFile = this.avatarHelper.getAvatarFile(user.recipientKey());
        if (avatarFile.exists()) {
            return Optional.of(avatarFile.toString());
        }
        return Optional.empty();
    }

    private BadgeRecord getBadgeRecordFromDb(BadgeDbRecord db) {
        return new BadgeRecord(db.badgeId(), db.category(), db.name(), db.description(), db.duration(), db.expiration(), db.visible());
    }
}

