/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.proxy;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.privacyresearch.equation.proxystub.UserRemoteConfigListMessage;
import io.privacyresearch.equation.proxystub.UserRemoteConfigMessage;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.whispersystems.textsecuregcm.entities.DeliveryCertificate;
import org.whispersystems.textsecuregcm.entities.UserRemoteConfigList;

public class ServerConversion {
    static final String CERTIFICATE_DELIVERY = "/v1/certificate/delivery";
    static final String CONFIG = "/v1/config";
    static final String PREKEY_DEVICE_PATH = "/v2/keys";
    static final String WHO_AM_I = "/v1/accounts/whoami";
    static final String GROUPSV2_CREDENTIAL = "/v1/certificate/auth/group";
    private static final Logger LOG = Logger.getLogger(ServerConversion.class.getName());

    static byte[] process(String path, byte[] raw) {
        if (CERTIFICATE_DELIVERY.equals(path)) {
            return ServerConversion.processCertificateDelivery(raw);
        }
        if (CONFIG.equals(path)) {
            return ServerConversion.processConfig(raw);
        }
        LOG.warning("IGNORE PROCESSING FOR NOW, path = " + path);
        return raw;
    }

    static byte[] processCertificateDelivery(byte[] raw) {
        LOG.info("X-process certificateDelivery");
        ObjectMapper objectMapper = new ObjectMapper();
        String responseText = new String(raw);
        try {
            DeliveryCertificate dc = (DeliveryCertificate)objectMapper.readValue(responseText, DeliveryCertificate.class);
            return dc.getCertificate();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, null, ex);
            ex.printStackTrace();
            return null;
        }
    }

    static byte[] processConfig(byte[] raw) {
        LOG.info("X-process config");
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        String responseText = new String(raw);
        try {
            UserRemoteConfigList urcl = (UserRemoteConfigList)objectMapper.readValue(responseText, UserRemoteConfigList.class);
            UserRemoteConfigListMessage.Builder builder = UserRemoteConfigListMessage.newBuilder();
            builder.setServerEpoch(urcl.getServerEpochTime().getEpochSecond());
            urcl.getConfig().forEach(urc -> {
                UserRemoteConfigMessage.Builder mb = UserRemoteConfigMessage.newBuilder();
                String val = urc.getValue();
                mb.setName(urc.getName()).setEnabled(urc.isEnabled());
                if (val != null) {
                    mb.setValue(val);
                }
                builder.addUserRemoteConfig(mb);
            });
            byte[] answer = builder.build().toByteArray();
            return answer;
        }
        catch (Exception e) {
            e.printStackTrace();
            return raw;
        }
    }
}

