/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.provision;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.gluonhq.snl.NetworkClient;
import com.gluonhq.snl.Response;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import io.privacyresearch.clientdata.SqliteStorageBean;
import io.privacyresearch.equation.EquationManager;
import io.privacyresearch.equation.WaveStore;
import io.privacyresearch.equation.internal.KeyUtil;
import io.privacyresearch.equation.internal.TrustStoreImpl;
import io.privacyresearch.equation.model.Account;
import io.privacyresearch.equation.model.json.KyberPreKeyEntity;
import io.privacyresearch.equation.model.json.SignedPreKeyEntity;
import io.privacyresearch.equation.net.NetworkAPI;
import io.privacyresearch.equation.net.NetworkConfiguration;
import io.privacyresearch.equation.provision.DeviceNameCipher;
import io.privacyresearch.equation.provision.ProvisioningCipher;
import io.privacyresearch.equation.provision.ProvisioningClient;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpRequest;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.signal.libsignal.protocol.IdentityKeyPair;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.protocol.ServiceId;
import org.signal.libsignal.protocol.ecc.Curve;
import org.signal.libsignal.protocol.ecc.ECPrivateKey;
import org.signal.libsignal.protocol.state.KyberPreKeyRecord;
import org.signal.libsignal.protocol.state.SignedPreKeyRecord;
import org.whispersystems.signalservice.api.kbs.MasterKey;
import org.whispersystems.signalservice.api.messages.SignalServiceEnvelope;
import org.whispersystems.signalservice.api.storage.StorageKey;
import org.whispersystems.signalservice.internal.ProvisioningProtos;
import org.whispersystems.signalservice.internal.websocket.WebSocketProtos;

public class ProvisioningManager {
    private final ProvisioningClient provisioningClient;
    private final EquationManager waveManager;
    private final SqliteStorageBean sqliteStorageBean;
    private final TrustStoreImpl trustStore;
    private final ProvisioningCipher provisioningCipher;
    private final NetworkConfiguration networkConfiguration;
    private static final String SIGNAL_USER_AGENT = "Signal-Desktop/6.46.0 Linux";
    private static String destination = "wss://chat.signal.org";
    private static String host = "https://chat.signal.org";
    private NetworkClient provisioningWebSocket;
    private boolean listen;
    private ProvisioningProtos.ProvisionMessage pm;
    private String number;
    private int deviceId;
    private static final Logger LOG = Logger.getLogger(ProvisioningManager.class.getName());
    private boolean localMode;
    private final NetworkAPI networkAPI;
    private final boolean useQuic;

    public ProvisioningManager(EquationManager wave, SqliteStorageBean sqliteStorageBean, ProvisioningClient client, NetworkAPI networkAPI) {
        this.provisioningClient = client;
        this.waveManager = wave;
        this.sqliteStorageBean = sqliteStorageBean;
        this.networkAPI = networkAPI;
        this.trustStore = new TrustStoreImpl();
        this.provisioningCipher = new ProvisioningCipher(this.waveManager);
        this.processConfiguration(wave.getConfiguration());
        LOG.info("EquationConfig = " + String.valueOf(wave.getConfiguration()));
        this.networkConfiguration = wave.getSignalBridge().getNetworkConfiguration();
        this.useQuic = this.networkConfiguration.isUseQuic();
    }

    public void start() {
        this.provisioningWebSocket = NetworkClient.createNetworkClient(this.waveManager.getNetworkMonitor(), this.networkConfiguration, NetworkConfiguration.Purpose.PROVISIONING, Optional.empty());
        this.listen = true;
        try {
            while (this.listen) {
                LOG.log(Level.INFO, "[PM] waiting for reqest... ");
                WebSocketProtos.WebSocketRequestMessage request = this.provisioningWebSocket.read(10L, TimeUnit.SECONDS, WebSocketProtos.WebSocketRequestMessage.class);
                LOG.info("DID READ " + String.valueOf(request));
                this.handleRequest(request);
                LOG.log(Level.INFO, "[PM] handled readrequest " + request.getPath());
            }
        }
        catch (Exception ex) {
            System.err.println("[PM] Exception while waiting for incoming request");
            this.listen = false;
            ex.printStackTrace();
            this.provisioningClient.gotProvisioningError(ex.getMessage());
        }
    }

    public void stop() {
        this.listen = false;
        LOG.log(Level.INFO, "[PM] we're asked to disconnect the websocket");
        this.provisioningWebSocket.shutdown();
        LOG.log(Level.INFO, "[PM] stopped");
    }

    public Account createAccount(String nr, String deviceName, WaveStore aciStore, WaveStore pniStore) throws IOException {
        LOG.info("Creating device " + deviceName + " for number " + this.number);
        if (!nr.equals(this.number)) {
            throw new IllegalArgumentException("Can't create account for " + nr);
        }
        byte[] b = new byte[16];
        new SecureRandom().nextBytes(b);
        String password = new String(b, StandardCharsets.UTF_8);
        password = Base64.getEncoder().encodeToString(password.getBytes());
        password = password.substring(0, password.length() - 2);
        String regid = Integer.toString(new SecureRandom().nextInt(16384) & 0x3FFF);
        String pniregid = Integer.toString(new SecureRandom().nextInt(16384) & 0x3FFF);
        ServiceId.Aci aci = this.createAciServiceId();
        aciStore.setServiceId((ServiceId)aci);
        ServiceId.Pni pni = this.createPniServiceId();
        pniStore.setServiceId((ServiceId)pni);
        IdentityKeyPair aciIdentityKey = this.sqliteStorageBean.account().getAciIdentityKey();
        try {
            this.cleanupKeys(aciStore);
            this.cleanupKeys(pniStore);
            byte[] aciPrivateBytes = this.pm.getAciIdentityKeyPrivate().toByteArray();
            ECPrivateKey aciPrivateKey = Curve.decodePrivatePoint((byte[])aciPrivateBytes);
            SignedPreKeyRecord aciPreKeyRecord = KeyUtil.generateSignedPreKey(aciPrivateKey);
            aciStore.storeSignedPreKey(aciPreKeyRecord.getId(), aciPreKeyRecord);
            KyberPreKeyRecord aciKyberPreKeyRecord = KeyUtil.generateKyberPreKey(aciPrivateKey);
            aciStore.storeLastResortKyberPreKey(aciKyberPreKeyRecord.getId(), aciKyberPreKeyRecord);
            SignedPreKeyEntity aspke = new SignedPreKeyEntity(aciPreKeyRecord.getId(), aciPreKeyRecord.getKeyPair().getPublicKey(), aciPreKeyRecord.getSignature());
            LOG.info("aciPreKeyRecord = " + String.valueOf(aciPreKeyRecord) + ", spke = " + String.valueOf(aspke));
            KyberPreKeyEntity akpke = new KyberPreKeyEntity(aciKyberPreKeyRecord.getId(), aciKyberPreKeyRecord.getKeyPair().getPublicKey(), aciKyberPreKeyRecord.getSignature());
            byte[] pniPrivateBytes = this.pm.getPniIdentityKeyPrivate().toByteArray();
            ECPrivateKey pniPrivateKey = Curve.decodePrivatePoint((byte[])pniPrivateBytes);
            SignedPreKeyRecord pniPreKeyRecord = KeyUtil.generateSignedPreKey(pniPrivateKey);
            pniStore.storeSignedPreKey(pniPreKeyRecord.getId(), pniPreKeyRecord);
            KyberPreKeyRecord pniKyberPreKeyRecord = KeyUtil.generateKyberPreKey(pniPrivateKey);
            pniStore.storeLastResortKyberPreKey(pniKyberPreKeyRecord.getId(), pniKyberPreKeyRecord);
            SignedPreKeyEntity pspke = new SignedPreKeyEntity(pniPreKeyRecord.getId(), pniPreKeyRecord.getKeyPair().getPublicKey(), pniPreKeyRecord.getSignature());
            KyberPreKeyEntity pkpke = new KyberPreKeyEntity(pniKyberPreKeyRecord.getId(), pniKyberPreKeyRecord.getKeyPair().getPublicKey(), pniKyberPreKeyRecord.getSignature());
            String encryptedDeviceName = DeviceNameCipher.encryptDeviceName(deviceName, aciIdentityKey);
            this.deviceId = this.confirmCode(this.pm, password, regid, pniregid, encryptedDeviceName, aspke, pspke, akpke, pkpke);
        }
        catch (InvalidKeyException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        LOG.info("Code confirmed!");
        this.sqliteStorageBean.account().setServicePassword(password);
        this.sqliteStorageBean.account().setE164(this.number);
        this.sqliteStorageBean.account().setDeviceId(this.deviceId);
        this.sqliteStorageBean.account().setRegistrationId(regid);
        this.sqliteStorageBean.account().setPniRegistrationId(pniregid);
        Account user = new Account(aci, pni);
        user.setProfileKey(this.pm.getProfileKey().toByteArray());
        byte[] mk = this.pm.getMasterKey().toByteArray();
        if (mk.length == 32) {
            this.sqliteStorageBean.account().setMasterKey(mk);
            MasterKey masterKey = new MasterKey(mk);
            StorageKey storageKey = masterKey.deriveStorageServiceKey();
            this.sqliteStorageBean.storage().setStorageKey(storageKey);
        } else {
            LOG.warning("Got masterkey length " + mk.length + " instead of 32, skipping");
        }
        LOG.info("user created");
        return user;
    }

    private void cleanupKeys(WaveStore store) {
        store.loadSignedPreKeys().stream().forEach(key -> store.removeSignedPreKey(key.getId()));
        store.loadLastResortKyberPreKeys().forEach(lskbk -> store.removeKyberPreKey(lskbk.getId()));
        store.loadKyberPreKeys().forEach(kpk -> store.removePreKey(kpk.getId()));
    }

    public ServiceId.Aci createAciServiceId() {
        ServiceId.Aci aci = new ServiceId.Aci(UUID.fromString(this.pm.getAci()));
        this.sqliteStorageBean.account().setAci(aci);
        this.sqliteStorageBean.account().setAciIdentityPrivateKey(this.pm.getAciIdentityKeyPrivate().toByteArray());
        this.sqliteStorageBean.account().setAciIdentityPublicKey(this.pm.getAciIdentityKeyPublic().toByteArray());
        return aci;
    }

    public ServiceId.Pni createPniServiceId() {
        ServiceId.Pni pni = new ServiceId.Pni(UUID.fromString(this.pm.getPni()));
        this.sqliteStorageBean.account().setPni(pni);
        this.sqliteStorageBean.account().setPniIdentityPrivateKey(this.pm.getPniIdentityKeyPrivate().toByteArray());
        this.sqliteStorageBean.account().setPniIdentityPublicKey(this.pm.getPniIdentityKeyPublic().toByteArray());
        return pni;
    }

    private void handleRequest(SignalServiceEnvelope request) throws Exception {
        System.err.println("CONTENT = " + Arrays.toString(request.getContent()));
        WebSocketProtos.WebSocketRequestMessage wrm = WebSocketProtos.WebSocketRequestMessage.parseFrom((byte[])request.getContent());
        this.handleRequest(wrm);
    }

    private void handleRequest(WebSocketProtos.WebSocketRequestMessage request) throws Exception {
        String path = request.getPath();
        LOG.log(Level.INFO, "[PM] we need to handle a request for path " + path);
        ByteString data = request.getBody();
        if ("/v1/address".equals(path)) {
            String uuid = "";
            try {
                ProvisioningProtos.ProvisioningUuid puuid = ProvisioningProtos.ProvisioningUuid.parseFrom((ByteString)data);
                uuid = puuid.getUuid();
            }
            catch (InvalidProtocolBufferException ex) {
                ex.printStackTrace();
            }
            LOG.log(Level.INFO, "[PM] we got a uuid: " + uuid);
            String ourPubKey = Base64.getEncoder().encodeToString(this.provisioningCipher.getOurKeyPair().getPublicKey().serialize());
            ourPubKey = URLEncoder.encode(ourPubKey, StandardCharsets.UTF_8);
            String url = "sgnl://linkdevice?uuid=" + uuid + "&pub_key=" + ourPubKey + "&capabilities=backup";
            LOG.log(Level.INFO, "pass url " + url + " to our provisioningClient " + String.valueOf(this.provisioningClient));
            if (this.localMode) {
                LOG.info("But first, inform local testserver about our QR code url");
                String burl = Base64.getUrlEncoder().encodeToString(url.getBytes());
                this.networkAPI.sendProvisionUrl(burl);
                LOG.info("LM4");
            }
            this.provisioningClient.gotProvisioningUrl(url);
        } else if ("/v1/message".equals(path)) {
            ProvisioningProtos.ProvisionEnvelope envelope = ProvisioningProtos.ProvisionEnvelope.parseFrom((ByteString)data);
            this.pm = this.provisioningCipher.decrypt(envelope);
            LOG.info("Verification = " + this.pm.getProvisioningCode());
            LOG.info("Do we have a backup ephemeral key? " + String.valueOf(this.pm.getEphemeralBackupKey()));
            LOG.info("PM = " + String.valueOf(this.pm) + " with aci = " + this.pm.getAci() + " and pni = " + this.pm.getPni() + " and masterkey = " + String.valueOf(this.pm.getMasterKey()) + " and backupek = " + String.valueOf(this.pm.getEphemeralBackupKey()) + " and aep = " + this.pm.getAccountEntropyPool() + " and mediakey = " + String.valueOf(this.pm.getMediaRootBackupKey()));
            this.number = this.pm.getNumber();
            this.provisioningClient.gotProvisionMessage(this.pm);
            this.listen = false;
        } else {
            System.err.println("[PM] UNKNOWNPROVISIONINGMESSAGE");
            throw new IllegalArgumentException("UnknownProvisioningMessage");
        }
    }

    private int confirmCode(ProvisioningProtos.ProvisionMessage pm, String pwd, String registrationId, String pniRegistrationId, String encryptedDeviceName, SignedPreKeyEntity aciSignedPreKey, SignedPreKeyEntity pniSignedPreKey, KyberPreKeyEntity aciKyberKey, KyberPreKeyEntity pniKyberKey) throws JsonProcessingException, IOException {
        LOG.info("Confirming code");
        NetworkClient phase2Client = NetworkClient.createNetworkClient(this.waveManager.getNetworkMonitor(), this.networkConfiguration, NetworkConfiguration.Purpose.SERVICE, Optional.empty());
        String body = this.getLinkDevice(pm, encryptedDeviceName, registrationId, pniRegistrationId, aciSignedPreKey, pniSignedPreKey, aciKyberKey, pniKyberKey);
        String username = pm.getNumber();
        String authbase = username + ":" + pwd;
        String basicAuth = Base64.getEncoder().encodeToString(authbase.getBytes());
        try {
            HashMap<String, Object> myHeaders = new HashMap<String, Object>(4);
            myHeaders.put("Authorization", "Basic " + basicAuth);
            myHeaders.put("User-Agent", SIGNAL_USER_AGENT);
            LOG.fine("REG, headers = " + String.valueOf(myHeaders));
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder();
            requestBuilder.header("Authorization", "Basic " + basicAuth);
            requestBuilder.header("User-Agent", SIGNAL_USER_AGENT);
            requestBuilder.header("X-Signal-Agent", SIGNAL_USER_AGENT);
            requestBuilder.header("Content-Type", "application/json");
            requestBuilder.PUT(HttpRequest.BodyPublishers.ofString(body));
            LOG.finer("BODY = " + body);
            URI uri = new URI(host + "/v1/devices/link");
            requestBuilder.uri(uri);
            HttpRequest request = requestBuilder.build();
            Response resp = phase2Client.sendRequest(request, body.getBytes());
            String response = resp.body().string();
            LOG.info("accountresponse = " + response + " and statuscode = " + resp.getStatusCode());
            ObjectMapper mapper = new ObjectMapper();
            JsonNode tree = mapper.readTree(response);
            JsonNode node = tree.get("deviceId");
            if (node == null) {
                throw new IllegalArgumentException("No deviceId in provisioning response");
            }
            if (!node.isNumber()) {
                throw new IllegalArgumentException("DeviceId " + String.valueOf(node) + " is not a number");
            }
            this.deviceId = node.asInt();
            LOG.info("Stored deviceId " + this.deviceId + " in account KV store");
            return this.deviceId;
        }
        catch (Exception e) {
            LOG.info("confirmcode Got error: " + e.getMessage());
            e.printStackTrace();
            throw new IOException(e);
        }
    }

    private ObjectNode createDefaultCapabilities() {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode capabilities = mapper.createObjectNode();
        capabilities.put("paymentActivation", true);
        capabilities.put("deleteSync", true);
        capabilities.put("versionedExpirationTimer", true);
        capabilities.put("ssre2", true);
        return capabilities;
    }

    private String getLinkDevice(ProvisioningProtos.ProvisionMessage pm, String encryptedDeviceName, String regId, String pniRegId, SignedPreKeyEntity aciSignedPreKey, SignedPreKeyEntity pniSignedPreKey, KyberPreKeyEntity aciPqLastResortPreKey, KyberPreKeyEntity pniPqLastResortPreKey) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode jsonData = mapper.createObjectNode();
        jsonData.put("verificationCode", pm.getProvisioningCode());
        jsonData.set("accountAttributes", (JsonNode)this.getAccountAttributes(encryptedDeviceName, regId, pniRegId));
        jsonData.set("aciSignedPreKey", (JsonNode)this.getPreKeyNode(aciSignedPreKey));
        jsonData.set("pniSignedPreKey", (JsonNode)this.getPreKeyNode(pniSignedPreKey));
        jsonData.set("aciPqLastResortPreKey", (JsonNode)this.getPreKeyNode(aciPqLastResortPreKey));
        jsonData.set("pniPqLastResortPreKey", (JsonNode)this.getPreKeyNode(pniPqLastResortPreKey));
        String answer = mapper.writeValueAsString((Object)jsonData);
        return answer;
    }

    private ObjectNode getAccountAttributes(String encryptedDeviceName, String regId, String pniRegId) {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode capabilities = this.createDefaultCapabilities();
        ObjectNode jsonData = mapper.createObjectNode();
        jsonData.set("capabilities", (JsonNode)capabilities);
        jsonData.put("fetchesMessages", true);
        jsonData.put("name", encryptedDeviceName);
        jsonData.put("registrationId", regId);
        jsonData.put("pniRegistrationId", pniRegId);
        return jsonData;
    }

    private ObjectNode getPreKeyNode(SignedPreKeyEntity pke) {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode jsonData = mapper.createObjectNode();
        jsonData.put("keyId", pke.getKeyId());
        jsonData.put("publicKey", pke.getPublicKey().serialize());
        jsonData.put("signature", pke.getSignature());
        return jsonData;
    }

    private ObjectNode getPreKeyNode(KyberPreKeyEntity pke) {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode jsonData = mapper.createObjectNode();
        jsonData.put("keyId", pke.getKeyId());
        jsonData.put("publicKey", pke.getPublicKey().serialize());
        jsonData.put("signature", pke.getSignature());
        return jsonData;
    }

    private void processConfiguration(Map<String, Object> configuration) {
        String myhost;
        Boolean staging = (Boolean)configuration.get("useStaging");
        if (staging != null && staging.booleanValue()) {
            destination = "wss://chat.staging.signal.org";
            host = "https://chat.staging.signal.org";
        }
        if ((myhost = (String)configuration.get("serverHost")) != null) {
            this.localMode = true;
            LOG.warning("Running in local mode, this should not be used in production!");
            destination = "ws://localhost:8079";
            host = "http://localhost:8079";
        }
    }
}

