/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.provision;

import com.google.protobuf.ByteString;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.signal.libsignal.protocol.IdentityKeyPair;
import org.signal.libsignal.protocol.ecc.Curve;
import org.signal.libsignal.protocol.ecc.ECKeyPair;
import org.signal.libsignal.protocol.ecc.ECPrivateKey;
import org.signal.libsignal.protocol.ecc.ECPublicKey;
import org.thoughtcrime.securesms.devicelist.protos.DeviceNameProtos;

public class DeviceNameCipher {
    private static final Logger LOG = Logger.getLogger(DeviceNameCipher.class.getName());
    static final int SYNTHETIC_IV_LENGTH = 16;

    static String encryptDeviceName(String text, IdentityKeyPair ikp) {
        byte[] edn = DeviceNameCipher.encryptDeviceName(text.getBytes(Charset.forName("UTF-8")), ikp);
        return Base64.getEncoder().encodeToString(edn);
    }

    static byte[] encryptDeviceName(byte[] plaintext, IdentityKeyPair identityKeyPair) {
        try {
            ECKeyPair ephemeralKeyPair = Curve.generateKeyPair();
            byte[] masterSecret = Curve.calculateAgreement((ECPublicKey)identityKeyPair.getPublicKey().getPublicKey(), (ECPrivateKey)ephemeralKeyPair.getPrivateKey());
            byte[] syntheticIv = DeviceNameCipher.computeSyntheticIv(masterSecret, plaintext);
            byte[] cipherKey = DeviceNameCipher.computeCipherKey(masterSecret, syntheticIv);
            Cipher cipher = Cipher.getInstance("AES/CTR/NoPadding");
            cipher.init(1, (Key)new SecretKeySpec(cipherKey, "AES"), new IvParameterSpec(new byte[16]));
            byte[] cipherText = cipher.doFinal(plaintext);
            DeviceNameProtos.DeviceName.Builder builder = DeviceNameProtos.DeviceName.newBuilder();
            builder.setCiphertext(ByteString.copyFrom((byte[])cipherText)).setEphemeralPublic(ByteString.copyFrom((byte[])ephemeralKeyPair.getPublicKey().serialize())).setSyntheticIv(ByteString.copyFrom((byte[])syntheticIv));
            DeviceNameProtos.DeviceName build = builder.build();
            return build.toByteArray();
        }
        catch (Throwable ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
    }

    private static byte[] computeCipherKey(byte[] masterSecret, byte[] syntheticIv) {
        try {
            byte[] input = "cipher".getBytes(Charset.forName("UTF-8"));
            Mac keyMac = Mac.getInstance("HmacSHA256");
            keyMac.init(new SecretKeySpec(masterSecret, "HmacSHA256"));
            byte[] cipherKeyKey = keyMac.doFinal(input);
            Mac cipherMac = Mac.getInstance("HmacSHA256");
            cipherMac.init(new SecretKeySpec(cipherKeyKey, "HmacSHA256"));
            return cipherMac.doFinal(syntheticIv);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
    }

    private static byte[] computeSyntheticIv(byte[] masterSecret, byte[] plaintext) {
        try {
            byte[] input = "auth".getBytes(Charset.forName("UTF-8"));
            Mac keyMac = Mac.getInstance("HmacSHA256");
            keyMac.init(new SecretKeySpec(masterSecret, "HmacSHA256"));
            byte[] syntheticIvKey = keyMac.doFinal(input);
            Mac ivMac = Mac.getInstance("HmacSHA256");
            ivMac.init(new SecretKeySpec(syntheticIvKey, "HmacSHA256"));
            byte[] res = ivMac.doFinal(plaintext);
            return Arrays.copyOf(res, 16);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
    }
}

