/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.net;

import io.privacyresearch.equation.net.SignalUrl;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.whispersystems.signalservice.api.push.TrustStore;

public class NetworkConfiguration {
    static final Logger LOG = Logger.getLogger(NetworkConfiguration.class.getName());
    static final String DEFAULT_SERVICE_URL = "https://chat.signal.org";
    static final String DEFAULT_STORAGE_URL = "https://storage.signal.org";
    static final String PROVISIONING_SUFFIX = "/v1/websocket/provisioning/";
    static final String DEFAULT_ZKGROUP_SERVER_PUBLIC_PARAMS = "AMhf5ywVwITZMsff/eCyudZx9JDmkkkbV6PInzG4p8x3VqVJSFiMvnvlEKWuRob/1eaIetR31IYeAbm0NdOuHH8Qi+Rexi1wLlpzIo1gstHWBfZzy1+qHRV5A4TqPp15YzBPm0WSggW6PbSn+F4lf57VCnHF7p8SvzAA2ZZJPYJURt8X7bbg+H3i+PEjH9DXItNEqs2sNcug37xZQDLm7X36nOoGPs54XsEGzPdEV+itQNGUFEjY6X9Uv+Acuks7NpyGvCoKxGwgKgE5XyJ+nNKlyHHOLb6N1NuHyBrZrgtY/JYJHRooo5CEqYKBqdFnmbTVGEkCvJKxLnjwKWf+fEPoWeQFj5ObDjcKMZf2Jm2Ae69x+ikU5gBXsRmoF94GXTLfN0/vLt98KDPnxwAQL9j5V1jGOY8jQl6MLxEs56cwXN0dqCnImzVH3TZT1cJ8SW1BRX6qIVxEzjsSGx3yxF3suAilPMqGRp4ffyopjMD1JXiKR2RwLKzizUe5e8XyGOy9fplzhw3jVzTRyUZTRSZKkMLWcQ/gv0E4aONNqs4P+NameAZYOD12qRkxosQQP5uux6B2nRyZ7sAV54DgFyLiRcq1FvwKw2EPQdk4HDoePrO/RNUbyNddnM/mMgj4FW65xCoT1LmjrIjsv/Ggdlx46ueczhMgtBunx1/w8k8V+l8LVZ8gAT6wkU5J+DPQalQguMg12Jzug3q4TbdHiGCmD9EunCwOmsLuLJkz6EcSYXtrlDEnAM+hicw7iergYLLlMXpfTdGxJCWJmP4zqUFeTTmsmhsjGBt7NiEB/9pFFEB3pSbf4iiUukw63Eo8Aqnf4iwob6X1QviCWuc8t0LUlT9vALgh/f2DPVOOmR0RW6bgRvc7DSF20V/omg+YBw==";
    private boolean useQuic = false;
    private String serverHost = "https://chat.signal.org";
    private String storageHost = "https://storage.signal.org";
    private String zkGroupServerPublicParams = "AMhf5ywVwITZMsff/eCyudZx9JDmkkkbV6PInzG4p8x3VqVJSFiMvnvlEKWuRob/1eaIetR31IYeAbm0NdOuHH8Qi+Rexi1wLlpzIo1gstHWBfZzy1+qHRV5A4TqPp15YzBPm0WSggW6PbSn+F4lf57VCnHF7p8SvzAA2ZZJPYJURt8X7bbg+H3i+PEjH9DXItNEqs2sNcug37xZQDLm7X36nOoGPs54XsEGzPdEV+itQNGUFEjY6X9Uv+Acuks7NpyGvCoKxGwgKgE5XyJ+nNKlyHHOLb6N1NuHyBrZrgtY/JYJHRooo5CEqYKBqdFnmbTVGEkCvJKxLnjwKWf+fEPoWeQFj5ObDjcKMZf2Jm2Ae69x+ikU5gBXsRmoF94GXTLfN0/vLt98KDPnxwAQL9j5V1jGOY8jQl6MLxEs56cwXN0dqCnImzVH3TZT1cJ8SW1BRX6qIVxEzjsSGx3yxF3suAilPMqGRp4ffyopjMD1JXiKR2RwLKzizUe5e8XyGOy9fplzhw3jVzTRyUZTRSZKkMLWcQ/gv0E4aONNqs4P+NameAZYOD12qRkxosQQP5uux6B2nRyZ7sAV54DgFyLiRcq1FvwKw2EPQdk4HDoePrO/RNUbyNddnM/mMgj4FW65xCoT1LmjrIjsv/Ggdlx46ueczhMgtBunx1/w8k8V+l8LVZ8gAT6wkU5J+DPQalQguMg12Jzug3q4TbdHiGCmD9EunCwOmsLuLJkz6EcSYXtrlDEnAM+hicw7iergYLLlMXpfTdGxJCWJmP4zqUFeTTmsmhsjGBt7NiEB/9pFFEB3pSbf4iiUukw63Eo8Aqnf4iwob6X1QviCWuc8t0LUlT9vALgh/f2DPVOOmR0RW6bgRvc7DSF20V/omg+YBw==";
    private String proxy = null;
    private final TrustStore trustStore;
    Map<Integer, ConnectionHolder> connectionHolders = new HashMap<Integer, ConnectionHolder>();

    public NetworkConfiguration(TrustStore trustStore) {
        this.trustStore = trustStore;
        ConnectionHolder connectionHolder0 = new ConnectionHolder(this, URI.create("https://cdn.signal.org"));
        this.connectionHolders.put(0, connectionHolder0);
        ConnectionHolder connectionHolder2 = new ConnectionHolder(this, URI.create("https://cdn2.signal.org"));
        this.connectionHolders.put(2, connectionHolder2);
        ConnectionHolder connectionHolder3 = new ConnectionHolder(this, URI.create("https://cdn3.signal.org"));
        this.connectionHolders.put(3, connectionHolder3);
    }

    public boolean isUseQuic() {
        return this.useQuic;
    }

    public void setUseQuic(boolean useQuic) {
        this.useQuic = useQuic;
    }

    public String getServerHost() {
        return this.serverHost;
    }

    public void setStorageHost(String storageHost) {
        this.storageHost = storageHost;
    }

    public void setServerHost(String serverHost) {
        this.serverHost = serverHost;
    }

    public URI getEndpoint() {
        try {
            return new URI(this.serverHost);
        }
        catch (URISyntaxException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public URI getStorageEndpoint() {
        try {
            return new URI(this.storageHost);
        }
        catch (URISyntaxException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public String getProxy() {
        return this.proxy;
    }

    public void setProxy(String proxy) {
        this.proxy = proxy;
    }

    public SignalUrl getSignalUrl(Purpose purpose) {
        if (purpose == Purpose.PROVISIONING) {
            return new SignalUrl(this.serverHost + PROVISIONING_SUFFIX, null, this.trustStore);
        }
        return new SignalUrl(this.serverHost, null, this.trustStore);
    }

    public ConnectionHolder getCdnHolder(int nr) {
        LOG.info("Need to get holder for cdn " + nr);
        return this.connectionHolders.get(nr);
    }

    public byte[] getZkGroupServerPublicParams() {
        return Base64.getDecoder().decode(this.zkGroupServerPublicParams);
    }

    public class ConnectionHolder {
        private URI endpointUri;

        public ConnectionHolder(NetworkConfiguration this$0, URI uri) {
            this.endpointUri = uri;
        }

        public URI getEndpointUri() {
            return this.endpointUri;
        }

        public Optional<String> getHostHeader() {
            return Optional.empty();
        }
    }

    public static enum Purpose {
        SERVICE,
        PROVISIONING;

    }
}

