/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.backup;

import com.google.protobuf.ByteString;
import io.privacyresearch.clientdata.EntityKey;
import io.privacyresearch.clientdata.SqliteStorageBean;
import io.privacyresearch.clientdata.attachment.AttachmentRecord;
import io.privacyresearch.clientdata.channel.ChannelRecord;
import io.privacyresearch.clientdata.group.GroupRecord;
import io.privacyresearch.clientdata.keyvalue.Preferences;
import io.privacyresearch.clientdata.message.BodyRange;
import io.privacyresearch.clientdata.message.MessageDbRecord;
import io.privacyresearch.clientdata.quote.QuoteRecord;
import io.privacyresearch.clientdata.reaction.ReactionDbRecord;
import io.privacyresearch.clientdata.recipient.RecipientKey;
import io.privacyresearch.clientdata.user.UserDbRecord;
import io.privacyresearch.clientdata.util.UUIDUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import org.thoughtcrime.securesms.backup.v2.proto.Backup;

public class Converter {
    private static final Logger LOG = Logger.getLogger(Converter.class.getName());
    private final SqliteStorageBean sqliteStorageBean;
    private final UserDbRecord self;
    static Map<Long, Backup.Recipient> recipientMap = new HashMap<Long, Backup.Recipient>();
    static Map<RecipientKey, Long> keyRecipientMap = new HashMap<RecipientKey, Long>();
    static long recipientIdCounter = 1L;
    static Map<Long, Backup.Chat> chatMap = new HashMap<Long, Backup.Chat>();
    static Map<RecipientKey, Long> keyChatMap = new HashMap<RecipientKey, Long>();
    static long chatIdCounter = 1L;

    public Converter(SqliteStorageBean sqliteStorageBean) {
        this(sqliteStorageBean, sqliteStorageBean.getUserCache().getSelf());
    }

    public Converter(SqliteStorageBean sqliteStorageBean, UserDbRecord me) {
        this.sqliteStorageBean = sqliteStorageBean;
        this.self = me;
    }

    Backup.Frame createContactFrame(UserDbRecord record) {
        Backup.Contact.Builder builder = Backup.Contact.newBuilder();
        if (record.aci() != null) {
            builder.setAci(ByteString.copyFrom((byte[])record.aci().toServiceIdBinary()));
        }
        if (record.pni() != null) {
            builder.setPni(ByteString.copyFrom((byte[])record.pni().toServiceIdBinary()));
        }
        if (record.username() != null) {
            builder.setUsername(record.username());
        }
        if (record.profileKey() != null) {
            builder.setProfileKey(ByteString.copyFrom((byte[])record.profileKey()));
        }
        if (record.profileGivenName() != null) {
            builder.setProfileGivenName(record.profileGivenName());
        }
        if (record.profileFamilyName() != null) {
            builder.setProfileFamilyName(record.profileFamilyName());
        }
        long myRecipientId = recipientIdCounter++;
        Backup.Recipient recipient = Backup.Recipient.newBuilder().setId(myRecipientId).setContact(builder).build();
        recipientMap.put(myRecipientId, recipient);
        keyRecipientMap.put(record.recipientKey(), myRecipientId);
        Backup.Frame frame = Backup.Frame.newBuilder().setRecipient(recipient).build();
        return frame;
    }

    public List<Backup.Frame> createAccountFrames(UserDbRecord record) {
        Backup.AccountData.Builder builder = Backup.AccountData.newBuilder();
        if (record.profileKey() != null) {
            builder.setProfileKey(ByteString.copyFrom((byte[])record.profileKey()));
        }
        if (record.username() != null) {
            builder.setUsername(record.username());
        }
        Backup.AccountData.AccountSettings.Builder settingsBuilder = Backup.AccountData.AccountSettings.newBuilder();
        Preferences prefs = this.sqliteStorageBean.preference().getPreferences();
        settingsBuilder.setReadReceipts(prefs.readReceipts());
        settingsBuilder.setTypingIndicators(prefs.typingIndicators());
        settingsBuilder.setStoriesDisabled(!prefs.storiesEnabled());
        switch (record.phoneNumberSharing()) {
            case UNKNOWN: {
                settingsBuilder.setPhoneNumberSharingMode(Backup.AccountData.PhoneNumberSharingMode.UNKNOWN);
                break;
            }
            case EVERYBODY: {
                settingsBuilder.setPhoneNumberSharingMode(Backup.AccountData.PhoneNumberSharingMode.EVERYBODY);
                break;
            }
            case NOBODY: {
                settingsBuilder.setPhoneNumberSharingMode(Backup.AccountData.PhoneNumberSharingMode.NOBODY);
            }
        }
        builder.setAccountSettings(settingsBuilder);
        long myRecipientId = recipientIdCounter++;
        Backup.Self self = Backup.Self.newBuilder().build();
        Backup.Recipient selfRecipient = Backup.Recipient.newBuilder().setId(myRecipientId).setSelf(self).build();
        recipientMap.put(myRecipientId, selfRecipient);
        keyRecipientMap.put(record.recipientKey(), myRecipientId);
        Backup.Frame recipientFrame = Backup.Frame.newBuilder().setRecipient(selfRecipient).build();
        Backup.Frame accountFrame = Backup.Frame.newBuilder().setAccount(builder).build();
        return List.of(recipientFrame, accountFrame);
    }

    Backup.Frame createGroupFrame(GroupRecord record) {
        Backup.Group.Builder builder = Backup.Group.newBuilder();
        builder.setMasterKey(ByteString.copyFrom((byte[])record.getMasterKey().serialize())).setHideStory(record.hideStory()).setWhitelisted(record.whitelisted());
        if (record.title() != null) {
            builder.setSnapshot(Backup.Group.GroupSnapshot.newBuilder().setTitle(Backup.Group.GroupAttributeBlob.newBuilder().setTitle(record.title())));
        }
        long myRecipientId = recipientIdCounter++;
        Backup.Recipient recipient = Backup.Recipient.newBuilder().setId(myRecipientId).setGroup(builder).build();
        recipientMap.put(myRecipientId, recipient);
        keyRecipientMap.put(record.recipient().key(), myRecipientId);
        Backup.Frame frame = Backup.Frame.newBuilder().setRecipient(recipient).build();
        return frame;
    }

    public Backup.Frame createChatFrame(ChannelRecord record) {
        Backup.Chat.Builder builder = Backup.Chat.newBuilder();
        long myChatId = chatIdCounter++;
        builder.setId(myChatId);
        builder.setArchived(record.archived());
        builder.setExpirationTimerMs((long)record.recipient().expireMessages());
        Long recId = keyRecipientMap.get(record.recipient().key());
        if (recId == null) {
            LOG.severe("No recipient found for " + String.valueOf(record.recipient()));
            throw new IllegalArgumentException();
        }
        builder.setRecipientId(recId.longValue());
        Backup.Chat chat = builder.build();
        chatMap.put(myChatId, chat);
        keyChatMap.put(record.recipient().key(), myChatId);
        Backup.Frame frame = Backup.Frame.newBuilder().setChat(chat).build();
        return frame;
    }

    Backup.Frame createChatItemFrame(MessageDbRecord record) {
        Backup.ChatItem.Builder builder = Backup.ChatItem.newBuilder();
        UserDbRecord user = (UserDbRecord)this.sqliteStorageBean.getUserData().findByKey((EntityKey)record.senderKey());
        Long authorId = keyRecipientMap.get(user.recipientKey());
        if (authorId == null) {
            LOG.info("Couldn't find author for " + String.valueOf(record));
        }
        builder.setAuthorId(authorId.longValue());
        Long chatId = keyChatMap.get(record.receiverKey());
        builder.setChatId(chatId.longValue());
        builder.setDateSent(record.dateSent());
        if (record.expireStarted() > 0L) {
            builder.setExpireStartDate(record.expireStarted());
        }
        if (record.expiresIn() > 0) {
            builder.setExpiresInMs((long)record.expiresIn());
        }
        builder.setStandardMessage(this.createStandardMessageBuilder(record));
        if (this.self.key().equals((Object)record.senderKey())) {
            Backup.ChatItem.OutgoingMessageDetails.Builder omBuilder = Backup.ChatItem.OutgoingMessageDetails.newBuilder();
            Backup.SendStatus.Builder sendStatusBuilder = Backup.SendStatus.newBuilder();
            omBuilder.addSendStatus(sendStatusBuilder);
            builder.setOutgoing(omBuilder);
        }
        Backup.ChatItem chatItem = builder.build();
        Backup.Frame frame = Backup.Frame.newBuilder().setChatItem(chatItem).build();
        return frame;
    }

    Backup.StandardMessage.Builder createStandardMessageBuilder(MessageDbRecord record) {
        Backup.StandardMessage.Builder builder = Backup.StandardMessage.newBuilder();
        Backup.Text.Builder textBuilder = this.createTextBuilder(record.body(), record.bodyRanges());
        builder.setText(textBuilder);
        List reactionRecords = this.sqliteStorageBean.getReactionData().findByMessageKey(record.key());
        for (ReactionDbRecord reactionRecord : reactionRecords) {
            builder.addReactions(this.createReactionBuilder(reactionRecord));
        }
        QuoteRecord quoteRecord = this.sqliteStorageBean.getQuoteData().findQuoteByMessageKey(record.key());
        if (quoteRecord != null) {
            // empty if block
        }
        List attachmentRecords = this.sqliteStorageBean.getAttachmentData().findByMessageKey(record.key());
        for (AttachmentRecord attrecord : attachmentRecords) {
            Backup.MessageAttachment.Builder attBuilder = Backup.MessageAttachment.newBuilder().setPointer(this.createFilePointerBuilder(attrecord)).setFlag(Backup.MessageAttachment.Flag.NONE);
            builder.addAttachments(attBuilder);
        }
        return builder;
    }

    Backup.FilePointer.Builder createFilePointerBuilder(AttachmentRecord record) {
        byte[] inc;
        String mediaName = this.buildMediaName(record);
        Backup.FilePointer.Builder builder = Backup.FilePointer.newBuilder();
        builder.setBackupLocator(Backup.FilePointer.BackupLocator.newBuilder().setCdnNumber(record.cdnNumber()).setMediaName(mediaName).setSize(record.size()));
        if (record.cdnKey() != null) {
            builder.setContentType(record.cdnKey().getV3());
        }
        if (record.contentType() != null) {
            builder.setContentType(record.contentType());
        }
        if ((inc = record.incrementalMac()) != null && inc.length > 0) {
            builder.setIncrementalMac(ByteString.copyFrom((byte[])inc));
        }
        if (record.incrementalMacChunkSize() > 0) {
            builder.setIncrementalMacChunkSize(record.incrementalMacChunkSize());
        }
        if (record.fileName() != null) {
            builder.setFileName(record.fileName());
        }
        if (record.width() > 0) {
            builder.setWidth(record.width());
        }
        if (record.height() > 0) {
            builder.setHeight(record.height());
        }
        if (record.caption() != null) {
            builder.setCaption(record.caption());
        }
        if (record.blurHash() != null) {
            builder.setBlurHash(record.blurHash());
        }
        return builder;
    }

    private String buildMediaName(AttachmentRecord record) {
        throw new UnsupportedOperationException();
    }

    Backup.Reaction.Builder createReactionBuilder(ReactionDbRecord record) {
        RecipientKey author = record.authorRecipientKey();
        Long authorId = keyRecipientMap.get(author);
        Backup.Reaction.Builder builder = Backup.Reaction.newBuilder().setEmoji(record.emoji()).setSentTimestamp(record.dateSent());
        if (authorId != null) {
            builder.setAuthorId(authorId.longValue());
        } else {
            LOG.severe("Unknown reaction author: " + String.valueOf(record));
        }
        return builder;
    }

    Backup.Text.Builder createTextBuilder(String text, List<BodyRange> bodyRanges) {
        Backup.Text.Builder textBuilder = Backup.Text.newBuilder();
        textBuilder.setBody(text);
        bodyRanges.stream().map(br -> this.createBodyRange((BodyRange)br)).forEach(br -> textBuilder.addBodyRanges(br));
        return textBuilder;
    }

    Backup.BodyRange.Builder createBodyRange(BodyRange bodyRange) {
        Backup.BodyRange.Builder builder = Backup.BodyRange.newBuilder();
        builder.setStart(bodyRange.start());
        builder.setLength(bodyRange.length());
        if (bodyRange.isMention()) {
            byte[] aciBytes = UUIDUtil.toByteArray((UUID)UUID.fromString(bodyRange.mentionAci()));
            builder.setMentionAci(ByteString.copyFrom((byte[])aciBytes));
        } else {
            switch (bodyRange.style()) {
                case NONE: {
                    builder.setStyle(Backup.BodyRange.Style.NONE);
                }
                case BOLD: {
                    builder.setStyle(Backup.BodyRange.Style.BOLD);
                }
                case ITALIC: {
                    builder.setStyle(Backup.BodyRange.Style.ITALIC);
                }
                case SPOILER: {
                    builder.setStyle(Backup.BodyRange.Style.SPOILER);
                }
                case STRIKETHROUGH: {
                    builder.setStyle(Backup.BodyRange.Style.STRIKETHROUGH);
                }
                case MONOSPACE: {
                    builder.setStyle(Backup.BodyRange.Style.MONOSPACE);
                }
            }
        }
        return builder;
    }
}

