/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation;

import io.privacyresearch.clientdata.EntityKey;
import io.privacyresearch.clientdata.message.MessageData;
import io.privacyresearch.clientdata.message.MessageDbRecord;
import io.privacyresearch.clientdata.message.MessageKey;
import io.privacyresearch.clientdata.message.StoryType;
import io.privacyresearch.equation.StoryService;
import io.privacyresearch.equation.message.MessagingClient;
import io.privacyresearch.equation.model.MessageRecord;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.logging.Logger;

public class MessageCollector
extends Thread {
    private static final Logger LOG = Logger.getLogger(MessageCollector.class.getName());
    private final MessagingClient client;
    private final StoryService storyService;
    private final Function<MessageDbRecord, MessageRecord> messageFromDb;
    private final MessageData messageData;
    private CountDownLatch triggerLatch = new CountDownLatch(1);

    public MessageCollector(MessagingClient client, MessageData messageData, StoryService storyService, Function<MessageDbRecord, MessageRecord> messageFromDb) {
        this.client = client;
        this.messageFromDb = messageFromDb;
        this.messageData = messageData;
        this.storyService = storyService;
    }

    public void trigger() {
        this.triggerLatch.countDown();
    }

    @Override
    public void run() {
        boolean go = true;
        while (go) {
            try {
                boolean normal;
                List messageKeys = this.messageData.getExpired();
                LOG.info("Need to remove " + messageKeys.size() + " items");
                for (MessageKey messageKey : messageKeys) {
                    MessageDbRecord dbRecord = (MessageDbRecord)this.messageData.findByKey((EntityKey)messageKey);
                    this.messageData.deleteByKey(messageKey);
                    if (dbRecord.storyType() != StoryType.NONE) {
                        this.storyService.deleteStoryContents(dbRecord);
                        continue;
                    }
                    this.client.messageExpired(this.messageFromDb.apply(dbRecord));
                }
                LOG.info("Removed " + messageKeys.size() + " items");
                this.triggerLatch = new CountDownLatch(1);
                long timeoutInMillis = 30000L;
                MessageDbRecord nextExpiring = this.messageData.getNextExpiring();
                if (nextExpiring != null) {
                    LOG.info("expstarted = " + nextExpiring.expireStarted() + ", expin = " + nextExpiring.expiresIn());
                    timeoutInMillis = nextExpiring.expireStarted() + (long)nextExpiring.expiresIn() * 1000L - System.currentTimeMillis();
                    LOG.info("hence tl = " + timeoutInMillis);
                    timeoutInMillis = Math.max(0L, timeoutInMillis);
                }
                if (normal = this.triggerLatch.await(timeoutInMillis, TimeUnit.MILLISECONDS)) {
                    LOG.info("Interrupted while waiting for next expiration cycle");
                    continue;
                }
                LOG.info("Waited for next expiration cycle");
            }
            catch (Throwable t) {
                t.printStackTrace();
                try {
                    Thread.sleep(10000L);
                }
                catch (Throwable t2) {
                    t2.printStackTrace();
                    go = false;
                }
            }
        }
    }
}

