/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation;

import io.privacyresearch.clientdata.SqliteStorageBean;
import io.privacyresearch.clientdata.group.GroupData;
import io.privacyresearch.clientdata.message.InfoMessage;
import io.privacyresearch.clientdata.recipient.RecipientRecord;
import io.privacyresearch.equation.EquationManager;
import io.privacyresearch.equation.message.MessagingClient;
import io.privacyresearch.equation.user.UserService;
import java.util.logging.Logger;

public class GroupChangeUtil {
    private static final Logger LOG = Logger.getLogger(GroupChangeUtil.class.getName());
    private final SqliteStorageBean sqliteStorageBean;
    private final GroupData groupData;
    private final MessagingClient messageListener;
    private final UserService userService;
    private final EquationManager wave;

    public GroupChangeUtil(EquationManager wave, UserService userService, SqliteStorageBean sqliteStorageBean, MessagingClient messageListener) {
        this.sqliteStorageBean = sqliteStorageBean;
        this.groupData = sqliteStorageBean.getGroupData();
        this.messageListener = messageListener;
        this.userService = userService;
        this.wave = wave;
    }

    void announceNewGroup(RecipientRecord groupRecipient, long timestamp) {
        InfoMessage infoMessage = new InfoMessage(InfoMessage.Type.INFO_GROUP_NEW_ME, new String[0]);
        this.messageListener.gotInfoMessage(groupRecipient, timestamp, infoMessage);
    }
}

