/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation;

import io.privacyresearch.clientdata.attachment.AttachmentKey;
import io.privacyresearch.clientdata.attachment.AttachmentRecord;
import io.privacyresearch.clientdata.canvas.CanvasDbRecord;
import io.privacyresearch.clientdata.channel.ChannelKey;
import io.privacyresearch.clientdata.channel.ChannelRecord;
import io.privacyresearch.clientdata.distributionlist.DistributionListDbRecord;
import io.privacyresearch.clientdata.draft.DraftRecord;
import io.privacyresearch.clientdata.draft.UpdateDraftRequest;
import io.privacyresearch.clientdata.group.GroupRecord;
import io.privacyresearch.clientdata.keyvalue.UsernameLink;
import io.privacyresearch.clientdata.message.MessageKey;
import io.privacyresearch.clientdata.message.ReceiptDbRecord;
import io.privacyresearch.clientdata.reaction.CreateReactionRequest;
import io.privacyresearch.clientdata.recipient.RecipientKey;
import io.privacyresearch.clientdata.search.SearchMessageRecord;
import io.privacyresearch.clientdata.sticker.StickerPackRecord;
import io.privacyresearch.clientdata.sticker.StickerRecord;
import io.privacyresearch.clientdata.user.UserKey;
import io.privacyresearch.equation.backup.BackupStatus;
import io.privacyresearch.equation.call.CallRecord;
import io.privacyresearch.equation.message.MessagingClient;
import io.privacyresearch.equation.model.Account;
import io.privacyresearch.equation.model.Attachment;
import io.privacyresearch.equation.model.Call;
import io.privacyresearch.equation.model.DeviceLinkOptions;
import io.privacyresearch.equation.model.FullQuoteRecord;
import io.privacyresearch.equation.model.Message;
import io.privacyresearch.equation.model.MessageRecord;
import io.privacyresearch.equation.model.ReactionRecord;
import io.privacyresearch.equation.model.RegistrationResponse;
import io.privacyresearch.equation.model.SendStickerRequest;
import io.privacyresearch.equation.model.Story;
import io.privacyresearch.equation.provision.ProvisioningClient;
import io.privacyresearch.equation.user.UserRecord;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.signal.libsignal.metadata.certificate.InvalidCertificateException;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.protocol.InvalidRegistrationIdException;
import org.signal.libsignal.protocol.NoSessionException;
import org.signal.libsignal.protocol.ServiceId;
import org.signal.libsignal.usernames.Username;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.whispersystems.signalservice.api.crypto.UntrustedIdentityException;
import org.whispersystems.signalservice.internal.ProvisioningProtos;

public interface EquationAPI {
    public boolean initialize();

    default public void startListening() {
    }

    public boolean isProvisioned();

    public UserRecord getSelf();

    public void createAccount(ProvisioningProtos.ProvisionMessage var1, String var2, DeviceLinkOptions var3, Consumer<String> var4) throws IOException;

    public Account getAccount();

    public List<UserRecord> getAllUsers();

    public UserRecord getUserByRecipientKey(RecipientKey var1);

    default public UserRecord getUserByUserKey(UserKey userKey) {
        return null;
    }

    public String searchByUsername(String var1);

    public List<GroupRecord> getAllGroups();

    public GroupRecord getGroupRecordByRecipientKey(RecipientKey var1);

    public List<ChannelRecord> getAllChannels();

    public ChannelRecord getChannelByKey(ChannelKey var1);

    @Deprecated(forRemoval=true)
    default public ChannelRecord getChannelForRecipientKey(RecipientKey recipientKey) {
        return null;
    }

    public ChannelRecord getChannelByRecipientKey(RecipientKey var1);

    public List<ChannelRecord> searchChannels(String var1, int var2, int var3);

    public List<MessageRecord> getMessagesForRecipientKey(RecipientKey var1);

    public List<MessageRecord> getMessagesForRecipientKey(RecipientKey var1, long var2, int var4);

    default public List<MessageRecord> getMessageHistory(MessageKey messageKey) {
        return List.of();
    }

    public List<SearchMessageRecord> searchMessages(String var1);

    public List<SearchMessageRecord> searchMessagesByRecipientKey(String var1, RecipientKey var2);

    public FullQuoteRecord getQuoteByMessageKey(MessageKey var1);

    public List<ReactionRecord> getReactionsByMessageKey(MessageKey var1);

    default public List<ReceiptDbRecord> getReceiptsByMessageKey(MessageKey messageKey) {
        return List.of();
    }

    public List<AttachmentRecord> getAttachmentsByMessageKey(MessageKey var1);

    default public CompletableFuture<InputStream> getAttachmentInputStream(AttachmentKey key) {
        return null;
    }

    default public void updateAttachtmentEncryptedSize(AttachmentKey key, int newSize) {
    }

    public Map<StickerPackRecord, List<StickerRecord>> getStickerPacks();

    public Optional<DraftRecord> getDraftForChannel(ChannelKey var1);

    default public List<Story> getStories() {
        return List.of();
    }

    public void startProvisioning(ProvisioningClient var1);

    public void storeReactionRecord(CreateReactionRequest var1);

    public void clientRead(ChannelKey var1, long var2);

    default public void clientViewedOnce(MessageKey key) {
    }

    public void retrieveUserByUuidAndProfileKey(UUID var1, byte[] var2);

    default public void retrieveUserByUuidAndProfileKey(UserRecord userRecord) {
    }

    public void deleteMessage(MessageKey var1, boolean var2);

    default public void deleteMessagesByRecipientKey(RecipientKey key, long timestamp) {
    }

    public void clearDraft(ChannelKey var1);

    public void updateDraft(ChannelKey var1, UpdateDraftRequest var2);

    default public boolean updateNickInfo(ServiceId serviceId, String given, String last, String note) {
        return true;
    }

    default public boolean updateMuteUntil(RecipientKey recipientKey, long muteUntil) {
        return true;
    }

    default public void updateGroupTitleAndDescription(String title, String description, byte[] avatarBytes, GroupRecord group) {
    }

    default public void updateMyProfile(String name, String about, boolean hasAvatar, Optional<Path> avatar) {
    }

    default public void submitCaptchaAndResend(String token) {
    }

    public long sendGroupMessage(RecipientKey var1, Message var2, List<Attachment> var3) throws IOException, InvalidCertificateException, InvalidInputException, UntrustedIdentityException, NoSessionException, InvalidKeyException, InvalidRegistrationIdException;

    public long sendMessage(RecipientKey var1, Message var2, long var3, List<Attachment> var5) throws IOException;

    default public void sendTypingMessage(RecipientKey recipientKey, boolean typing) throws IOException {
    }

    default public long sendReaction(String emoji, MessageKey messageKey, boolean remove) throws IOException {
        return -1L;
    }

    @Deprecated(forRemoval=true)
    public void sendReaction(RecipientKey var1, RecipientKey var2, String var3, MessageKey var4, boolean var5) throws IOException;

    @Deprecated(forRemoval=true)
    public long sendGroupReaction(GroupRecord var1, RecipientKey var2, String var3, MessageKey var4, boolean var5) throws IOException, InvalidCertificateException, InvalidInputException, UntrustedIdentityException, NoSessionException, InvalidKeyException, InvalidRegistrationIdException;

    public MessageRecord sendExpireTimerMessage(RecipientKey var1, int var2);

    public long sendStickerMessage(RecipientKey var1, SendStickerRequest var2) throws IOException, InvalidCertificateException, InvalidInputException, UntrustedIdentityException, NoSessionException, InvalidKeyException, InvalidRegistrationIdException;

    default public void sendStory(Story story) {
    }

    public DistributionListDbRecord createDistributionList(String var1, Set<RecipientKey> var2);

    default public void updateCanvas(CanvasDbRecord record) {
    }

    default public List<CanvasDbRecord> getCanvasListByChannel(ChannelKey channelKey) {
        return List.of();
    }

    public Username reserveUsername(String var1);

    public boolean confirmReservation(Username var1);

    public void updateUsernameLink(UsernameLink var1);

    public void exportCloudBackup(BackupStatus var1);

    public void exportFileBackup(BackupStatus var1, Path var2);

    public List<CallRecord> getAllCalls();

    public void sendCallHangupMessage(Call var1);

    public void enableVideoCall(Call var1, boolean var2);

    public Call startOutgoingCall(RecipientKey var1, boolean var2);

    public void acceptCall();

    public void hangupCall(Call var1);

    public void ignoreCall();

    default public void setOnFatalError(Supplier<Boolean> sup) {
    }

    default public void setOnRestartRequest(Consumer<String> p) {
    }

    public void setMessageListener(MessagingClient var1);

    public boolean addNetworkListener(Consumer<Boolean> var1);

    default public RegistrationResponse registerAccount(String number, String token, String transport) {
        return null;
    }

    default public RegistrationResponse confirmRegistrationCode(String code) {
        return null;
    }

    default public boolean enableCheats(boolean enable) {
        return false;
    }

    default public boolean hasCheatsEnabled() {
        return false;
    }

    default public boolean setCheatFor(String cheat, boolean val) {
        return false;
    }

    default public boolean hasCheatFor(String cheat) {
        return false;
    }

    default public void setUseProxy(boolean v) {
    }

    default public boolean isUseProxy() {
        return false;
    }

    default public void setEnableServerProxy(boolean v) {
    }

    default public boolean isEnabledServerProxy() {
        return false;
    }

    default public void shareProxyWithChannel(ChannelKey channelKey) {
    }

    default public void setUseQuic(boolean v) {
    }

    default public boolean isUseQuic() {
        return false;
    }
}

