/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation;

import io.privacyresearch.clientdata.attachment.AttachmentKey;
import io.privacyresearch.clientdata.attachment.AttachmentRecord;
import io.privacyresearch.equation.EquationAPI;
import io.privacyresearch.equation.attachment.SignalServiceAttachment;
import io.privacyresearch.equation.attachment.SignalServiceAttachmentPointer;
import io.privacyresearch.equation.attachment.SignalServiceAttachmentStream;
import io.privacyresearch.equation.model.Attachment;
import io.privacyresearch.equation.net.NetworkAPI;
import io.privacyresearch.equation.net.ResumableUploadSpec;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.signal.libsignal.protocol.InvalidMessageException;
import org.whispersystems.signalservice.api.crypto.AttachmentCipherInputStream;

public class AttachmentUtil {
    private static final Logger LOG = Logger.getLogger(AttachmentUtil.class.getName());
    private static final ExecutorService executorService = Executors.newFixedThreadPool(4);
    private static final ExecutorService ioService = Executors.newFixedThreadPool(4);
    private static final Map<AttachmentKey, Long> encryptedSizeMap = new HashMap<AttachmentKey, Long>();
    static final Random random = new Random();

    public static void storeAttachmentFromRecord(AttachmentRecord record, EquationAPI wave) throws IOException {
        LOG.info("Store attachment for " + record.location());
        Path destination = Path.of(record.location() + ".enc.dl", new String[0]);
        Path parent = destination.getParent();
        Files.createDirectories(parent, new FileAttribute[0]);
        LOG.info("Created parent: " + String.valueOf(parent));
        Files.createFile(destination, new FileAttribute[0]);
        executorService.execute(() -> {
            try {
                String uri = "https://cdn" + record.cdnNumber() + ".signal.org/attachments/" + record.cdnKey().getV3();
                AttachmentUtil.downloadUriToPath(uri, Path.of(record.location() + ".enc", new String[0]), record.key(), wave);
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
        });
    }

    public static void storeAttachmentBackup(String uri, Path destination) throws IOException {
        Path parent = destination.getParent();
        Files.createDirectories(parent, new FileAttribute[0]);
        LOG.info("Created parent: " + String.valueOf(parent));
        Files.delete(destination);
        try {
            AttachmentUtil.downloadUriToPath(uri, destination, null, null);
        }
        catch (InterruptedException | URISyntaxException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public static Attachment createAttachmentFromPointer(SignalServiceAttachmentPointer pointer, Path destinationDir) {
        String contentType = pointer.getContentType();
        String extension = AttachmentUtil.getExtension(contentType);
        String rnd = "r" + random.nextInt(Integer.MAX_VALUE);
        String fname = "att" + System.currentTimeMillis() + "_" + rnd + extension;
        Path tf2 = destinationDir.resolve(fname);
        Object realName = fname;
        if (pointer.getFileName().isPresent()) {
            realName = pointer.getFileName().get();
        }
        Attachment attachment = new Attachment(tf2, (String)realName);
        attachment.setVoiceNote(pointer.getVoiceNote());
        attachment.setContentType(contentType);
        return attachment;
    }

    private static void downloadUriToPath(String uri, Path output, AttachmentKey key, EquationAPI api) throws URISyntaxException, IOException, InterruptedException {
        LOG.info("Download " + uri);
        HttpRequest.Builder builder = HttpRequest.newBuilder(new URI(uri));
        HttpRequest request = builder.build();
        HttpResponse<InputStream> response = HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.ofInputStream());
        Optional<String> cl = response.headers().firstValue("content-length");
        LOG.info("Got content-length header: " + String.valueOf(cl));
        Long encSize = Long.valueOf(cl.get());
        if (api != null) {
            api.updateAttachtmentEncryptedSize(key, encSize.intValue());
        }
        encryptedSizeMap.put(key, encSize);
        LOG.info("Added size " + encSize + " to map");
        InputStream is = response.body();
        Path tmpOutput = Path.of(output.toString() + ".dl", new String[0]);
        Path tmpLockPath = Path.of(output.toString() + ".dl.lock", new String[0]);
        Files.createFile(tmpLockPath, new FileAttribute[0]);
        FileOutputStream fos = new FileOutputStream(tmpOutput.toFile());
        byte[] b = new byte[4096];
        int totSize = 0;
        int len = is.read(b);
        while (len > -1) {
            totSize += len;
            fos.write(b, 0, len);
            len = is.read(b);
        }
        fos.close();
        Files.copy(tmpOutput, output, new CopyOption[0]);
        Files.delete(tmpLockPath);
        LOG.info("Done downloading URI");
    }

    public static SignalServiceAttachmentStream createAttachmentStream(Attachment att, NetworkAPI api) throws IOException {
        String contentType;
        Path p = att.getPath();
        String string = contentType = att.getContentType() != null ? att.getContentType() : Files.probeContentType(p);
        if (contentType == null) {
            contentType = "application/octet-stream";
        }
        InputStream inputStream = Files.newInputStream(p, new OpenOption[0]);
        int av = inputStream.available();
        ResumableUploadSpec resumableUploadSpec = api.getAttachmentNetworkClient().getResumableUploadSpec();
        SignalServiceAttachment.Builder builder = SignalServiceAttachment.newStreamBuilder().withStream(inputStream).withContentType(contentType).withLength(av).withFileName(att.getName()).withVoiceNote(att.isVoiceNote()).withResumableUploadSpec(resumableUploadSpec).withUploadTimestamp(System.currentTimeMillis());
        SignalServiceAttachmentStream stream = builder.build();
        return stream;
    }

    public static String getExtension(String contentType) {
        Object answer = "";
        int slash = contentType.indexOf("/");
        if (slash > 0 && slash < contentType.length() - 2) {
            answer = "." + contentType.substring(slash + 1);
        }
        LOG.fine("extension asked for " + contentType + ", return " + (String)answer);
        return answer;
    }

    public static void deleteDownloadingFiles(File dir) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    AttachmentUtil.deleteDownloadingFiles(file);
                    continue;
                }
                if (!file.getName().endsWith(".enc.dl")) continue;
                if (file.delete()) {
                    LOG.info("Deleted: " + file.getAbsolutePath());
                    continue;
                }
                LOG.warning("Failed to delete: " + file.getAbsolutePath());
            }
        }
    }

    public static InputStream getInputStream(AttachmentRecord record) throws IOException {
        AttachmentKey key = record.key();
        String location = record.location();
        LOG.info("Need to get attachmentstream for " + String.valueOf(key) + " from location " + location);
        int plainSize = record.size();
        Object encLocation = null;
        boolean dynamic = false;
        if (location.endsWith(".enc")) {
            encLocation = location;
        } else if (Files.exists(Path.of(location + ".enc", new String[0]), new LinkOption[0])) {
            encLocation = location + ".enc";
        } else if (Files.exists(Path.of(location + ".enc.dl", new String[0]), new LinkOption[0])) {
            encLocation = location + ".enc.dl";
            dynamic = true;
        }
        if (encLocation != null) {
            LOG.info("Attachment is stored encrypted, still downloading? " + dynamic);
            try {
                PipedInputStream is = new PipedInputStream();
                PipedOutputStream os = new PipedOutputStream(is);
                boolean fDynamic = dynamic;
                Object fEncLocation = encLocation;
                ioService.submit(() -> AttachmentUtil.lambda$getInputStream$1(fDynamic, key, record, plainSize, (String)fEncLocation, os));
                return is;
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, null, ex);
                throw new IOException(ex);
            }
        }
        LOG.info("Attachment is not stored encrypted");
        try {
            FileInputStream answer = new FileInputStream(location);
            return answer;
        }
        catch (FileNotFoundException ex) {
            LOG.log(Level.SEVERE, "Could not find unencrypted file at " + location, ex);
            throw new IOException(ex);
        }
    }

    public static InputStream getAvailableInputStream(InputStream inputStream) throws IOException, TimeoutException {
        int len = inputStream.available();
        LOG.info("Initial len = " + len);
        long elapsed = 0L;
        long s0 = System.currentTimeMillis();
        int sleep = 2;
        while (len == 0 && elapsed < 60000L) {
            len = inputStream.available();
            try {
                LOG.info("len = " + len + ", sleep = " + sleep);
                Thread.sleep(sleep);
            }
            catch (InterruptedException ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
            elapsed = System.currentTimeMillis() - s0;
            sleep *= 2;
        }
        if (len == 0) {
            LOG.severe("Can not get image, continue");
            throw new TimeoutException("InputStream is empty after " + elapsed);
        }
        LOG.info("Got it!");
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ void lambda$getInputStream$1(boolean fDynamic, AttachmentKey key, AttachmentRecord record, int plainSize, String fEncLocation, PipedOutputStream os) {
        try {
            InputStream ris;
            if (fDynamic) {
                InputStream dis = null;
                try {
                    Long encryptedSize = encryptedSizeMap.get(key);
                    if (encryptedSize == null) {
                        LOG.severe("We don't have a size yet!");
                        if (record.encryptedSize() > 0) {
                            encryptedSize = record.encryptedSize();
                            LOG.info("We have that on the record: " + encryptedSize);
                        } else {
                            encryptedSize = (long)((double)plainSize * 1.2);
                            LOG.info("Also didn't exist on the record");
                        }
                    }
                    dis = new DynamicInputStream(fEncLocation, encryptedSize);
                    ris = AttachmentCipherInputStream.createForAttachment((InputStream)dis, (long)encryptedSize, (int)record.size(), (long)record.size(), (byte[])record.remoteKey());
                }
                catch (IOException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                    return;
                }
                finally {
                    try {
                        dis.close();
                    }
                    catch (IOException ex) {
                        LOG.log(Level.SEVERE, null, ex);
                    }
                }
            }
            ris = new BufferedInputStream(AttachmentCipherInputStream.createForAttachment((File)new File(fEncLocation), (long)record.size(), (byte[])record.remoteKey(), (byte[])record.digest()));
            LOG.info("Start reading decryptedstream, ris = " + String.valueOf(ris));
            byte[] buff = new byte[8192];
            int totread = 0;
            int len = ris.read(buff);
            while (len > -1) {
                LOG.finest("ris did read " + len + " bytes, total = " + (totread += len));
                os.write(buff, 0, len);
                len = ris.read(buff);
            }
            os.flush();
            os.close();
            LOG.info("Done reading decryptedStream");
        }
        catch (IOException ex) {
            Logger.getLogger(AttachmentUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InvalidMessageException ex) {
            Logger.getLogger(AttachmentUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static class DynamicInputStream
    extends InputStream {
        private final RandomAccessFile file;
        private long position;
        private final Path lockFile;
        private final long totalExcpectedBytes;

        public DynamicInputStream(String filename, long totalExpectedBytes) throws IOException {
            this.file = new RandomAccessFile(filename, "r");
            this.lockFile = Path.of(filename + ".lock", new String[0]);
            this.position = 0L;
            this.totalExcpectedBytes = totalExpectedBytes;
        }

        @Override
        public int read() throws IOException {
            if (this.position >= this.totalExcpectedBytes) {
                return -1;
            }
            while (true) {
                this.file.seek(this.position);
                int read = this.file.read();
                if (read != -1) {
                    ++this.position;
                    return read;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                    return -1;
                }
            }
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.position >= this.totalExcpectedBytes) {
                return -1;
            }
            while (true) {
                this.file.seek(this.position);
                int read = this.file.read(b, off, len);
                if (read > -1) {
                    this.position += (long)read;
                    return read;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                    return -1;
                }
            }
        }
    }
}

