/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.snl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WebsocketResponse {
    private final int status;
    private final String body;
    private final Map<String, String> headers;
    private final boolean unidentified;

    public WebsocketResponse(int status, String body, List<String> headers, boolean unidentified) {
        this.status = status;
        this.body = body;
        this.headers = WebsocketResponse.parseHeaders(headers);
        this.unidentified = unidentified;
    }

    public int getStatus() {
        return this.status;
    }

    public String getBody() {
        return this.body;
    }

    public String getHeader(String key) {
        return this.headers.get(key.toLowerCase());
    }

    public boolean isUnidentified() {
        return this.unidentified;
    }

    private static Map<String, String> parseHeaders(List<String> rawHeaders) {
        HashMap<String, String> headers = new HashMap<String, String>(rawHeaders.size());
        for (String raw : rawHeaders) {
            int colonIndex;
            if (raw == null || raw.length() <= 0 || (colonIndex = raw.indexOf(":")) <= 0 || colonIndex >= raw.length() - 1) continue;
            String key = raw.substring(0, colonIndex).trim().toLowerCase();
            String value = raw.substring(colonIndex + 1).trim();
            headers.put(key, value);
        }
        return headers;
    }
}

