/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.snl;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.luminis.quic.QuicClientConnection;
import net.luminis.quic.QuicClientConnectionImpl;
import net.luminis.quic.QuicStream;
import net.luminis.quic.Version;

public class QuicClientTransport {
    static final String S_PROTOCOL = "swave";
    static final String P_PROTOCOL = "pwave";
    final String address;
    private static final Logger LOG = Logger.getLogger(QuicClientTransport.class.getName());
    private final URI uri;
    private QuicClientConnectionImpl swaveConnection;
    final Object connectionLock = new Object();
    static AtomicInteger ai = new AtomicInteger(0);
    final int internalId;
    private boolean askedToStop = false;
    static final long TIMEOUT = 30000L;

    public QuicClientTransport(URI uri) {
        this.uri = uri;
        this.address = uri.toASCIIString();
        this.internalId = ai.getAndIncrement();
        LOG.info("Created KwikSender[" + this.internalId + "] to " + uri.getHost());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect() throws IOException {
        LOG.info("Sender[" + this.internalId + "] tries to connect to quic endpoint");
        QuicClientConnection.Builder builder = QuicClientConnection.newBuilder();
        builder.version(Version.QUIC_version_1);
        builder.uri(this.uri);
        builder.noServerCertificateCheck();
        this.swaveConnection = builder.build();
        LOG.info("Created connection, now connect");
        this.swaveConnection.connect(1000, S_PROTOCOL);
        LOG.info("Connected, notify waiters");
        Object object = this.connectionLock;
        synchronized (object) {
            this.connectionLock.notifyAll();
        }
        LOG.info("Done connecting");
    }

    public ControlledQuicStream openControlledStream(String baseUrl, Map<String, String> headerMap, Consumer<byte[]> callback) throws IOException {
        try {
            return this.openQuicWebSocket(baseUrl, headerMap, callback);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private ControlledQuicStream openQuicWebSocket(String baseUrl, Map<String, String> headerMap, Consumer<byte[]> callback) throws URISyntaxException, IOException {
        ControlledQuicStream answer = new ControlledQuicStream(this, this.address, baseUrl, headerMap, callback);
        answer.recreateQuicWebSocket();
        return answer;
    }

    public void writeMessageToStream(ControlledQuicStream ks, byte[] payload) throws IOException {
        LOG.info("Write message to quicStream, ks = " + String.valueOf(ks) + " and payloadsize = " + payload.length);
        QuicStream stream = ks.quicStream;
        stream.getOutputStream().write(QuicClientTransport.intToBytes4(payload.length));
        stream.getOutputStream().write(payload);
        stream.getOutputStream().flush();
        LOG.info("Wrote message to quicStream, ks = " + String.valueOf(ks) + " and payloadsize = " + payload.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void blockUntilConnected() {
        while (this.swaveConnection == null || !this.swaveConnection.isConnected()) {
            if (this.askedToStop) {
                LOG.info("We are asked to stop trying to connect.");
                break;
            }
            try {
                Thread connect = new Thread("Connect"){

                    @Override
                    public void run() {
                        try {
                            QuicClientTransport.this.connect();
                        }
                        catch (IOException ex) {
                            LOG.warning("We couldn't connect to " + String.valueOf(QuicClientTransport.this.uri) + " for KwikSender[" + QuicClientTransport.this.internalId + "] but keep trying");
                        }
                    }
                };
                connect.start();
                Object object = this.connectionLock;
                synchronized (object) {
                    this.connectionLock.wait(10000L);
                }
            }
            catch (InterruptedException ex) {
                Logger.getLogger(QuicClientTransport.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public byte[] sendMessage(byte[] message) {
        while (!this.askedToStop) {
            try {
                return this.doSendMessage(message);
            }
            catch (IOException e) {
                LOG.warning("Problem while sending message. Wait 5 seconds and retry");
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                }
            }
        }
        return new byte[0];
    }

    private byte[] doSendMessage(byte[] message) throws IOException {
        if (this.swaveConnection == null || !this.swaveConnection.isConnected()) {
            LOG.info("We are not connected. We block until we are.");
            this.blockUntilConnected();
        }
        if (this.askedToStop) {
            LOG.info("We are asked to stop, gracefully exit by sending an empty byte[]");
            return new byte[0];
        }
        QuicStream stream = this.swaveConnection.createStream(true);
        LOG.info("Ready to send a message over a new Stream: " + String.valueOf(stream) + " using connection " + this.internalId);
        OutputStream outputStream = stream.getOutputStream();
        LOG.finer("OS = " + String.valueOf(outputStream));
        InputStream inputStream = stream.getInputStream();
        LOG.finer("IS = " + String.valueOf(inputStream));
        LOG.finer("Writing " + message.length + " bytes");
        outputStream.write(message);
        outputStream.flush();
        outputStream.close();
        LOG.finer("Done writing bytes");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buff = new byte[4096];
        int len = inputStream.read(buff);
        LOG.info("Start reading, got " + len + " bytes");
        while (len > -1) {
            baos.write(buff, 0, len);
            len = inputStream.read(buff);
            LOG.finer("Continue reading, got " + len + " bytes");
        }
        byte[] answer = baos.toByteArray();
        LOG.info("GOT result, #bytes = " + answer.length);
        return answer;
    }

    public void stop() {
        this.askedToStop = true;
    }

    static byte[] intToBytes4(int v) {
        return ByteBuffer.allocate(4).putInt(v).array();
    }

    public static String safeUrl(String url) {
        int idx;
        String answer = url;
        if (url != null && (idx = url.indexOf("login=")) > 1) {
            answer = url.substring(0, idx + 5);
        }
        return answer;
    }

    public static class ControlledQuicStream {
        final String address;
        final String baseUrl;
        final Map<String, String> headerMap;
        final Consumer<byte[]> callback;
        public QuicStream quicStream;
        private QuicClientConnectionImpl quicConnection;
        long lastStarted = 0L;

        private ControlledQuicStream(QuicClientTransport kwikSender, String address, String baseUrl, Map<String, String> headerMap, Consumer<byte[]> callback) {
            this.address = address;
            this.baseUrl = baseUrl;
            this.headerMap = headerMap;
            this.callback = callback;
            LOG.info("KwikStream created to " + address);
        }

        private void restart() {
            Thread t = new Thread(){

                @Override
                public void run() {
                    boolean succeeded = false;
                    while (!succeeded) {
                        try {
                            long delta = System.currentTimeMillis() - lastStarted;
                            LOG.info("Restarting quicsocket, last started was " + (String)(lastStarted == 0L ? "first start" : "last start was " + delta));
                            if (delta < 10000L) {
                                LOG.info("Last try was less than 10 seconds ago, wait 10 seconds");
                                Thread.sleep(10000L);
                            }
                            this.ensureNetwork();
                            lastStarted = System.currentTimeMillis();
                            this.recreateQuicWebSocket();
                            succeeded = true;
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                }
            };
            t.start();
        }

        private void ensureNetwork() {
            boolean ok = false;
            while (!ok) {
                try {
                    if (this.hasNetwork()) {
                        return;
                    }
                    LOG.info("Waiting for network before we try to restart quicwebsocket");
                    Thread.sleep(5000L);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }

        private void recreateQuicWebSocket() throws URISyntaxException, IOException {
            if (this.quicConnection != null) {
                LOG.info("We have to recreate a quicWS, first close existing connection");
                this.quicConnection.close();
            } else {
                LOG.info("Creating a quicConnection for the first time on this KwikStream");
            }
            QuicClientConnection.Builder builder = QuicClientConnection.newBuilder();
            builder.version(Version.QUIC_version_1);
            builder.uri(new URI(this.address));
            builder.noServerCertificateCheck();
            this.quicConnection = builder.build();
            this.quicConnection.connect(1000, QuicClientTransport.P_PROTOCOL);
            LOG.info("successful connection to " + String.valueOf(this.quicConnection) + ": " + this.quicConnection.isConnected());
            QuicStream stream = this.quicConnection.createStream(true);
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            BufferedOutputStream bos = new BufferedOutputStream(baos);
            LOG.info("Will Write " + QuicClientTransport.safeUrl(this.baseUrl) + " and " + this.headerMap.size() + " entries to connection " + String.valueOf(this.quicConnection));
            byte[] baseUrlBytes = this.baseUrl.getBytes(StandardCharsets.UTF_8);
            bos.write(ByteBuffer.allocate(4).putInt(baseUrlBytes.length).array());
            bos.write(baseUrlBytes);
            bos.write(ByteBuffer.allocate(4).putInt(this.headerMap.size()).array());
            for (Map.Entry<String, String> entry : this.headerMap.entrySet()) {
                byte[] keyBytes = entry.getKey().getBytes(StandardCharsets.UTF_8);
                byte[] valueBytes = entry.getValue().getBytes(StandardCharsets.UTF_8);
                bos.write(ByteBuffer.allocate(4).putInt(keyBytes.length).array());
                bos.write(keyBytes);
                bos.write(ByteBuffer.allocate(4).putInt(valueBytes.length).array());
                bos.write(valueBytes);
            }
            bos.flush();
            baos.flush();
            byte[] toSend = baos.toByteArray();
            OutputStream osStream = stream.getOutputStream();
            osStream.write(toSend);
            osStream.flush();
            LOG.info("DID Write " + toSend.length + " bytes with baseUrl = " + QuicClientTransport.safeUrl(this.baseUrl) + " and " + this.headerMap.size() + " entries to connection " + String.valueOf(this.quicConnection));
            this.readIncomingMessages(stream);
            this.startServerPing(this.quicConnection);
            this.quicStream = stream;
        }

        void startServerPing(final QuicClientConnectionImpl con) {
            con.keepAlive(15);
            LOG.info("SET KEEPALIVE TO 15 for " + String.valueOf(con) + " which is connected? " + con.isConnected());
            Thread t = new Thread(this){
                final /* synthetic */ ControlledQuicStream this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    boolean activeOne = true;
                    int cnt = 0;
                    while (activeOne) {
                        if (con != this.this$0.quicConnection) {
                            LOG.info("We have a new connection, don't ping old one anymore");
                            activeOne = false;
                            continue;
                        }
                        LOG.finest("do we? PING[" + cnt + "] " + String.valueOf(con) + ", last packet received = " + con.getLastPacketReceived());
                        long lastAck = con.getLastPacketReceived();
                        if (System.currentTimeMillis() - lastAck > 30000L) {
                            LOG.info("Seems we lost connection. Really invoke close.");
                            activeOne = false;
                            con.close();
                        }
                        if (cnt++ % 20 == 0) {
                            LOG.info("PING " + String.valueOf(con) + ", last packet received = " + con.getLastPacketReceived());
                            con.ping();
                        }
                        if (!con.isConnected()) {
                            LOG.info("NOT CONNECTED, close so that we can restart");
                            con.close();
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(QuicClientTransport.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                }
            };
            t.start();
        }

        void readIncomingMessages(final QuicStream stream) {
            Thread t = new Thread(this){
                final /* synthetic */ ControlledQuicStream this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    try {
                        InputStream inputStream = stream.getInputStream();
                        while (true) {
                            byte[] rawLen = inputStream.readNBytes(4);
                            int len = (rawLen[0] & 0xFF) << 24 | (rawLen[1] & 0xFF) << 16 | (rawLen[2] & 0xFF) << 8 | rawLen[3] & 0xFF;
                            LOG.info("Got bytes from ws, len = ");
                            byte[] raw = inputStream.readNBytes(len);
                            this.this$0.callback.accept(raw);
                        }
                    }
                    catch (Throwable t) {
                        LOG.info("Major issue ");
                        this.this$0.restart();
                        t.printStackTrace();
                        return;
                    }
                }
            };
            t.start();
        }

        public boolean hasNetwork() {
            InetAddress inetAddress = null;
            try {
                inetAddress = InetAddress.getByName("www.google.com");
            }
            catch (UnknownHostException ex) {
                return false;
            }
            try {
                if (inetAddress == null) {
                    inetAddress = InetAddress.getByName("www.google.com");
                }
                Socket s = new Socket(inetAddress, 443);
                boolean answer = s.isConnected();
                s.close();
                return answer;
            }
            catch (Throwable t) {
                inetAddress = null;
                return false;
            }
        }
    }
}

