/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.snl;

import com.gluonhq.snl.NetworkClient;
import com.gluonhq.snl.Response;
import com.gluonhq.snl.ResponseBody;
import com.gluonhq.snl.doubt.MultipartBody;
import com.gluonhq.snl.doubt.MultipartBodyPublisher;
import io.privacyresearch.equation.attachment.PushAttachmentData;
import io.privacyresearch.equation.attachment.SignalServiceAttachment;
import io.privacyresearch.equation.attachment.SignalServiceAttachmentPointer;
import io.privacyresearch.equation.attachment.SignalServiceAttachmentRemoteId;
import io.privacyresearch.equation.attachment.SignalServiceAttachmentStream;
import io.privacyresearch.equation.internal.KeyUtil;
import io.privacyresearch.equation.model.json.AttachmentUploadForm;
import io.privacyresearch.equation.model.json.AttachmentV2UploadAttributes;
import io.privacyresearch.equation.net.AttachmentCipherOutputStreamFactory;
import io.privacyresearch.equation.net.CancelationSignal;
import io.privacyresearch.equation.net.DigestingRequestBody;
import io.privacyresearch.equation.net.NetworkAPI;
import io.privacyresearch.equation.net.NetworkConfiguration;
import io.privacyresearch.equation.net.OutputStreamFactory;
import io.privacyresearch.equation.net.PaddingInputStream;
import io.privacyresearch.equation.net.ResumableUploadSpec;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpRequest;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.signal.libsignal.protocol.util.Pair;
import org.whispersystems.signalservice.api.crypto.AttachmentCipherOutputStream;
import org.whispersystems.signalservice.api.crypto.AttachmentDigest;
import org.whispersystems.signalservice.api.push.exceptions.MalformedResponseException;
import org.whispersystems.signalservice.api.push.exceptions.NonSuccessfulResponseCodeException;
import org.whispersystems.signalservice.api.push.exceptions.PushNetworkException;
import org.whispersystems.signalservice.api.push.exceptions.ResumeLocationInvalidException;

public class AttachmentNetworkClient {
    private final NetworkAPI networkAPI;
    private final NetworkClient client;
    private static final String ATTACHMENT_UPLOAD_PATH = "attachments/";
    private static final long CDN2_RESUMABLE_LINK_LIFETIME_MILLIS = TimeUnit.DAYS.toMillis(7L);
    private static final Logger LOG = Logger.getLogger(AttachmentNetworkClient.class.getName());
    private final NetworkConfiguration config;

    public AttachmentNetworkClient(NetworkAPI api, NetworkClient client, NetworkConfiguration config) {
        this.networkAPI = api;
        this.client = client;
        this.config = config;
    }

    public SignalServiceAttachmentPointer uploadAttachment(SignalServiceAttachmentStream attachment) throws IOException {
        byte[] attachmentKey = attachment.getResumableUploadSpec().map(ResumableUploadSpec::getSecretKey).orElse(KeyUtil.getSecretBytes(64));
        byte[] attachmentIV = attachment.getResumableUploadSpec().map(ResumableUploadSpec::getIV).orElse(KeyUtil.getSecretBytes(16));
        long paddedLength = PaddingInputStream.getPaddedSize(attachment.getLength());
        PaddingInputStream dataStream = new PaddingInputStream(attachment.getInputStream(), attachment.getLength());
        long ciphertextLength = AttachmentCipherOutputStream.getCiphertextLength((long)paddedLength);
        PushAttachmentData attachmentData = new PushAttachmentData(attachment.getContentType(), dataStream, ciphertextLength, attachment.isFaststart(), new AttachmentCipherOutputStreamFactory(attachmentKey, attachmentIV), attachment.getListener(), null, attachment.getResumableUploadSpec().orElse(null));
        if (attachment.getResumableUploadSpec().isPresent()) {
            return this.uploadAttachmentV4(attachment, attachmentKey, attachmentData);
        }
        return this.uploadAttachmentV2(attachment, attachmentKey, attachmentData);
    }

    private SignalServiceAttachmentPointer uploadAttachmentV2(SignalServiceAttachmentStream attachment, byte[] attachmentKey, PushAttachmentData attachmentData) throws NonSuccessfulResponseCodeException, IOException, MalformedResponseException {
        AttachmentV2UploadAttributes v2UploadAttributes = null;
        if (v2UploadAttributes == null) {
            LOG.info("Not using pipe to retrieve attachment upload attributes...");
            v2UploadAttributes = this.networkAPI.getAttachmentV2UploadAttributes();
        }
        Pair<Long, AttachmentDigest> attachmentIdAndDigest = this.uploadAttachmentV2(attachmentData, v2UploadAttributes);
        return new SignalServiceAttachmentPointer(0, new SignalServiceAttachmentRemoteId((Long)attachmentIdAndDigest.first()), attachment.getContentType(), attachmentKey, Optional.of(Math.toIntExact(attachment.getLength())), attachment.getPreview(), attachment.getWidth(), attachment.getHeight(), Optional.of(((AttachmentDigest)attachmentIdAndDigest.second()).digest()), ((AttachmentDigest)attachmentIdAndDigest.second()).incrementalDigest(), ((AttachmentDigest)attachmentIdAndDigest.second()).incrementalMacChunkSize(), attachment.getFileName(), attachment.getVoiceNote(), attachment.isBorderless(), attachment.isGif(), attachment.getCaption(), attachment.getBlurHash(), attachment.getUploadTimestamp());
    }

    private SignalServiceAttachmentPointer uploadAttachmentV4(SignalServiceAttachmentStream attachment, byte[] attachmentKey, PushAttachmentData attachmentData) throws IOException {
        AttachmentDigest digest = this.uploadAttachment(attachmentData);
        return new SignalServiceAttachmentPointer(attachmentData.getResumableUploadSpec().getCdnNumber(), new SignalServiceAttachmentRemoteId(attachmentData.getResumableUploadSpec().getCdnKey()), attachment.getContentType(), attachmentKey, Optional.of(Math.toIntExact(attachment.getLength())), attachment.getPreview(), attachment.getWidth(), attachment.getHeight(), Optional.of(digest.digest()), digest.incrementalDigest(), digest.incrementalDigest().isPresent() ? digest.incrementalMacChunkSize() : 0, attachment.getFileName(), attachment.getVoiceNote(), attachment.isBorderless(), attachment.isGif(), attachment.getCaption(), attachment.getBlurHash(), attachment.getUploadTimestamp());
    }

    public AttachmentDigest uploadAttachment(PushAttachmentData attachment) throws IOException {
        if (attachment.getResumableUploadSpec() == null || attachment.getResumableUploadSpec().getExpirationTimestamp() < System.currentTimeMillis()) {
            throw new ResumeLocationInvalidException();
        }
        if (attachment.getResumableUploadSpec().getCdnNumber() == 2) {
            return this.uploadToCdn2(attachment.getResumableUploadSpec().getResumeLocation(), attachment.getData(), "application/octet-stream", attachment.getDataSize(), attachment.getOutputStreamFactory(), attachment.getListener(), attachment.getCancelationSignal());
        }
        return this.uploadToCdn3(attachment.getResumableUploadSpec().getResumeLocation(), attachment.getData(), "application/offset+octet-stream", attachment.getDataSize(), attachment.getIncremental(), attachment.getOutputStreamFactory(), attachment.getListener(), attachment.getCancelationSignal(), attachment.getResumableUploadSpec().getHeaders());
    }

    public Pair<Long, AttachmentDigest> uploadAttachmentV2(PushAttachmentData attachment, AttachmentV2UploadAttributes uploadAttributes) throws PushNetworkException, NonSuccessfulResponseCodeException {
        long id = Long.parseLong(uploadAttributes.getAttachmentId());
        AttachmentDigest digest = this.uploadToCdn0(ATTACHMENT_UPLOAD_PATH, uploadAttributes.getAcl(), uploadAttributes.getKey(), uploadAttributes.getPolicy(), uploadAttributes.getAlgorithm(), uploadAttributes.getCredential(), uploadAttributes.getDate(), uploadAttributes.getSignature(), attachment.getData(), "application/octet-stream", attachment.getDataSize(), attachment.getIncremental(), attachment.getOutputStreamFactory(), attachment.getListener(), attachment.getCancelationSignal());
        return new Pair((Object)id, (Object)digest);
    }

    private AttachmentDigest uploadToCdn0(String path, String acl, String key, String policy, String algorithm, String credential, String date, String signature, InputStream data, String contentType, long length, boolean incremental, OutputStreamFactory outputStreamFactory, SignalServiceAttachment.ProgressListener progressListener, CancelationSignal cancelationSignal) throws PushNetworkException, NonSuccessfulResponseCodeException {
        NetworkConfiguration.ConnectionHolder connectionHolder = this.config.getCdnHolder(0);
        DigestingRequestBody file = new DigestingRequestBody(data, outputStreamFactory, contentType, length, incremental, progressListener, cancelationSignal, 0L);
        MultipartBody.MultiPartRequestBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("acl", acl).addFormDataPart("key", key).addFormDataPart("policy", policy).addFormDataPart("Content-Type", contentType).addFormDataPart("x-amz-algorithm", algorithm).addFormDataPart("x-amz-credential", credential).addFormDataPart("x-amz-date", date).addFormDataPart("x-amz-signature", signature).addFormDataPart("file", "file", file).build();
        MultipartBodyPublisher mbp = requestBody.getBodyPublisher();
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(URI.create(String.valueOf(connectionHolder.getEndpointUri()) + "/" + path)).header("Content-Type", requestBody.contentType().getMediaType()).POST(mbp);
        if (connectionHolder.getHostHeader().isPresent()) {
            requestBuilder.header("Host", connectionHolder.getHostHeader().get());
        }
        HttpRequest request = requestBuilder.build();
        try {
            this.client.sendRequest(request, mbp.getRawData());
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new PushNetworkException((Exception)ex);
        }
        return file.getAttachmentDigest();
    }

    public AttachmentDigest uploadToCdn2(String resumableUrl, InputStream data, String contentType, long length, OutputStreamFactory outputStreamFactory, SignalServiceAttachment.ProgressListener progressListener, CancelationSignal cancelationSignal) throws IOException {
        ResumeInfo resumeInfo = this.getResumeInfoCdn2(resumableUrl, length);
        DigestingRequestBody file = new DigestingRequestBody(data, outputStreamFactory, contentType, length, false, progressListener, cancelationSignal, resumeInfo.contentStart);
        byte[] raw = file.getRawBytes();
        if (resumeInfo.contentStart == length) {
            LOG.warning("Resume start point == content length");
            return file.getAttachmentDigest();
        }
        String path = resumableUrl;
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(URI.create(path)).method("PUT", HttpRequest.BodyPublishers.ofByteArray(raw)).header("Content-Range", String.valueOf(resumeInfo.contentRange));
        HttpRequest request = requestBuilder.build();
        Response sendRequest = this.client.sendRequest(request, raw);
        LOG.info("Response from upload to cdn = " + sendRequest.getStatusCode());
        return file.getAttachmentDigest();
    }

    private AttachmentDigest uploadToCdn3(String resumableUrl, InputStream data, String contentType, long length, boolean incremental, OutputStreamFactory outputStreamFactory, SignalServiceAttachment.ProgressListener progressListener, CancelationSignal cancelationSignal, Map<String, String> headers) throws IOException {
        NetworkConfiguration.ConnectionHolder connectionHolder = this.config.getCdnHolder(3);
        ResumeInfo resumeInfo = this.getResumeInfoCdn3(resumableUrl, headers);
        DigestingRequestBody file = new DigestingRequestBody(data, outputStreamFactory, contentType, length, incremental, progressListener, cancelationSignal, resumeInfo.contentStart);
        byte[] raw = file.getRawBytes();
        if (resumeInfo.contentStart == length) {
            LOG.info("Resume start point == content length");
            return file.getAttachmentDigest();
        }
        if (resumeInfo.contentStart != 0L) {
            LOG.warning("Resuming previous attachment upload");
        }
        String path = resumableUrl;
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(URI.create(path)).method("PATCH", HttpRequest.BodyPublishers.ofByteArray(raw)).header("Upload-Offset", String.valueOf(resumeInfo.contentStart)).header("Upload-Length", String.valueOf(length)).header("Tus-Resumable", "1.0.0");
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            requestBuilder.header(entry.getKey(), entry.getValue());
        }
        if (connectionHolder.getHostHeader().isPresent()) {
            requestBuilder.header("Host", connectionHolder.getHostHeader().get());
        }
        HttpRequest request = requestBuilder.build();
        try {
            Response sendRequest = this.client.sendRequest(request, raw);
            LOG.info("Response from upload to cdn = " + sendRequest.getStatusCode());
            return file.getAttachmentDigest();
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new PushNetworkException((Exception)ex);
        }
    }

    private String getResumableUploadUrl(int cdn, String signedUrl, Map<String, String> headers) throws IOException {
        try {
            LOG.info("Get resumable upload url asked for cdn = " + cdn);
            NetworkConfiguration.ConnectionHolder connectionHolder = this.config.getCdnHolder(cdn);
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(AttachmentNetworkClient.buildConfiguredUrl(connectionHolder, signedUrl)).POST(HttpRequest.BodyPublishers.ofString(""));
            for (Map.Entry<String, String> header : headers.entrySet()) {
                if (header.getKey().equalsIgnoreCase("host")) continue;
                requestBuilder.header(header.getKey(), header.getValue());
            }
            if (connectionHolder.getHostHeader().isPresent()) {
                requestBuilder.header("host", connectionHolder.getHostHeader().get());
            }
            if (cdn == 2) {
                requestBuilder.header("Content-Type", "application/octet-stream");
            } else if (cdn == 3) {
                requestBuilder.header("Upload-Defer-Length", "1").header("Tus-Resumable", "1.0.0");
            } else {
                throw new AssertionError((Object)("Unknown CDN version: " + cdn));
            }
            Response response = this.client.sendRequest(requestBuilder.build(), null);
            return response.header("location");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ResumableUploadSpec getResumableUploadSpec(AttachmentUploadForm uploadAttributes) throws IOException {
        LOG.info("ResumableUploadSpec asked for AttachmentUploadForm");
        return new ResumableUploadSpec(KeyUtil.getSecretBytes(64), KeyUtil.getSecretBytes(16), uploadAttributes.getKey(), uploadAttributes.getCdn(), this.getResumableUploadUrl(uploadAttributes.getCdn(), uploadAttributes.getSignedUploadLocation(), uploadAttributes.getHeaders()), System.currentTimeMillis() + CDN2_RESUMABLE_LINK_LIFETIME_MILLIS, uploadAttributes.getHeaders());
    }

    public ResumableUploadSpec getResumableUploadSpec() throws IOException {
        AttachmentUploadForm v4UploadAttributes = null;
        LOG.info("Trying to get v4UploadAttributes");
        v4UploadAttributes = this.networkAPI.getAttachmentV4UploadAttributes();
        LOG.info("Trying to get ResumableUploadSpec based on " + String.valueOf(v4UploadAttributes));
        return this.getResumableUploadSpec(v4UploadAttributes);
    }

    private ResumeInfo getResumeInfoCdn2(String resumableUrl, long contentLength) throws IOException {
        try {
            String contentRange;
            long offset;
            NetworkConfiguration.ConnectionHolder connectionHolder = this.config.getCdnHolder(2);
            LOG.info("Get address for holder " + String.valueOf(connectionHolder));
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(AttachmentNetworkClient.buildConfiguredUrl(connectionHolder, resumableUrl)).PUT(HttpRequest.BodyPublishers.noBody()).header("Content-Range", String.format(Locale.US, "bytes */%d", contentLength));
            if (connectionHolder.getHostHeader().isPresent()) {
                requestBuilder.header("host", connectionHolder.getHostHeader().get());
            }
            HttpRequest request = requestBuilder.build();
            Response response = this.client.sendRequest(request, null);
            int statusCode = response.getStatusCode();
            LOG.info("Responsecode = " + statusCode);
            if (response.isSuccessful()) {
                LOG.info("RESPONSE = " + String.valueOf(response));
                offset = contentLength;
                contentRange = null;
            } else if (statusCode == 308) {
                String rangeCompleted = response.header("Range");
                offset = rangeCompleted == null ? 0L : Long.parseLong(rangeCompleted.split("-")[1]) + 1L;
                contentRange = String.format(Locale.US, "bytes %d-%d/%d", offset, contentLength - 1L, contentLength);
            } else {
                if (statusCode >= 400 || statusCode < 500) {
                    throw new ResumeLocationInvalidException("Response: " + String.valueOf(response));
                }
                throw new IOException("Response: " + String.valueOf(response));
            }
            return new ResumeInfo(this, contentRange, offset);
        }
        catch (URISyntaxException ex) {
            LOG.log(Level.SEVERE, null, ex);
            return new ResumeInfo(this, null, 0L);
        }
    }

    private ResumeInfo getResumeInfoCdn3(String resumableUrl, Map<String, String> headers) throws IOException {
        try {
            NetworkConfiguration.ConnectionHolder connectionHolder = this.config.getCdnHolder(3);
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(AttachmentNetworkClient.buildConfiguredUrl(connectionHolder, resumableUrl)).HEAD().header("Tus-Resumable", "1.0.0");
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                requestBuilder.header(entry.getKey(), entry.getValue());
            }
            if (connectionHolder.getHostHeader().isPresent()) {
                requestBuilder.header("host", connectionHolder.getHostHeader().get());
            }
            HttpRequest request = requestBuilder.build();
            Response response = this.client.sendRequest(request, null);
            int statusCode = response.getStatusCode();
            if (!response.isSuccessful()) {
                if (statusCode >= 400 || statusCode < 500) {
                    throw new ResumeLocationInvalidException("Response: " + String.valueOf(response));
                }
                throw new IOException("Response: " + String.valueOf(response));
            }
            long offset = Long.parseLong(response.header("Upload-Offset"));
            return new ResumeInfo(this, null, offset);
        }
        catch (URISyntaxException ex) {
            LOG.log(Level.SEVERE, null, ex);
            return new ResumeInfo(this, null, 0L);
        }
    }

    public void retrieveProfileAvatar(String path, File destination) throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(destination, true);){
            this.downloadFromCdn(outputStream, 0, path, Map.of());
        }
    }

    public void downloadFromCdn(OutputStream outputStream, int cdnNumber, String path, Map<String, String> headers) throws PushNetworkException, NonSuccessfulResponseCodeException {
        NetworkConfiguration.ConnectionHolder connectionHolder = this.config.getCdnHolder(cdnNumber);
        String reqUri = String.valueOf(connectionHolder.getEndpointUri()) + "/" + path;
        LOG.info("need " + reqUri + " for download from CDN");
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(URI.create(reqUri));
        if (connectionHolder.getHostHeader().isPresent()) {
            requestBuilder.header("Host", connectionHolder.getHostHeader().get());
        }
        HttpRequest request = requestBuilder.build();
        try {
            Response response = this.client.sendRequest(request, new byte[0]);
            LOG.info("Got response: " + response.getStatusCode());
            if (response.isSuccessful()) {
                ResponseBody body = response.body();
                if (body == null) {
                    throw new PushNetworkException("No response body!");
                }
                LOG.info("We got " + body.contentLength() + " from CDN");
                outputStream.write(body.bytes());
            } else if (response.getStatusCode() == 416) {
                throw new IOException();
            }
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
            throw new PushNetworkException(ioe);
        }
    }

    private static URI buildConfiguredUrl(NetworkConfiguration.ConnectionHolder connectionHolder, String url) throws IOException, URISyntaxException {
        URI endpointUri = connectionHolder.getEndpointUri();
        URI resumableUri = URI.create(url);
        String combinedPath = endpointUri.getPath() + resumableUri.getPath();
        URI answer = new URI(endpointUri.getScheme(), endpointUri.getUserInfo(), endpointUri.getHost(), endpointUri.getPort(), combinedPath, resumableUri.getQuery(), resumableUri.getFragment());
        LOG.info("ConfiguredUrl = " + String.valueOf(answer));
        return answer;
    }

    private final class ResumeInfo {
        private final String contentRange;
        private final long contentStart;

        private ResumeInfo(AttachmentNetworkClient attachmentNetworkClient, String contentRange, long offset) {
            this.contentRange = contentRange;
            this.contentStart = offset;
        }
    }
}

