/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata.message;

public enum StoryType {
    NONE(0),
    STORY_WITH_REPLIES(1),
    STORY_WITHOUT_REPLIES(2),
    TEXT_STORY_WITH_REPLIES(3),
    TEXT_STORY_WITHOUT_REPLIES(4);

    private int code;

    private StoryType(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public boolean isStory() {
        return this != NONE;
    }

    public boolean isStoriesWithReplies() {
        return this == STORY_WITH_REPLIES || this == TEXT_STORY_WITH_REPLIES;
    }

    public boolean isTextStory() {
        return this == TEXT_STORY_WITH_REPLIES || this == TEXT_STORY_WITHOUT_REPLIES;
    }

    public StoryType toTextStoryType() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> NONE;
            case 1, 3 -> TEXT_STORY_WITH_REPLIES;
            case 2, 4 -> TEXT_STORY_WITHOUT_REPLIES;
        };
    }

    public static StoryType fromCode(int code) {
        for (StoryType storyType : StoryType.values()) {
            if (storyType.code != code) continue;
            return storyType;
        }
        return NONE;
    }
}

