/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata.message;

import io.privacyresearch.clientdata.DatabaseLayer;
import io.privacyresearch.clientdata.EntityKeyData;
import io.privacyresearch.clientdata.Field;
import io.privacyresearch.clientdata.FieldBuilder;
import io.privacyresearch.clientdata.FieldReference;
import io.privacyresearch.clientdata.FieldType;
import io.privacyresearch.clientdata.message.InfoMessage;
import io.privacyresearch.clientdata.message.InsertInternalMessageRequest;
import io.privacyresearch.clientdata.message.InsertMessageRequest;
import io.privacyresearch.clientdata.message.InternalMessageKey;
import io.privacyresearch.clientdata.message.MessageDbRecord;
import io.privacyresearch.clientdata.message.MessageKey;
import io.privacyresearch.clientdata.message.ReceiptType;
import io.privacyresearch.clientdata.message.StoryType;
import io.privacyresearch.clientdata.recipient.RecipientData;
import io.privacyresearch.clientdata.recipient.RecipientKey;
import io.privacyresearch.clientdata.user.UserData;
import io.privacyresearch.clientdata.user.UserDbRecord;
import io.privacyresearch.clientdata.user.UserKey;
import io.privacyresearch.clientdata.util.BodyRangeUtil;
import java.nio.ByteBuffer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MessageData
extends EntityKeyData<MessageDbRecord, MessageKey> {
    private static final Logger LOG = Logger.getLogger(MessageData.class.getName());
    public static final String TABLE_NAME = "message";
    private final RecipientData recipientData;
    private final UserData userData;

    public MessageData(DatabaseLayer databaseLayer, RecipientData recipientData, UserData userData) {
        super(databaseLayer, TABLE_NAME, List.of(Fields.values()), MessageKey::new);
        this.recipientData = recipientData;
        this.userData = userData;
    }

    @Override
    public void createIndexes() throws SQLException {
        super.createIndexes();
        this.databaseLayer.createIndex(this.getTableName()).withName(String.format("idx_%s_fromRecipientId_dateSent", this.getTableName())).addColumn(Fields.FROM_RECIPIENT_ID).addColumn(Fields.DATE_SENT).execute();
        this.databaseLayer.createIndex(this.getTableName()).withName(String.format("idx_%s_toRecipientId_dateSent", this.getTableName())).addColumn(Fields.TO_RECIPIENT_ID).addColumn(Fields.DATE_SENT).execute();
    }

    @Override
    public MessageDbRecord construct(ResultSet resultSet) throws SQLException {
        Integer originalMessageId;
        Integer fromRecipientId = (Integer)Fields.FROM_RECIPIENT_ID.getValue(resultSet);
        UserDbRecord sender = this.userData.findByRecipientId(fromRecipientId);
        if (sender == null) {
            LOG.severe("No user found for recipientId " + fromRecipientId);
            throw new IllegalArgumentException("Can't create a message without sender");
        }
        UserKey senderKey = sender.key();
        Integer toRecipientId = (Integer)Fields.TO_RECIPIENT_ID.getValue(resultSet);
        RecipientKey receiverKey = null;
        if (toRecipientId != null) {
            receiverKey = (RecipientKey)this.recipientData.getKeyById(toRecipientId);
        }
        ReceiptType receiptType = ReceiptType.valueOf((Integer)Fields.RECEIPT_STATUS.getValue(resultSet));
        int infoMessageType = (Integer)Fields.INFO_MESSAGE_TYPE.getValue(resultSet);
        InfoMessage infoMessage = null;
        if (infoMessageType > 0) {
            String[] args = InfoMessage.parseArgs((String)Fields.INFO_MESSAGE_ARGS.getValue(resultSet));
            InfoMessage.Type type = InfoMessage.Type.from(infoMessageType);
            infoMessage = new InfoMessage(type, args);
        }
        MessageKey originalMessageKey = (originalMessageId = (Integer)Fields.ORIGINAL_MESSAGE_ID.getValue(resultSet)) == null ? null : (MessageKey)this.getKeyById(originalMessageId);
        Integer threadRootId = (Integer)Fields.THREAD_ROOT_ID.getValue(resultSet);
        MessageKey threadRootKey = threadRootId == null ? null : (MessageKey)this.getKeyById(threadRootId);
        byte[] parentPath = (byte[])Fields.PARENT_PATH.getValue(resultSet);
        List<MessageKey> parentKeys = parentPath == null ? null : this.parentPathToMessageKeyList(parentPath);
        return new MessageDbRecord(new MessageKey((byte[])Fields.ENTITY_KEY.getValue(resultSet)), (String)Fields.BODY.getValue(resultSet), BodyRangeUtil.rawToBodyRanges((String)Fields.BODY_RANGES.getValue(resultSet)), senderKey, receiverKey, (Long)Fields.DATE_SENT.getValue(resultSet), (Long)Fields.DATE_RECEIVED.getValue(resultSet), receiptType, (Long)Fields.RECEIPT_TIMESTAMP.getValue(resultSet), (Integer)Fields.EXPIRES_IN.getValue(resultSet), (Long)Fields.EXPIRE_STARTED.getValue(resultSet), StoryType.fromCode((Integer)Fields.STORY_TYPE.getValue(resultSet)), infoMessage, (Boolean)Fields.READ.getValue(resultSet), (Boolean)Fields.VIEW_ONCE.getValue(resultSet), (Long)Fields.FLAGS.getValue(resultSet), originalMessageKey, parentKeys, threadRootKey);
    }

    public InternalMessageKey insertMessageInternal(InsertInternalMessageRequest request) {
        try {
            MessageKey messageKey = new MessageKey();
            Map<Field, Object> values = this.generateInsertValues(messageKey, request);
            List<Integer> inserted = this.databaseLayer.insert(this.getTableName()).values(values).returningId().execute();
            if (inserted.size() == 1) {
                return new InternalMessageKey(inserted.get(0), messageKey);
            }
            return null;
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public MessageKey insertMessage(InsertMessageRequest request) {
        try {
            MessageKey messageKey = new MessageKey();
            Map<Field, Object> values = this.generateInsertValues(messageKey, request);
            List<Integer> inserted = this.databaseLayer.insert(this.getTableName()).values(values).execute();
            if (inserted.size() == 1) {
                return messageKey;
            }
            return null;
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public List<MessageKey> insertMessages(List<InsertMessageRequest> requests) {
        ArrayList<MessageKey> messageKeys = new ArrayList<MessageKey>(requests.size());
        List<Map<Field, Object>> bulkValues = requests.stream().map(request -> {
            MessageKey messageKey = new MessageKey();
            messageKeys.add(messageKey);
            return this.generateInsertValues(messageKey, (InsertMessageRequest)request);
        }).toList();
        try {
            List<Integer> inserted = this.databaseLayer.insert(this.getTableName()).bulkValuesRaw(bulkValues).execute();
            if (inserted.size() == requests.size()) {
                return messageKeys;
            }
            return null;
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    private Map<Field, Object> generateInsertValues(MessageKey messageKey, InsertInternalMessageRequest request) {
        try {
            HashMap<Field, Object> values = new HashMap<Field, Object>();
            values.put(Fields.ENTITY_KEY, messageKey.getKey());
            values.put(Fields.BODY, request.getContent());
            values.put(Fields.BODY_RANGES, BodyRangeUtil.bodyRangesToRaw(request.getBodyRanges()));
            values.put(Fields.DATE_SENT, request.getTimestamp());
            values.put(Fields.DATE_RECEIVED, request.getReceivedTimestamp());
            values.put(Fields.FROM_RECIPIENT_ID, request.getSenderRecipientId());
            values.put(Fields.TO_RECIPIENT_ID, request.getReceiverRecipientId());
            values.put(Fields.EXPIRES_IN, request.getExpiration());
            values.put(Fields.EXPIRE_STARTED, request.getExpireTimestamp());
            values.put(Fields.VIEW_ONCE, request.isViewOnce());
            if (request.getInfoMessage() != null) {
                values.put(Fields.INFO_MESSAGE_TYPE, request.getInfoMessage().type().val());
                values.put(Fields.INFO_MESSAGE_ARGS, InfoMessage.combineArgs(request.getInfoMessage().args()));
            }
            if (request.getOriginalMessageKey() != null) {
                values.put(Fields.ORIGINAL_MESSAGE_ID, this.getIdByKey(request.getOriginalMessageKey()));
            }
            if (request.getThreadRootKey() != null) {
                values.put(Fields.THREAD_ROOT_ID, this.getIdByKey(request.getThreadRootKey()));
            }
            if (request.getParentPath() != null) {
                byte[] parentPath = this.messageKeyListToParentPath(request.getParentPath());
                values.put(Fields.PARENT_PATH, parentPath);
            }
            values.put(Fields.STORY_TYPE, request.getStoryType() == null ? StoryType.NONE.getCode() : request.getStoryType().getCode());
            return values;
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    private Map<Field, Object> generateInsertValues(MessageKey messageKey, InsertMessageRequest request) {
        try {
            UserDbRecord sender = (UserDbRecord)this.userData.findByKey(request.getSenderKey());
            Integer senderRecipientId = sender == null ? null : (Integer)this.recipientData.getIdByKey(sender.recipientKey());
            Integer receiverId = (Integer)this.recipientData.getIdByKey(request.getReceiverKey());
            HashMap<Field, Object> values = new HashMap<Field, Object>();
            values.put(Fields.ENTITY_KEY, messageKey.getKey());
            values.put(Fields.BODY, request.getContent());
            values.put(Fields.BODY_RANGES, BodyRangeUtil.bodyRangesToRaw(request.getBodyRanges()));
            values.put(Fields.DATE_SENT, request.getTimestamp());
            values.put(Fields.DATE_RECEIVED, request.getReceivedTimestamp());
            values.put(Fields.FROM_RECIPIENT_ID, senderRecipientId);
            values.put(Fields.TO_RECIPIENT_ID, receiverId);
            values.put(Fields.EXPIRES_IN, request.getExpiration());
            values.put(Fields.EXPIRE_STARTED, request.getExpireTimestamp());
            values.put(Fields.VIEW_ONCE, request.isViewOnce());
            if (request.getInfoMessage() != null) {
                values.put(Fields.INFO_MESSAGE_TYPE, request.getInfoMessage().type().val());
                values.put(Fields.INFO_MESSAGE_ARGS, InfoMessage.combineArgs(request.getInfoMessage().args()));
            }
            if (request.getThreadRootKey() != null) {
                values.put(Fields.THREAD_ROOT_ID, this.getIdByKey(request.getThreadRootKey()));
            }
            if (request.getOriginalMessageKey() != null) {
                values.put(Fields.ORIGINAL_MESSAGE_ID, this.getIdByKey(request.getOriginalMessageKey()));
            }
            if (request.getParentPath() != null) {
                byte[] parentPath = this.messageKeyListToParentPath(request.getParentPath());
                values.put(Fields.PARENT_PATH, parentPath);
            }
            values.put(Fields.STORY_TYPE, request.getStoryType() == null ? StoryType.NONE.getCode() : request.getStoryType().getCode());
            return values;
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public List<MessageDbRecord> getStories() {
        ArrayList<MessageDbRecord> arrayList;
        block9: {
            ResultSet result = this.databaseLayer.select(this.getFields()).from(this.getTableName()).where(List.of(new DatabaseLayer.BinaryOperandField((Field)Fields.STORY_TYPE, ">", 0))).orderBy(Fields.DATE_SENT, DatabaseLayer.Order.DESC).execute();
            try {
                ArrayList<MessageDbRecord> records = new ArrayList<MessageDbRecord>();
                while (result.next()) {
                    records.add(this.construct(result));
                }
                arrayList = records;
                if (result == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                    throw new IllegalArgumentException(ex);
                }
            }
            result.close();
        }
        return arrayList;
    }

    public List<MessageKey> getExpired() {
        ArrayList<MessageKey> arrayList;
        block9: {
            ResultSet result = this.databaseLayer.select(List.of(Fields.ENTITY_KEY)).from(this.getTableName()).where(List.of(new DatabaseLayer.BinaryOperandField((Field)Fields.EXPIRES_IN, ">", 0), new DatabaseLayer.BinaryOperandField((Field)Fields.EXPIRE_STARTED, ">", 0L), new DatabaseLayer.BinaryOperandField(new DatabaseLayer.BinaryOperandField((DatabaseLayer.OperandField)new DatabaseLayer.BinaryOperandField((Field)Fields.EXPIRES_IN, "*", 1000), "+", (Field)Fields.EXPIRE_STARTED), "<", (Object)System.currentTimeMillis(), FieldType.LONG))).execute();
            try {
                ArrayList<MessageKey> expiredMessageKeys = new ArrayList<MessageKey>();
                while (result.next()) {
                    expiredMessageKeys.add(new MessageKey(result.getBytes(1)));
                }
                arrayList = expiredMessageKeys;
                if (result == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                    throw new IllegalArgumentException(ex);
                }
            }
            result.close();
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MessageDbRecord getNextExpiring() {
        try (ResultSet result = this.databaseLayer.select(this.getFields()).from(this.getTableName()).where(List.of(new DatabaseLayer.BinaryOperandField((Field)Fields.EXPIRES_IN, ">", 0), new DatabaseLayer.BinaryOperandField((Field)Fields.EXPIRE_STARTED, ">", 0L), new DatabaseLayer.BinaryOperandField(new DatabaseLayer.BinaryOperandField((DatabaseLayer.OperandField)new DatabaseLayer.BinaryOperandField((Field)Fields.EXPIRES_IN, "*", 1000), "+", (Field)Fields.EXPIRE_STARTED), ">", (Object)System.currentTimeMillis(), FieldType.LONG))).orderBy(String.format("%s + 1000 * %s", Fields.EXPIRE_STARTED.getColumnName(), Fields.EXPIRES_IN.getColumnName()), DatabaseLayer.Order.ASC).limit(1).execute();){
            if (result.next()) {
                MessageDbRecord messageDbRecord2 = this.construct(result);
                return messageDbRecord2;
            }
            MessageDbRecord messageDbRecord = null;
            return messageDbRecord;
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public List<MessageDbRecord> getByToRecipientKey(RecipientKey toRecipientKey) {
        ArrayList<MessageDbRecord> arrayList;
        block10: {
            Integer toRecipientId = (Integer)this.recipientData.getIdByKey(toRecipientKey);
            if (toRecipientId == null) {
                return new ArrayList<MessageDbRecord>();
            }
            ResultSet result = this.databaseLayer.select(this.getFields()).from(this.getTableName()).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.TO_RECIPIENT_ID, toRecipientId))).execute();
            try {
                ArrayList<MessageDbRecord> records = new ArrayList<MessageDbRecord>();
                while (result.next()) {
                    records.add(this.construct(result));
                }
                arrayList = records;
                if (result == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                    throw new IllegalArgumentException(ex);
                }
            }
            result.close();
        }
        return arrayList;
    }

    public List<MessageDbRecord> getByToRecipientKeyBefore(RecipientKey toRecipientKey, long endTime, int maxItems) {
        ArrayList<MessageDbRecord> arrayList;
        block10: {
            Integer toRecipientId = (Integer)this.recipientData.getIdByKey(toRecipientKey);
            if (toRecipientId == null) {
                return new ArrayList<MessageDbRecord>();
            }
            ResultSet result = this.databaseLayer.select(this.getFields()).from(this.getTableName()).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.TO_RECIPIENT_ID, toRecipientId), new DatabaseLayer.BinaryOperandField((Field)Fields.DATE_SENT, "<", endTime))).orderBy(Fields.DATE_SENT, DatabaseLayer.Order.DESC).limit(maxItems).execute();
            try {
                ArrayList<MessageDbRecord> records = new ArrayList<MessageDbRecord>();
                while (result.next()) {
                    records.add(this.construct(result));
                }
                arrayList = records;
                if (result == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    LOG.log(Level.SEVERE, null, ex);
                    throw new IllegalArgumentException(ex);
                }
            }
            result.close();
        }
        return arrayList;
    }

    public List<MessageDbRecord> getByToRecipientKeyInterval(RecipientKey toRecipientKey, long startTime, long endTime) {
        ArrayList<MessageDbRecord> arrayList;
        block10: {
            Integer toRecipientId = (Integer)this.recipientData.getIdByKey(toRecipientKey);
            if (toRecipientId == null) {
                return new ArrayList<MessageDbRecord>();
            }
            ResultSet result = this.databaseLayer.select(this.getFields()).from(this.getTableName()).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.TO_RECIPIENT_ID, toRecipientId), new DatabaseLayer.BinaryOperandField((Field)Fields.DATE_SENT, ">", startTime), new DatabaseLayer.BinaryOperandField((Field)Fields.DATE_SENT, "<=", endTime))).orderBy(Fields.DATE_SENT, DatabaseLayer.Order.DESC).execute();
            try {
                ArrayList<MessageDbRecord> records = new ArrayList<MessageDbRecord>();
                while (result.next()) {
                    records.add(this.construct(result));
                }
                arrayList = records;
                if (result == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    LOG.log(Level.SEVERE, null, ex);
                    throw new IllegalArgumentException(ex);
                }
            }
            result.close();
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getNumberOfMessagesAfter(RecipientKey toRecipientKey, long time) {
        LOG.info("Get number of messages for receiver recipient with key = " + String.valueOf(toRecipientKey) + ", time = " + time);
        try {
            Integer toRecipientId = (Integer)this.recipientData.getIdByKey(toRecipientKey);
            if (toRecipientId == null) {
                return -1;
            }
            try (ResultSet result = this.databaseLayer.selectRaw(List.of("COUNT(*) AS counter")).from(this.getTableName()).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.INFO_MESSAGE_TYPE, 0), new DatabaseLayer.BinaryOperandField(Fields.TO_RECIPIENT_ID, toRecipientId), new DatabaseLayer.BinaryOperandField((Field)Fields.DATE_SENT, ">", time))).execute();){
                if (result.next()) {
                    LOG.info("Will return " + result.getInt("counter"));
                    int n2 = result.getInt("counter");
                    return n2;
                }
                int n = -1;
                return n;
            }
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MessageDbRecord getByFromRecipientKeyAndDateSent(RecipientKey fromRecipientKey, long dateSent) {
        try {
            Integer fromRecipientId = (Integer)this.recipientData.getIdByKey(fromRecipientKey);
            if (fromRecipientId == null) {
                return null;
            }
            try (ResultSet result = this.databaseLayer.select(this.getFields()).from(this.getTableName()).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.FROM_RECIPIENT_ID, fromRecipientId), new DatabaseLayer.BinaryOperandField(Fields.DATE_SENT, dateSent))).execute();){
                if (result.next()) {
                    MessageDbRecord messageDbRecord2 = this.construct(result);
                    return messageDbRecord2;
                }
                MessageDbRecord messageDbRecord = null;
                return messageDbRecord;
            }
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public void updateReceiptStatusInternal(int messageId, ReceiptType receiptType, long timestamp) {
        LOG.info("Update receipt status for message with id " + messageId + " to type " + String.valueOf((Object)receiptType));
        try {
            HashMap<Field, Object> values = new HashMap<Field, Object>();
            values.put(Fields.RECEIPT_STATUS, receiptType.getV());
            values.put(Fields.RECEIPT_TIMESTAMP, timestamp);
            this.databaseLayer.update(this.getTableName()).values(values).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.ID, messageId))).execute();
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public void updateReceiptStatus(MessageKey messageKey, ReceiptType receiptType, long timestamp) {
        LOG.info("Update receipt status for message with key " + String.valueOf(messageKey) + " to type " + String.valueOf((Object)receiptType));
        try {
            HashMap<Field, Object> values = new HashMap<Field, Object>();
            values.put(Fields.RECEIPT_STATUS, receiptType.getV());
            values.put(Fields.RECEIPT_TIMESTAMP, timestamp);
            this.databaseLayer.update(this.getTableName()).values(values).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.ENTITY_KEY, messageKey.getKey()))).execute();
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public void markRead(MessageKey messageKey, boolean read) {
        LOG.info("Mark message with key " + String.valueOf(messageKey) + " as " + (read ? "read" : "unread"));
        try {
            HashMap<Field, Object> values = new HashMap<Field, Object>();
            values.put(Fields.READ, read);
            this.databaseLayer.update(this.getTableName()).values(values).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.ENTITY_KEY, messageKey.getKey()))).execute();
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public void updateParentPath(MessageKey messageKey, List<MessageKey> parentPath) {
        try {
            HashMap<Field, Object> values = new HashMap<Field, Object>();
            values.put(Fields.PARENT_PATH, this.messageKeyListToParentPath(parentPath));
            this.databaseLayer.update(this.getTableName()).values(values).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.ENTITY_KEY, messageKey.getKey()))).execute();
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public void updateThreadRoot(MessageKey messageKey, MessageKey threadRoot) {
        LOG.info("Update threadroot for message with key " + String.valueOf(messageKey) + " to " + String.valueOf(threadRoot));
        try {
            HashMap<Field, Object> values = new HashMap<Field, Object>();
            values.put(Fields.THREAD_ROOT_ID, this.getIdByKey(threadRoot));
            this.databaseLayer.update(this.getTableName()).values(values).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.ENTITY_KEY, messageKey.getKey()))).execute();
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public void updateExpireStarted(MessageKey messageKey, long expireStarted) {
        LOG.info("Update expireStarted for message with key " + String.valueOf(messageKey) + " to " + expireStarted);
        try {
            HashMap<Field, Object> values = new HashMap<Field, Object>();
            values.put(Fields.EXPIRE_STARTED, expireStarted);
            this.databaseLayer.update(this.getTableName()).values(values).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.ENTITY_KEY, messageKey.getKey()))).execute();
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public boolean updateFlag(MessageKey messageKey, int flag, boolean value) {
        LOG.info("Update flag " + flag + " for message with key " + String.valueOf(messageKey) + " to " + value);
        try {
            boolean oldVal;
            MessageDbRecord oldRecord = (MessageDbRecord)this.findByKey(messageKey);
            long oldFlags = oldRecord.flags();
            boolean bl = oldVal = (oldFlags >> flag & 1L) == 1L;
            if (value == oldVal) {
                LOG.info("Flag is already " + value);
                return false;
            }
            long newVal = oldFlags ^ (long)(1 << flag);
            LOG.info("Old val = " + oldFlags + " and new val = " + newVal);
            HashMap<Field, Object> values = new HashMap<Field, Object>();
            values.put(Fields.FLAGS, newVal);
            this.databaseLayer.update(this.getTableName()).values(values).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.ENTITY_KEY, messageKey.getKey()))).execute();
            return true;
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public void remoteDelete(MessageKey messageKey) {
        if (this.updateFlag(messageKey, 0, true)) {
            HashMap<Field, Object> values = new HashMap<Field, Object>();
            values.put(Fields.BODY, "");
            try {
                this.databaseLayer.update(this.getTableName()).values(values).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.ENTITY_KEY, messageKey.getKey()))).execute();
            }
            catch (SQLException ex) {
                LOG.log(Level.SEVERE, null, ex);
                throw new IllegalArgumentException(ex);
            }
        }
    }

    public void deleteByKey(MessageKey messageKey) {
        try {
            this.databaseLayer.delete(this.getTableName()).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.ENTITY_KEY, messageKey.getKey()))).execute();
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    public void deleteByDateAndDestination(long timestamp, RecipientKey targetRecipient) {
        try {
            Integer receiverId = (Integer)this.recipientData.getIdByKey(targetRecipient);
            this.databaseLayer.delete(this.getTableName()).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.TO_RECIPIENT_ID, receiverId), new DatabaseLayer.BinaryOperandField((Field)Fields.DATE_SENT, "<=", timestamp))).execute();
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    List<MessageKey> parentPathToMessageKeyList(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        ArrayList<MessageKey> answer = new ArrayList<MessageKey>();
        if (bytes.length == 0) {
            return answer;
        }
        ByteBuffer buff = ByteBuffer.wrap(bytes);
        while (buff.remaining() > 0) {
            byte[] chunk = new byte[16];
            buff.get(chunk);
            answer.add(new MessageKey(chunk));
        }
        return answer;
    }

    private byte[] messageKeyListToParentPath(List<MessageKey> parentPath) {
        if (parentPath == null) {
            return null;
        }
        ByteBuffer buff = ByteBuffer.allocate(16 * parentPath.size());
        for (MessageKey key : parentPath) {
            buff.put(key.getKey());
        }
        return buff.array();
    }

    public static enum Fields implements Field
    {
        ID(FieldBuilder.newField("_id", FieldType.INT).withPrimaryKey(true).withAutoincrement(true)),
        ENTITY_KEY(FieldBuilder.newField("entity_key", FieldType.BLOB).withEntityKey(true).withNullable(false).withDefaultValue(0)),
        DATE_SENT(FieldBuilder.newField("date_sent", FieldType.LONG).withNullable(false)),
        DATE_RECEIVED(FieldBuilder.newField("date_received", FieldType.LONG).withNullable(false)),
        BODY(FieldBuilder.newField("body", FieldType.TEXT)),
        BODY_RANGES(FieldBuilder.newField("body_ranges", FieldType.TEXT)),
        READ(FieldBuilder.newField("read", FieldType.BOOLEAN).withDefaultValue(false)),
        VIEW_ONCE(FieldBuilder.newField("view_once", FieldType.BOOLEAN).withDefaultValue(false)),
        FLAGS(FieldBuilder.newField("flags", FieldType.LONG).withDefaultValue(0)),
        RECEIPT_STATUS(FieldBuilder.newField("receipt_status", FieldType.INT).withDefaultValue(0)),
        RECEIPT_TIMESTAMP(FieldBuilder.newField("receipt_timestamp", FieldType.LONG).withDefaultValue(0)),
        EXPIRES_IN(FieldBuilder.newField("expires_in", FieldType.INT).withDefaultValue(0)),
        EXPIRE_STARTED(FieldBuilder.newField("expire_started", FieldType.LONG).withDefaultValue(0)),
        STORY_TYPE(FieldBuilder.newField("story_type", FieldType.INT).withDefaultValue(0)),
        FROM_RECIPIENT_ID(FieldBuilder.newField("from_recipient_id", FieldType.INT).withNullable(false).withReference("recipient", RecipientData.Fields.ID, FieldReference.OnDelete.CASCADE)),
        TO_RECIPIENT_ID(FieldBuilder.newField("to_recipient_id", FieldType.INT).withNullable(false).withReference("recipient", RecipientData.Fields.ID, FieldReference.OnDelete.CASCADE)),
        LATEST_REVISION_ID(FieldBuilder.newField("latest_revision_id", FieldType.INT).withDefaultNull().withReference("message", ID, FieldReference.OnDelete.CASCADE)),
        ORIGINAL_MESSAGE_ID(FieldBuilder.newField("original_message_id", FieldType.INT).withDefaultNull().withReference("message", ID, FieldReference.OnDelete.CASCADE)),
        PARENT_PATH(FieldBuilder.newField("parent_path", FieldType.BLOB)),
        THREAD_ROOT_ID(FieldBuilder.newField("thread_root_id", FieldType.INT).withDefaultNull().withReference("message", ID, FieldReference.OnDelete.CASCADE)),
        INFO_MESSAGE_TYPE(FieldBuilder.newField("info_message_type", FieldType.INT).withDefaultValue(0)),
        INFO_MESSAGE_ARGS(FieldBuilder.newField("info_message_args", FieldType.TEXT));

        public final Field field;

        private Fields(FieldBuilder builder) {
            this.field = builder.build();
        }

        @Override
        public Field getFieldImpl() {
            return this.field;
        }

        @Override
        public String getTableName() {
            return MessageData.TABLE_NAME;
        }
    }
}

