/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata.proxy;

import io.privacyresearch.clientdata.DatabaseLayer;
import io.privacyresearch.clientdata.EntityKeyData;
import io.privacyresearch.clientdata.Field;
import io.privacyresearch.clientdata.FieldBuilder;
import io.privacyresearch.clientdata.FieldType;
import io.privacyresearch.clientdata.proxy.ProxyKey;
import io.privacyresearch.clientdata.proxy.ProxyRecord;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProxyData
extends EntityKeyData<ProxyRecord, ProxyKey> {
    private static final Logger LOG = Logger.getLogger(ProxyData.class.getName());
    public static final String TABLE_NAME = "proxy";

    public ProxyData(DatabaseLayer databaseLayer) {
        super(databaseLayer, TABLE_NAME, List.of(Fields.values()), ProxyKey::new);
    }

    @Override
    public ProxyRecord construct(ResultSet resultSet) throws SQLException {
        return new ProxyRecord(new ProxyKey((byte[])Fields.ENTITY_KEY.getValue(resultSet)), (String)Fields.HOST.getValue(resultSet), (Integer)Fields.PORT.getValue(resultSet), (Long)Fields.VERIFICATION.getValue(resultSet), (Long)Fields.REMOTE_ID.getValue(resultSet));
    }

    public ProxyKey createProxy(ProxyRecord record) {
        if (record.key() != null) {
            throw new IllegalArgumentException("Can not add a proxy that already has a ProxyKey");
        }
        ProxyKey key = new ProxyKey();
        HashMap<Field, Object> values = new HashMap<Field, Object>();
        values.put(Fields.ENTITY_KEY, key.getKey());
        values.put(Fields.HOST, record.host());
        values.put(Fields.PORT, record.port());
        values.put(Fields.VERIFICATION, record.verification());
        values.put(Fields.REMOTE_ID, record.remoteId());
        try {
            List<Integer> inserted = this.databaseLayer.insert(TABLE_NAME).values(values).execute();
            if (inserted.size() == 1) {
                return key;
            }
            return null;
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public boolean deleteByProxyKey(ProxyKey key) {
        try {
            int execute = this.databaseLayer.delete(TABLE_NAME).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.ENTITY_KEY, key.getKey()))).execute();
            return execute == 1;
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            return false;
        }
    }

    public static enum Fields implements Field
    {
        ID(FieldBuilder.newField("_id", FieldType.INT).withPrimaryKey(true).withAutoincrement(true)),
        ENTITY_KEY(FieldBuilder.newField("entity_key", FieldType.BLOB).withEntityKey(true).withNullable(false).withDefaultValue(0)),
        HOST(FieldBuilder.newField("host", FieldType.SHORT_STRING)),
        PORT(FieldBuilder.newField("port", FieldType.INT)),
        VERIFICATION(FieldBuilder.newField("verification", FieldType.LONG)),
        REMOTE_ID(FieldBuilder.newField("remote_id", FieldType.LONG)),
        STATUS(FieldBuilder.newField("status", FieldType.INT)),
        LAST_ACK(FieldBuilder.newField("last_ack", FieldType.LONG)),
        LAST_USED(FieldBuilder.newField("last_used", FieldType.LONG)),
        REMOTE_QUALITY(FieldBuilder.newField("remote_quality", FieldType.LONG)),
        LOCAL_QUALITY(FieldBuilder.newField("local_quality", FieldType.LONG));

        public final Field field;

        private Fields(FieldBuilder builder) {
            this.field = builder.build();
        }

        @Override
        public Field getFieldImpl() {
            return this.field;
        }
    }
}

