/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata.canvas;

import io.privacyresearch.clientdata.DatabaseLayer;
import io.privacyresearch.clientdata.EntityKeyData;
import io.privacyresearch.clientdata.Field;
import io.privacyresearch.clientdata.FieldBuilder;
import io.privacyresearch.clientdata.FieldReference;
import io.privacyresearch.clientdata.FieldType;
import io.privacyresearch.clientdata.canvas.CanvasData;
import io.privacyresearch.clientdata.canvas.CanvasDbRecord;
import io.privacyresearch.clientdata.canvas.CanvasEntryDbRecord;
import io.privacyresearch.clientdata.canvas.CanvasEntryKey;
import io.privacyresearch.clientdata.canvas.CanvasKey;
import io.privacyresearch.clientdata.canvas.InsertCanvasEntryRequest;
import io.privacyresearch.clientdata.message.BodyRange;
import io.privacyresearch.clientdata.recipient.RecipientData;
import io.privacyresearch.clientdata.recipient.RecipientKey;
import io.privacyresearch.clientdata.user.UserData;
import io.privacyresearch.clientdata.user.UserDbRecord;
import io.privacyresearch.clientdata.user.UserKey;
import io.privacyresearch.clientdata.util.BodyRangeUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CanvasEntryData
extends EntityKeyData<CanvasEntryDbRecord, CanvasEntryKey> {
    private static final Logger LOG = Logger.getLogger(CanvasEntryData.class.getName());
    public static final String TABLE_NAME = "canvas_entry";
    private final CanvasData canvasData;
    private final RecipientData recipientData;
    private final UserData userData;

    public CanvasEntryData(DatabaseLayer databaseLayer, CanvasData canvasData, RecipientData recipientData, UserData userData) {
        super(databaseLayer, TABLE_NAME, List.of(Fields.values()), CanvasEntryKey::new);
        this.canvasData = canvasData;
        this.recipientData = recipientData;
        this.userData = userData;
    }

    @Override
    public CanvasEntryDbRecord construct(ResultSet resultSet) throws SQLException {
        CanvasKey canvasKey = (CanvasKey)this.canvasData.getKeyById(Fields.CANVAS_ID.getValue(resultSet));
        Integer authorRecipientId = (Integer)Fields.AUTHOR_RECIPIENT_ID.getValue(resultSet);
        UserDbRecord author = this.userData.findByRecipientId(authorRecipientId);
        if (author == null) {
            LOG.severe("No user found for recipientId " + authorRecipientId);
            throw new IllegalArgumentException("Can't create a canvas entry without author");
        }
        UserKey authorKey = author.key();
        return new CanvasEntryDbRecord(new CanvasEntryKey((byte[])Fields.ENTITY_KEY.getValue(resultSet)), canvasKey, (String)Fields.TITLE.getValue(resultSet), (String)Fields.BODY.getValue(resultSet), BodyRangeUtil.rawToBodyRanges((String)Fields.BODY_RANGES.getValue(resultSet)), authorKey, (Long)Fields.DATE_MODIFIED.getValue(resultSet), (Long)Fields.VERSION.getValue(resultSet));
    }

    public CanvasEntryKey insertCanvasEntry(InsertCanvasEntryRequest request) {
        try {
            CanvasDbRecord canvas = (CanvasDbRecord)this.canvasData.findByKey(request.canvasKey());
            if (canvas == null) {
                throw new IllegalStateException("A canvas with key " + String.valueOf(request.canvasKey()) + " should exist!");
            }
            return this.doInsertCanvasEntry(request.canvasKey(), request.authorRecipientKey(), request.title(), request.body(), request.bodyRanges(), request.version());
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public List<CanvasEntryDbRecord> getByCanvas(CanvasKey canvasKey, int limit) {
        ArrayList<CanvasEntryDbRecord> arrayList;
        block10: {
            Integer canvasId = (Integer)this.canvasData.getIdByKey(canvasKey);
            if (canvasId == null) {
                return new ArrayList<CanvasEntryDbRecord>();
            }
            ResultSet result = this.databaseLayer.select(this.getFields()).from(this.getTableName()).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.CANVAS_ID, canvasId))).orderBy(Fields.VERSION, DatabaseLayer.Order.DESC).limit(limit).execute();
            try {
                ArrayList<CanvasEntryDbRecord> records = new ArrayList<CanvasEntryDbRecord>();
                while (result.next()) {
                    records.add(this.construct(result));
                }
                arrayList = records;
                if (result == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                    throw new IllegalArgumentException(ex);
                }
            }
            result.close();
        }
        return arrayList;
    }

    private CanvasEntryKey doInsertCanvasEntry(CanvasKey canvasKey, RecipientKey authorRecipientKey, String title, String body, List<BodyRange> bodyRanges, long version) throws SQLException {
        Integer canvasId = (Integer)this.canvasData.getIdByKey(canvasKey);
        if (canvasId == null) {
            throw new IllegalStateException("A canvas with key " + String.valueOf(canvasKey) + " should exist!");
        }
        Integer authorRecipientId = (Integer)this.recipientData.getIdByKey(authorRecipientKey);
        if (authorRecipientId == null) {
            throw new IllegalStateException("A recipient with key " + String.valueOf(authorRecipientKey) + " should exist!");
        }
        CanvasEntryKey canvasEntryKey = new CanvasEntryKey();
        Map<Field, Object> values = Map.ofEntries(Map.entry(Fields.ENTITY_KEY, canvasEntryKey.getKey()), Map.entry(Fields.CANVAS_ID, canvasId), Map.entry(Fields.AUTHOR_RECIPIENT_ID, authorRecipientId), Map.entry(Fields.TITLE, title), Map.entry(Fields.BODY, body), Map.entry(Fields.BODY_RANGES, BodyRangeUtil.bodyRangesToRaw(bodyRanges)), Map.entry(Fields.DATE_MODIFIED, System.currentTimeMillis()), Map.entry(Fields.VERSION, version));
        List<Integer> inserted = this.databaseLayer.insert(this.getTableName()).values(values).execute();
        if (inserted.size() == 1) {
            return canvasEntryKey;
        }
        return null;
    }

    public static enum Fields implements Field
    {
        ID(FieldBuilder.newField("_id", FieldType.INT).withPrimaryKey(true).withAutoincrement(true)),
        ENTITY_KEY(FieldBuilder.newField("entity_key", FieldType.BLOB).withEntityKey(true).withNullable(false).withDefaultValue(0)),
        CANVAS_ID(FieldBuilder.newField("canvas_id", FieldType.INT).withNullable(false).withReference("canvas", CanvasData.Fields.ID, FieldReference.OnDelete.CASCADE)),
        DATE_MODIFIED(FieldBuilder.newField("date_modified", FieldType.LONG).withNullable(false)),
        TITLE(FieldBuilder.newField("title", FieldType.TEXT)),
        BODY(FieldBuilder.newField("body", FieldType.TEXT)),
        BODY_RANGES(FieldBuilder.newField("body_ranges", FieldType.TEXT)),
        AUTHOR_RECIPIENT_ID(FieldBuilder.newField("author_recipient_id", FieldType.INT).withNullable(false).withReference("recipient", RecipientData.Fields.ID, FieldReference.OnDelete.CASCADE)),
        VERSION(FieldBuilder.newField("version", FieldType.LONG).withDefaultValue(0));

        public final Field field;

        private Fields(FieldBuilder builder) {
            this.field = builder.build();
        }

        @Override
        public Field getFieldImpl() {
            return this.field;
        }

        @Override
        public String getTableName() {
            return CanvasEntryData.TABLE_NAME;
        }
    }
}

