/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata.canvas;

import io.privacyresearch.clientdata.DatabaseLayer;
import io.privacyresearch.clientdata.EntityKeyData;
import io.privacyresearch.clientdata.Field;
import io.privacyresearch.clientdata.FieldBuilder;
import io.privacyresearch.clientdata.FieldReference;
import io.privacyresearch.clientdata.FieldType;
import io.privacyresearch.clientdata.canvas.CanvasDbRecord;
import io.privacyresearch.clientdata.canvas.CanvasEntryData;
import io.privacyresearch.clientdata.canvas.CanvasEntryDbRecord;
import io.privacyresearch.clientdata.canvas.CanvasKey;
import io.privacyresearch.clientdata.canvas.CreateCanvasRequest;
import io.privacyresearch.clientdata.channel.ChannelData;
import io.privacyresearch.clientdata.channel.ChannelKey;
import io.privacyresearch.clientdata.recipient.RecipientData;
import io.privacyresearch.clientdata.recipient.RecipientKey;
import io.privacyresearch.clientdata.user.UserData;
import io.privacyresearch.clientdata.user.UserDbRecord;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CanvasData
extends EntityKeyData<CanvasDbRecord, CanvasKey> {
    private static final Logger LOG = Logger.getLogger(CanvasData.class.getName());
    public static final String TABLE_NAME = "canvas";
    private final ChannelData channelData;
    private final CanvasEntryData canvasEntryData;
    private final RecipientData recipientData;
    private final UserData userData;

    public CanvasData(DatabaseLayer databaseLayer, ChannelData channelData, RecipientData recipientData, UserData userData) {
        super(databaseLayer, TABLE_NAME, List.of(Fields.values()), CanvasKey::new);
        this.channelData = channelData;
        this.recipientData = recipientData;
        this.userData = userData;
        this.canvasEntryData = new CanvasEntryData(databaseLayer, this, recipientData, userData);
    }

    public CanvasEntryData getCanvasEntryData() {
        return this.canvasEntryData;
    }

    @Override
    public CanvasDbRecord construct(ResultSet resultSet) throws SQLException {
        ChannelKey channelKey = (ChannelKey)this.channelData.getKeyById(Fields.CHANNEL_ID.getValue(resultSet));
        CanvasKey canvasKey = new CanvasKey((byte[])Fields.ENTITY_KEY.getValue(resultSet));
        List<CanvasEntryDbRecord> latestEntries = this.canvasEntryData.getByCanvas(canvasKey, 1);
        Integer lockedByRecipientId = (Integer)Fields.LOCKED_BY_RECIPIENT_ID.getValue(resultSet);
        UserDbRecord lockedBy = null;
        if (lockedByRecipientId != 0) {
            lockedBy = this.userData.findByRecipientId(lockedByRecipientId);
        }
        return new CanvasDbRecord(canvasKey, (String)Fields.UUID.getValue(resultSet), channelKey, latestEntries.isEmpty() ? null : latestEntries.get(0), (Long)Fields.LOCKED_SINCE.getValue(resultSet), lockedBy == null ? null : lockedBy.key());
    }

    public CanvasKey createCanvas(CreateCanvasRequest request) {
        if (request.channelKey() == null) {
            throw new IllegalArgumentException("ChannelKey not provided");
        }
        try {
            Integer channelId = (Integer)this.channelData.getIdByKey(request.channelKey());
            if (channelId == null) {
                throw new IllegalStateException("A channel with key " + String.valueOf(request.channelKey()) + " should exist!");
            }
            CanvasKey canvasKey = new CanvasKey();
            Map<Field, Object> values = Map.ofEntries(Map.entry(Fields.ENTITY_KEY, canvasKey.getKey()), Map.entry(Fields.CHANNEL_ID, channelId), Map.entry(Fields.UUID, request.identifier()));
            List<Integer> inserted = this.databaseLayer.insert(this.getTableName()).values(values).execute();
            if (inserted.size() == 1) {
                return canvasKey;
            }
            return null;
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public List<CanvasDbRecord> getByChannel(ChannelKey channelKey) {
        ArrayList<CanvasDbRecord> arrayList;
        block10: {
            Integer channelId = (Integer)this.channelData.getIdByKey(channelKey);
            if (channelId == null) {
                return new ArrayList<CanvasDbRecord>();
            }
            ResultSet result = this.databaseLayer.select(this.getFields()).from(this.getTableName()).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.CHANNEL_ID, channelId))).execute();
            try {
                ArrayList<CanvasDbRecord> records = new ArrayList<CanvasDbRecord>();
                while (result.next()) {
                    records.add(this.construct(result));
                }
                arrayList = records;
                if (result == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                    throw new IllegalArgumentException(ex);
                }
            }
            result.close();
        }
        return arrayList;
    }

    public void lockCanvas(CanvasKey canvasKey, RecipientKey lockedByRecipientKey) {
        try {
            Integer canvasId = (Integer)this.getIdByKey(canvasKey);
            if (canvasId == null) {
                throw new IllegalStateException("A canvas with key " + String.valueOf(canvasKey) + " should exist!");
            }
            Integer lockedByRecipientId = (Integer)this.recipientData.getIdByKey(lockedByRecipientKey);
            if (lockedByRecipientId == null) {
                throw new IllegalStateException("A recipient with key " + String.valueOf(lockedByRecipientKey) + " should exist!");
            }
            this.updateLockFields(canvasId, System.currentTimeMillis(), lockedByRecipientId);
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public void unlockCanvas(CanvasKey canvasKey) {
        try {
            Integer canvasId = (Integer)this.getIdByKey(canvasKey);
            if (canvasId == null) {
                throw new IllegalStateException("A canvas with key " + String.valueOf(canvasKey) + " should exist!");
            }
            this.updateLockFields(canvasId, 0L, 0);
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    private void updateLockFields(int canvasId, long lockedSince, int lockedByRecipientId) throws SQLException {
        Map<Field, Object> values = Map.ofEntries(Map.entry(Fields.LOCKED_SINCE, lockedSince), Map.entry(Fields.LOCKED_BY_RECIPIENT_ID, lockedByRecipientId));
        this.databaseLayer.update(this.getTableName()).values(values).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.ID, canvasId))).execute();
    }

    public static enum Fields implements Field
    {
        ID(FieldBuilder.newField("_id", FieldType.INT).withPrimaryKey(true).withAutoincrement(true)),
        ENTITY_KEY(FieldBuilder.newField("entity_key", FieldType.BLOB).withEntityKey(true).withNullable(false).withDefaultValue(0)),
        UUID(FieldBuilder.newField("uuid", FieldType.TEXT).withNullable(false)),
        CHANNEL_ID(FieldBuilder.newField("channel_id", FieldType.INT).withNullable(false).withReference("channel", ChannelData.Fields.ID, FieldReference.OnDelete.CASCADE)),
        LOCKED_SINCE(FieldBuilder.newField("locked_since", FieldType.LONG)),
        LOCKED_BY_RECIPIENT_ID(FieldBuilder.newField("locked_by_recipient_id", FieldType.INT).withReference("channel", ChannelData.Fields.ID, FieldReference.OnDelete.CASCADE));

        public final Field field;

        private Fields(FieldBuilder builder) {
            this.field = builder.build();
        }

        @Override
        public Field getFieldImpl() {
            return this.field;
        }

        @Override
        public String getTableName() {
            return CanvasData.TABLE_NAME;
        }
    }
}

