/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata.keys;

import io.privacyresearch.clientdata.DatabaseLayer;
import io.privacyresearch.clientdata.Field;
import io.privacyresearch.clientdata.FieldBuilder;
import io.privacyresearch.clientdata.FieldType;
import io.privacyresearch.clientdata.IdData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.protocol.ServiceId;
import org.signal.libsignal.protocol.ecc.ECKeyPair;
import org.signal.libsignal.protocol.ecc.ECPrivateKey;
import org.signal.libsignal.protocol.ecc.ECPublicKey;
import org.signal.libsignal.protocol.state.PreKeyRecord;
import org.whispersystems.signalservice.api.crypto.Curve;

public class PreKeyData
extends IdData<PreKeyRecord> {
    private static final Logger LOG = Logger.getLogger(PreKeyData.class.getName());
    public static final String TABLE_NAME = "one_time_prekeys";

    public PreKeyData(DatabaseLayer databaseLayer) {
        super(databaseLayer, TABLE_NAME, List.of(Fields.values()));
    }

    @Override
    public PreKeyRecord construct(ResultSet resultSet) throws SQLException {
        try {
            int id = (Integer)Fields.KEY_ID.getValue(resultSet);
            byte[] publicBytes = (byte[])Fields.PUBLIC_KEY.getValue(resultSet);
            byte[] privateBytes = (byte[])Fields.PRIVATE_KEY.getValue(resultSet);
            ECPublicKey publicKey = new ECPublicKey(publicBytes);
            ECPrivateKey privateKey = Curve.decodePrivatePoint((byte[])privateBytes);
            ECKeyPair ecKeyPair = new ECKeyPair(publicKey, privateKey);
            PreKeyRecord answer = new PreKeyRecord(id, ecKeyPair);
            return answer;
        }
        catch (InvalidKeyException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public void add(ServiceId serviceId, PreKeyRecord preKeyRecord) throws SQLException {
        LOG.info("Add a prekey for serviceid " + serviceId.toString());
        try {
            Map<Field, Object> values = Map.ofEntries(Map.entry(Fields.ACCOUNT_ID, serviceId.toString()), Map.entry(Fields.KEY_ID, preKeyRecord.getId()), Map.entry(Fields.PUBLIC_KEY, preKeyRecord.getKeyPair().getPublicKey().serialize()), Map.entry(Fields.PRIVATE_KEY, preKeyRecord.getKeyPair().getPrivateKey().serialize()), Map.entry(Fields.STALE_TIMESTAMP, 1));
            this.databaseLayer.insert(this.getTableName()).values(values).execute();
        }
        catch (SQLException | InvalidKeyException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public PreKeyRecord findById(ServiceId serviceId, int id) {
        try {
            PreKeyRecord answer = (PreKeyRecord)super.findById(id);
            return answer;
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public void deleteByKeyId(int keyId) {
        try {
            List<DatabaseLayer.BinaryOperandField> where = List.of(new DatabaseLayer.BinaryOperandField(Fields.KEY_ID, keyId));
            this.databaseLayer.delete(this.getTableName()).where(where).execute();
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    public static enum Fields implements Field
    {
        ACCOUNT_ID(FieldBuilder.newField("account_id", FieldType.SHORT_STRING)),
        KEY_ID(FieldBuilder.newField("key_id", FieldType.INT).withPrimaryKey(true)),
        PUBLIC_KEY(FieldBuilder.newField("public_key", FieldType.BLOB)),
        PRIVATE_KEY(FieldBuilder.newField("private_key", FieldType.BLOB)),
        STALE_TIMESTAMP(FieldBuilder.newField("stale_timestamp", FieldType.INT));

        public final Field field;

        private Fields(FieldBuilder builder) {
            this.field = builder.build();
        }

        @Override
        public Field getFieldImpl() {
            return this.field;
        }

        @Override
        public String getTableName() {
            return PreKeyData.TABLE_NAME;
        }
    }
}

