/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata.attachment;

import io.privacyresearch.clientdata.attachment.AttachmentKey;
import io.privacyresearch.clientdata.message.MessageKey;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public record AttachmentRecord(AttachmentKey key, MessageKey messageKey, byte[] remoteKey, String contentType, int size, int encryptedSize, byte[] digest, byte[] incrementalMac, int incrementalMacChunkSize, String fileName, int flags, int width, int height, String caption, String blurHash, RemoteId cdnKey, int cdnNumber, long uploadTimestamp, String location) {
    public boolean isVoiceNote() {
        return (this.flags & AttachmentRecord.toBinaryFlag(1)) != 0;
    }

    public boolean isBorderless() {
        return (this.flags & AttachmentRecord.toBinaryFlag(2)) != 0;
    }

    public boolean isGif() {
        return (this.flags & AttachmentRecord.toBinaryFlag(4)) != 0;
    }

    public static int toBinaryFlag(int flag) {
        return 1 << flag - 1;
    }

    public static final class RemoteId {
        private final byte[] cdnKey;

        public RemoteId(byte[] cdnKey) {
            this.cdnKey = cdnKey;
        }

        public boolean isV2() {
            return this.cdnKey.length == 8;
        }

        public boolean isV3() {
            return this.cdnKey.length > 8;
        }

        public long getV2() {
            ByteBuffer buffer = ByteBuffer.allocate(8);
            buffer.put(this.cdnKey);
            buffer.flip();
            return buffer.getLong();
        }

        public String getV3() {
            return new String(this.cdnKey, StandardCharsets.UTF_8);
        }
    }
}

