/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata.keyvalue;

import io.privacyresearch.clientdata.keyvalue.AbstractStorage;
import io.privacyresearch.clientdata.keyvalue.KeyValueData;
import io.privacyresearch.clientdata.keyvalue.Preferences;
import org.whispersystems.signalservice.internal.storage.AccountRecord;

public class PreferenceStorage
extends AbstractStorage {
    private static final String COLLECTION = "preference";
    public static final String KEY_READ_RECEIPTS = "preference.read_receipts";
    public static final String KEY_TYPING_INDICATORS = "preference.typing_indicators";
    public static final String KEY_STORIES_ENABLED = "preference.stories_enabled";

    public PreferenceStorage(KeyValueData keyValueData) {
        super(keyValueData, COLLECTION);
    }

    public Preferences getPreferences() {
        return new Preferences(this.getBoolean(KEY_READ_RECEIPTS, true), this.getBoolean(KEY_TYPING_INDICATORS, true), this.getBoolean(KEY_STORIES_ENABLED, true));
    }

    public void storeAccountRecord(AccountRecord sar) {
        this.putBoolean(KEY_READ_RECEIPTS, sar.getReadReceipts());
        this.putBoolean(KEY_TYPING_INDICATORS, sar.getTypingIndicators());
        this.putBoolean(KEY_STORIES_ENABLED, !sar.getStoriesDisabled());
    }

    public boolean getBoolean(String key, boolean def) {
        String res = this.getString(key, null);
        if (res == null) {
            return def;
        }
        return Boolean.parseBoolean(res);
    }

    public void putBoolean(String key, boolean val) {
        this.putString(key, Boolean.toString(val));
    }
}

