/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata;

import io.privacyresearch.clientdata.Field;
import io.privacyresearch.clientdata.FieldImpl;
import io.privacyresearch.clientdata.FieldReference;
import io.privacyresearch.clientdata.FieldType;
import java.util.HashSet;
import java.util.Set;

public class FieldBuilder {
    private String tableName;
    private String columnName;
    private FieldType type;
    private String defaultValue;
    private boolean includeInCreateTable;
    private FieldReference reference;
    private Set<Field.Flag> flags = new HashSet<Field.Flag>();

    public static FieldBuilder newField(String columnName, FieldType type) {
        return new FieldBuilder().withColumnName(columnName).withIncludeInCreateTable(true).withType(type);
    }

    public FieldBuilder withTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public FieldBuilder withColumnName(String columnName) {
        this.columnName = columnName;
        return this;
    }

    public FieldBuilder withDefaultNull() {
        this.defaultValue = "NULL";
        return this;
    }

    public FieldBuilder withDefaultValue(boolean defaultValue) {
        this.defaultValue = String.valueOf(defaultValue ? 1 : 0);
        return this;
    }

    public FieldBuilder withDefaultValue(int defaultValue) {
        this.defaultValue = String.valueOf(defaultValue);
        return this;
    }

    public FieldBuilder withDefaultValue(String defaultValue) {
        this.defaultValue = "'" + defaultValue + "'";
        return this;
    }

    public FieldBuilder withRawDefaultValue(String rawDefaultValue) {
        this.defaultValue = rawDefaultValue;
        return this;
    }

    public FieldBuilder withAutoincrement(boolean autoincrement) {
        this.updateFlag(Field.Flag.AUTOINCREMENT, autoincrement);
        return this;
    }

    public FieldBuilder withEntityKey(boolean entityKey) {
        this.updateFlag(Field.Flag.ENTITY_KEY, entityKey);
        return this;
    }

    public FieldBuilder withNullable(boolean nullable) {
        this.updateFlag(Field.Flag.NOT_NULL, !nullable);
        return this;
    }

    public FieldBuilder withPrimaryKey(boolean primaryKey) {
        this.updateFlag(Field.Flag.PRIMARY_KEY, primaryKey);
        return this;
    }

    public FieldBuilder withType(FieldType type) {
        this.type = type;
        return this;
    }

    public FieldBuilder withUnique(boolean unique) {
        this.updateFlag(Field.Flag.UNIQUE, unique);
        return this;
    }

    public FieldBuilder withIncludeInCreateTable(boolean includeInCreateTable) {
        this.includeInCreateTable = includeInCreateTable;
        return this;
    }

    public FieldBuilder withReference(String tableName, Field field, FieldReference.OnDelete onDelete) {
        this.reference = new FieldReference(tableName, field, onDelete);
        return this;
    }

    private void updateFlag(Field.Flag flag, boolean set) {
        if (set) {
            this.flags.add(flag);
        } else {
            this.flags.remove((Object)flag);
        }
    }

    public Field build() {
        return new FieldImpl(this.tableName, this.columnName, this.type, this.defaultValue, this.flags, this.includeInCreateTable, this.reference);
    }
}

