/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata.keyvalue;

import io.privacyresearch.clientdata.DatabaseLayer;
import io.privacyresearch.clientdata.Field;
import io.privacyresearch.clientdata.FieldBuilder;
import io.privacyresearch.clientdata.FieldType;
import io.privacyresearch.clientdata.IdData;
import io.privacyresearch.clientdata.keyvalue.KeyValue;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class KeyValueData
extends IdData<KeyValue> {
    public static final String TABLE_NAME = "keyvalue";

    public KeyValueData(DatabaseLayer databaseLayer) {
        super(databaseLayer, TABLE_NAME, List.of(Fields.values()));
    }

    public void add(KeyValue keyValue) throws SQLException {
        List<KeyValue> existing = this.findByKeyAndCollection(keyValue.getKey(), keyValue.getCollection());
        if (existing.isEmpty()) {
            this.databaseLayer.insert(this.getTableName()).values(List.of(new DatabaseLayer.InsertableField(Fields.KEY, keyValue.getKey()), new DatabaseLayer.InsertableField(Fields.COLLECTION, keyValue.getCollection()), new DatabaseLayer.InsertableField(Fields.VALUE, keyValue.getValue()))).execute();
        } else {
            this.databaseLayer.update(this.getTableName()).values(List.of(new DatabaseLayer.InsertableField(Fields.VALUE, keyValue.getValue()))).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.KEY, keyValue.getKey()), new DatabaseLayer.BinaryOperandField(Fields.COLLECTION, keyValue.getCollection()))).execute();
        }
    }

    @Override
    public KeyValue construct(ResultSet resultSet) throws SQLException {
        String key = (String)Fields.KEY.getValue(resultSet);
        String collection = (String)Fields.COLLECTION.getValue(resultSet);
        byte[] value = (byte[])Fields.VALUE.getValue(resultSet);
        return new KeyValue(key, collection, value);
    }

    public List<KeyValue> findByKey(String key) throws SQLException {
        ArrayList<KeyValue> answer = new ArrayList<KeyValue>();
        List<DatabaseLayer.BinaryOperandField> where = List.of(new DatabaseLayer.BinaryOperandField(Fields.KEY, key));
        ResultSet result = this.databaseLayer.select(this.getFields()).from(this.getTableName()).where(where).execute();
        while (result.next()) {
            answer.add(this.construct(result));
        }
        return answer;
    }

    public List<KeyValue> findByKeyAndCollection(String key, String collection) throws SQLException {
        ArrayList<KeyValue> answer = new ArrayList<KeyValue>();
        List<DatabaseLayer.BinaryOperandField> where = List.of(new DatabaseLayer.BinaryOperandField(Fields.KEY, key), new DatabaseLayer.BinaryOperandField(Fields.COLLECTION, collection));
        ResultSet result = this.databaseLayer.select(this.getFields()).from(this.getTableName()).where(where).execute();
        while (result.next()) {
            answer.add(this.construct(result));
        }
        return answer;
    }

    public static enum Fields implements Field
    {
        KEY(FieldBuilder.newField("key", FieldType.SHORT_STRING)),
        COLLECTION(FieldBuilder.newField("collection", FieldType.SHORT_STRING)),
        VALUE(FieldBuilder.newField("value", FieldType.BLOB));

        public final Field field;

        private Fields(FieldBuilder builder) {
            this.field = builder.build();
        }

        @Override
        public Field getFieldImpl() {
            return this.field;
        }

        @Override
        public String getTableName() {
            return KeyValueData.TABLE_NAME;
        }
    }
}

