/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata.group;

import io.privacyresearch.clientdata.DatabaseLayer;
import io.privacyresearch.clientdata.EntityKeyData;
import io.privacyresearch.clientdata.Field;
import io.privacyresearch.clientdata.FieldBuilder;
import io.privacyresearch.clientdata.FieldReference;
import io.privacyresearch.clientdata.FieldType;
import io.privacyresearch.clientdata.channel.ChannelData;
import io.privacyresearch.clientdata.group.GroupInviteLinkUrl;
import io.privacyresearch.clientdata.group.GroupKey;
import io.privacyresearch.clientdata.group.GroupRecord;
import io.privacyresearch.clientdata.group.MembershipData;
import io.privacyresearch.clientdata.group.MembershipRecord;
import io.privacyresearch.clientdata.keyvalue.AccountStorage;
import io.privacyresearch.clientdata.recipient.RecipientData;
import io.privacyresearch.clientdata.recipient.RecipientKey;
import io.privacyresearch.clientdata.recipient.RecipientRecord;
import io.privacyresearch.clientdata.user.UserData;
import io.privacyresearch.clientdata.user.UserDbRecord;
import io.privacyresearch.clientdata.user.UserKey;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.signal.libsignal.protocol.ServiceId;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.groups.GroupIdentifier;
import org.signal.libsignal.zkgroup.groups.GroupMasterKey;
import org.signal.libsignal.zkgroup.groups.GroupSecretParams;
import org.signal.libsignal.zkgroup.profiles.ProfileKey;
import org.signal.storageservice.protos.groups.local.DecryptedGroup;
import org.signal.storageservice.protos.groups.local.DecryptedMember;
import org.thoughtcrime.securesms.backup.v2.proto.Backup;
import org.whispersystems.signalservice.api.groupsv2.DecryptedGroupUtil;
import org.whispersystems.signalservice.api.storage.StorageId;
import org.whispersystems.signalservice.internal.storage.GroupV2Record;

public class GroupData
extends EntityKeyData<GroupRecord, GroupKey> {
    private static final Logger LOG = Logger.getLogger(GroupData.class.getName());
    public static final String TABLE_NAME = "groups";
    private final MembershipData membershipData;
    private final ChannelData channelData;
    private final RecipientData recipientData;
    private final UserData userData;
    private final AccountStorage accountStorage;

    public GroupData(DatabaseLayer databaseLayer, ChannelData channelData, RecipientData recipientData, UserData userData, AccountStorage accountStorage) {
        super(databaseLayer, TABLE_NAME, List.of(Fields.values()), GroupKey::new);
        this.membershipData = new MembershipData(databaseLayer, this, userData);
        this.channelData = channelData;
        this.recipientData = recipientData;
        this.userData = userData;
        this.accountStorage = accountStorage;
    }

    public MembershipData getMembershipData() {
        return this.membershipData;
    }

    @Override
    public void createTable() throws SQLException {
        super.createTable();
        this.membershipData.createTable();
    }

    @Override
    public void createIndexes() throws SQLException {
        super.createIndexes();
        this.membershipData.createIndexes();
    }

    @Override
    public GroupRecord construct(ResultSet resultSet) throws SQLException {
        UUID distributionId = null;
        String rawDistributionId = (String)Fields.DISTRIBUTION_ID.getValue(resultSet);
        if (rawDistributionId != null) {
            distributionId = UUID.fromString(rawDistributionId);
        }
        Integer recipientId = (Integer)Fields.RECIPIENT_ID.getValue(resultSet);
        RecipientRecord recipient = null;
        if (recipientId != null) {
            recipient = (RecipientRecord)this.recipientData.findById(recipientId);
        }
        GroupKey groupKey = new GroupKey((byte[])Fields.ENTITY_KEY.getValue(resultSet));
        Set<MembershipRecord> groupMembers = this.getGroupMembers(groupKey);
        return new GroupRecord(groupKey, recipient, (String)Fields.TITLE.getValue(resultSet), (String)Fields.DESCRIPTION.getValue(resultSet), (Integer)Fields.DISAPPEARING_TIMER.getValue(resultSet), (Boolean)Fields.ACTIVE.getValue(resultSet), (byte[])Fields.MASTER_KEY.getValue(resultSet), (String)Fields.INVITE_LINK_URL.getValue(resultSet), (Integer)Fields.REVISION.getValue(resultSet), distributionId, (Boolean)Fields.WHITELISTED.getValue(resultSet), (Boolean)Fields.ARCHIVED.getValue(resultSet), (Boolean)Fields.MARKED_UNREAD.getValue(resultSet), (Long)Fields.MUTED_UNTIL_TIMESTAMP.getValue(resultSet), (Boolean)Fields.DONT_NOTIFY.getValue(resultSet), (Boolean)Fields.HIDE_STORY.getValue(resultSet), (String)Fields.PROFILE_AVATAR_FILE.getValue(resultSet), groupMembers);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<GroupRecord> getGroupByGroupIdentifier(GroupIdentifier groupIdentifier) {
        try (ResultSet result = this.databaseLayer.select(this.getFields()).from(this.getTableName()).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.GROUP_IDENTIFIER, groupIdentifier.serialize()))).execute();){
            if (result.next()) {
                Optional<GroupRecord> optional2 = Optional.of(this.construct(result));
                return optional2;
            }
            Optional<GroupRecord> optional = Optional.empty();
            return optional;
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GroupRecord getGroupByRecipientKey(RecipientKey groupRecipientKey) {
        try {
            Integer groupRecipientId = (Integer)this.recipientData.getIdByKey(groupRecipientKey);
            if (groupRecipientId == null) {
                return null;
            }
            try (ResultSet result = this.databaseLayer.select(this.getFields()).from(this.getTableName()).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.RECIPIENT_ID, groupRecipientId))).execute();){
                if (result.next()) {
                    GroupRecord groupRecord2 = this.construct(result);
                    return groupRecord2;
                }
                GroupRecord groupRecord = null;
                return groupRecord;
            }
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<GroupRecord> getGroupByMasterKeyBytes(byte[] masterKeyBytes) {
        try (ResultSet result = this.databaseLayer.select(this.getFields()).from(this.getTableName()).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.MASTER_KEY, masterKeyBytes))).execute();){
            if (result.next()) {
                Optional<GroupRecord> optional2 = Optional.of(this.construct(result));
                return optional2;
            }
            Optional<GroupRecord> optional = Optional.empty();
            return optional;
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public GroupKey create(Backup.Group backup) {
        GroupMasterKey masterKey;
        try {
            masterKey = new GroupMasterKey(backup.getMasterKey().toByteArray());
        }
        catch (InvalidInputException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException("Can not create a group with an invalid masterkey");
        }
        GroupSecretParams groupSecretParams = GroupSecretParams.deriveFromMasterKey((GroupMasterKey)masterKey);
        GroupIdentifier groupIdentifier = groupSecretParams.getPublicParams().getGroupIdentifier();
        HashMap<Field, Object> values = new HashMap<Field, Object>(Map.ofEntries(Map.entry(Fields.TITLE, backup.getSnapshot().getTitle().getTitle()), Map.entry(Fields.MASTER_KEY, backup.getMasterKey().toByteArray()), Map.entry(Fields.GROUP_IDENTIFIER, groupIdentifier.serialize()), Map.entry(Fields.WHITELISTED, backup.getWhitelisted()), Map.entry(Fields.HIDE_STORY, backup.getHideStory())));
        return this.createOrUpdate(groupIdentifier, values, null, false);
    }

    public GroupKey createOrUpdate(StorageId storageId, GroupV2Record storageRecord) {
        GroupMasterKey masterKey;
        byte[] mkb = storageRecord.getMasterKey().toByteArray();
        try {
            masterKey = new GroupMasterKey(mkb);
        }
        catch (InvalidInputException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
        GroupSecretParams groupSecretParams = GroupSecretParams.deriveFromMasterKey((GroupMasterKey)masterKey);
        GroupIdentifier groupIdentifier = groupSecretParams.getPublicParams().getGroupIdentifier();
        HashMap<Field, Object> values = new HashMap<Field, Object>(Map.ofEntries(Map.entry(Fields.MASTER_KEY, mkb), Map.entry(Fields.GROUP_IDENTIFIER, groupIdentifier.serialize()), Map.entry(Fields.WHITELISTED, storageRecord.getWhitelisted()), Map.entry(Fields.ARCHIVED, storageRecord.getArchived()), Map.entry(Fields.MARKED_UNREAD, storageRecord.getMarkedUnread()), Map.entry(Fields.MUTED_UNTIL_TIMESTAMP, storageRecord.getMutedUntilTimestamp()), Map.entry(Fields.DONT_NOTIFY, false), Map.entry(Fields.HIDE_STORY, false)));
        return this.createOrUpdate(groupIdentifier, values, storageId.getRaw(), storageRecord.getBlocked());
    }

    private GroupKey createOrUpdate(GroupIdentifier groupIdentifier, Map<Field, Object> values, byte[] storageId, boolean blocked) {
        try {
            Optional<GroupRecord> exists = this.getGroupByGroupIdentifier(groupIdentifier);
            if (exists.isPresent()) {
                this.databaseLayer.update(this.getTableName()).values(values).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.ENTITY_KEY, exists.get().key().getKey()))).execute();
                GroupRecord groupRecord = this.getGroupByGroupIdentifier(groupIdentifier).orElseThrow();
                this.recipientData.updateGroupRecipient(groupRecord.recipient().key(), storageId, RecipientRecord.Type.GV2);
                return exists.get().key();
            }
            GroupKey groupKey = new GroupKey();
            RecipientKey groupRecipientKey = this.recipientData.createGroupRecipient(groupKey, storageId, blocked);
            this.channelData.createForRecipient(groupRecipientKey);
            values.put(Fields.ENTITY_KEY, groupKey.getKey());
            values.put(Fields.RECIPIENT_ID, this.recipientData.getIdByKey(groupRecipientKey));
            values.put(Fields.DISTRIBUTION_ID, UUID.randomUUID().toString());
            this.databaseLayer.insert(this.getTableName()).values(values).execute();
            return groupKey;
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public GroupKey update(GroupMasterKey masterKey, DecryptedGroup groupState) {
        return this.updateWithAvatar(masterKey, groupState, null);
    }

    public GroupKey updateWithAvatar(GroupMasterKey masterKey, DecryptedGroup groupState, String avatarFile) {
        LOG.info("update group named " + groupState.getTitle() + " with avatar " + groupState.getAvatar());
        GroupSecretParams groupSecretParams = GroupSecretParams.deriveFromMasterKey((GroupMasterKey)masterKey);
        GroupIdentifier groupIdentifier = groupSecretParams.getPublicParams().getGroupIdentifier();
        GroupRecord existing = this.getGroupByGroupIdentifier(groupIdentifier).orElseThrow(() -> new IllegalStateException("A group with GroupId " + String.valueOf(groupIdentifier) + " should already exist!"));
        ServiceId.Aci aci = this.accountStorage.requireAci();
        boolean active = DecryptedGroupUtil.findMemberByAci((Collection)groupState.getMembersList(), (ServiceId.Aci)aci).isPresent() || DecryptedGroupUtil.findPendingByServiceId((Collection)groupState.getPendingMembersList(), (ServiceId)aci).isPresent();
        HashMap<Field, Object> values = new HashMap<Field, Object>(Map.ofEntries(Map.entry(Fields.TITLE, groupState.getTitle()), Map.entry(Fields.ACTIVE, active), Map.entry(Fields.REVISION, groupState.getRevision()), Map.entry(Fields.DESCRIPTION, groupState.getDescription()), Map.entry(Fields.PROFILE_AVATAR_URL, groupState.getAvatar()), Map.entry(Fields.MASTER_KEY, masterKey.serialize())));
        if (avatarFile != null) {
            values.put(Fields.PROFILE_AVATAR_FILE, avatarFile);
        }
        if (groupState.getInviteLinkPassword().isEmpty()) {
            values.put(Fields.INVITE_LINK_URL, "");
        } else {
            GroupInviteLinkUrl groupLinkInviteUrl = GroupInviteLinkUrl.forGroup(masterKey, groupState);
            values.put(Fields.INVITE_LINK_URL, groupLinkInviteUrl.getUrl());
        }
        try {
            Integer existingId = (Integer)this.getIdByKey(existing.key());
            this.databaseLayer.update(this.getTableName()).values(values).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.ENTITY_KEY, existing.key().getKey()))).execute();
            this.databaseLayer.delete(this.membershipData.getTableName()).where(List.of(new DatabaseLayer.BinaryOperandField(MembershipData.Fields.GROUP_ID, existingId))).execute();
            List<MembershipRecord> membershipRecords = this.getMembershipRecordsFromDecryptedMembers(existing.key(), groupState.getMembersList());
            if (!membershipRecords.isEmpty()) {
                List<List<DatabaseLayer.InsertableField>> membershipValues = membershipRecords.stream().map(membership -> {
                    try {
                        Integer userId = (Integer)this.userData.getIdByKey(membership.userKey());
                        return List.of(new DatabaseLayer.InsertableField(MembershipData.Fields.GROUP_ID, existingId), new DatabaseLayer.InsertableField(MembershipData.Fields.USER_ID, userId), new DatabaseLayer.InsertableField(MembershipData.Fields.ROLE, membership.role().getNumber()));
                    }
                    catch (SQLException ex) {
                        LOG.log(Level.SEVERE, null, ex);
                        return List.of();
                    }
                }).filter(v -> !v.isEmpty()).collect(Collectors.toList());
                this.databaseLayer.insert(this.membershipData.getTableName()).bulkValues(membershipValues).execute();
            }
            if (groupState.hasDisappearingMessagesTimer()) {
                this.modifyExpirationTime(existing.key(), groupState.getDisappearingMessagesTimer().getDuration());
            }
            return existing.key();
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    private List<MembershipRecord> getMembershipRecordsFromDecryptedMembers(GroupKey groupKey, List<DecryptedMember> decryptedMembers) {
        return decryptedMembers.stream().map(member -> {
            ServiceId.Aci aci = null;
            try {
                aci = ServiceId.Aci.parseFromBinary((byte[])member.getAciBytes().toByteArray());
            }
            catch (ServiceId.InvalidServiceIdException ex) {
                Logger.getLogger(GroupData.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (aci == null) {
                return null;
            }
            UserKey userKey = this.userData.getByAci(aci);
            if (userKey == null) {
                userKey = this.userData.store((ServiceId)aci, null);
                byte[] pkbytes = member.getProfileKey().toByteArray();
                try {
                    this.userData.setProfileKey(userKey, new ProfileKey(pkbytes));
                }
                catch (InvalidInputException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                }
            }
            UserDbRecord user = (UserDbRecord)this.userData.findByKey(userKey);
            return new MembershipRecord(groupKey, user.key(), member.getRole());
        }).filter(membership -> membership != null).sorted(Comparator.comparing(MembershipRecord::userKey)).collect(Collectors.toUnmodifiableList());
    }

    public GroupRecord modifyExpirationTime(GroupKey groupKey, int duration) {
        try {
            GroupRecord group = (GroupRecord)this.findByKey(groupKey);
            this.databaseLayer.update(this.getTableName()).values(Map.of(Fields.DISAPPEARING_TIMER, duration)).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.ENTITY_KEY, groupKey.getKey()))).execute();
            this.recipientData.setExpireMessages(group.recipient().key(), duration);
            return (GroupRecord)this.findByKey(groupKey);
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public GroupRecord updateTitle(GroupKey groupKey, String title) {
        try {
            GroupRecord group = (GroupRecord)this.findByKey(groupKey);
            this.databaseLayer.update(this.getTableName()).values(Map.of(Fields.TITLE, title)).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.ENTITY_KEY, groupKey.getKey()))).execute();
            return (GroupRecord)this.findByKey(groupKey);
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public GroupRecord updateDescription(GroupKey groupKey, String desc) {
        try {
            GroupRecord group = (GroupRecord)this.findByKey(groupKey);
            this.databaseLayer.update(this.getTableName()).values(Map.of(Fields.DESCRIPTION, desc)).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.ENTITY_KEY, groupKey.getKey()))).execute();
            return (GroupRecord)this.findByKey(groupKey);
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public Set<MembershipRecord> getGroupMembers(GroupKey groupKey) {
        return this.membershipData.listByGroup(groupKey);
    }

    public static enum Fields implements Field
    {
        ID(FieldBuilder.newField("_id", FieldType.INT).withPrimaryKey(true).withAutoincrement(true)),
        ENTITY_KEY(FieldBuilder.newField("entity_key", FieldType.BLOB).withEntityKey(true).withNullable(false).withDefaultValue(0)),
        RECIPIENT_ID(FieldBuilder.newField("recipient_id", FieldType.INT).withNullable(false).withUnique(true).withReference("recipient", RecipientData.Fields.ID, FieldReference.OnDelete.CASCADE)),
        TITLE(FieldBuilder.newField("title", FieldType.TEXT).withDefaultNull()),
        TIMESTAMP(FieldBuilder.newField("timestamp", FieldType.LONG).withDefaultValue(0)),
        ACTIVE(FieldBuilder.newField("active", FieldType.BOOLEAN).withDefaultValue(true)),
        DISTRIBUTION_ID(FieldBuilder.newField("distribution_id", FieldType.TEXT).withUnique(true).withDefaultNull()),
        MASTER_KEY(FieldBuilder.newField("master_key", FieldType.BLOB).withDefaultNull()),
        GROUP_IDENTIFIER(FieldBuilder.newField("group_identifier", FieldType.BLOB).withDefaultNull()),
        INVITE_LINK_URL(FieldBuilder.newField("invite_link_url", FieldType.TEXT).withDefaultValue("")),
        REVISION(FieldBuilder.newField("revision", FieldType.INT).withDefaultNull()),
        DESCRIPTION(FieldBuilder.newField("description", FieldType.TEXT).withDefaultNull()),
        DISAPPEARING_TIMER(FieldBuilder.newField("disappearing_timer", FieldType.INT).withDefaultNull()),
        WHITELISTED(FieldBuilder.newField("whitelisted", FieldType.BOOLEAN).withDefaultValue(true)),
        ARCHIVED(FieldBuilder.newField("archived", FieldType.BOOLEAN).withDefaultValue(false)),
        MARKED_UNREAD(FieldBuilder.newField("markedUnread", FieldType.BOOLEAN).withDefaultValue(false)),
        MUTED_UNTIL_TIMESTAMP(FieldBuilder.newField("muted_until_timestamp", FieldType.LONG).withDefaultValue(0)),
        DONT_NOTIFY(FieldBuilder.newField("dontnotify", FieldType.BOOLEAN).withDefaultValue(false)),
        HIDE_STORY(FieldBuilder.newField("hidestory", FieldType.BOOLEAN).withDefaultValue(false)),
        PROFILE_AVATAR_URL(FieldBuilder.newField("profile_avatar_url", FieldType.SHORT_STRING).withDefaultNull()),
        PROFILE_AVATAR_FILE(FieldBuilder.newField("profile_avatar_file", FieldType.SHORT_STRING).withDefaultNull());

        public final Field field;

        private Fields(FieldBuilder builder) {
            this.field = builder.build();
        }

        @Override
        public Field getFieldImpl() {
            return this.field;
        }

        @Override
        public String getTableName() {
            return GroupData.TABLE_NAME;
        }
    }
}

