/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata.channel;

import io.privacyresearch.clientdata.channel.ChannelKey;
import io.privacyresearch.clientdata.recipient.RecipientRecord;

public record ChannelRecord(ChannelKey key, RecipientRecord recipient, int type, long date, boolean archived, long lastSeen, boolean hasSent, boolean lastScrolled, boolean pinned, boolean active, long lastRead) {

    public static class Builder {
        ChannelKey key = new ChannelKey();
        RecipientRecord recipient = new RecipientRecord.Builder().build();
        int type;
        long date;
        boolean archived;
        long lastSeen;
        boolean hasSent;
        boolean lastScrolled;
        boolean pinned;
        boolean active;
        long lastRead;

        public Builder key(ChannelKey key) {
            this.key = key;
            return this;
        }

        public Builder recipient(RecipientRecord recipient) {
            this.recipient = recipient;
            return this;
        }

        public Builder pin(boolean pinned) {
            this.pinned = pinned;
            return this;
        }

        public ChannelRecord build() {
            if (this.key == null) {
                throw new IllegalStateException("A ChannelKey must be set.");
            }
            return new ChannelRecord(this.key, this.recipient, this.type, this.date, this.archived, this.lastSeen, this.hasSent, this.lastScrolled, this.pinned, this.active, this.lastRead);
        }
    }
}

