/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata.util;

import io.privacyresearch.clientdata.message.BodyRange;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class BodyRangeUtil {
    public static List<BodyRange> rawToBodyRanges(String rawBodyRanges) {
        LinkedList<BodyRange> bodyRanges = new LinkedList<BodyRange>();
        if (rawBodyRanges != null && !rawBodyRanges.isEmpty()) {
            String[] splitRawBodyRanges;
            for (String rawBodyRange : splitRawBodyRanges = rawBodyRanges.split(";")) {
                BodyRange bodyRange;
                String[] rawBodyRangeParts;
                if (rawBodyRange.length() <= 3 || (rawBodyRangeParts = rawBodyRange.split(",")).length < 3) continue;
                int start = Integer.parseInt(rawBodyRangeParts[0]);
                int length = Integer.parseInt(rawBodyRangeParts[1]);
                if (rawBodyRangeParts[2].length() < 3) {
                    int styleId = Integer.parseInt(rawBodyRangeParts[2]);
                    bodyRange = BodyRange.fromStyleId(styleId, start, length);
                } else {
                    bodyRange = BodyRange.fromMentionAci(rawBodyRangeParts[2], start, length);
                }
                bodyRanges.add(bodyRange);
            }
        }
        return bodyRanges;
    }

    public static String bodyRangesToRaw(List<BodyRange> bodyRanges) {
        if (bodyRanges == null) {
            return "";
        }
        return bodyRanges.stream().map(BodyRangeUtil::bodyRangeToRaw).collect(Collectors.joining(";"));
    }

    private static String bodyRangeToRaw(BodyRange bodyRange) {
        if (bodyRange.isStyled()) {
            return bodyRange.start() + "," + bodyRange.length() + "," + bodyRange.style().id();
        }
        return bodyRange.start() + "," + bodyRange.length() + "," + bodyRange.mentionAci();
    }
}

