/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata.recipient;

import io.privacyresearch.clientdata.recipient.RecipientKey;
import io.privacyresearch.clientdata.user.color.AvatarColor;

public record RecipientRecord(RecipientKey key, Type type, boolean blocked, int expireMessages, int expireTimerVersion, long muteUntil, long unregisteredTimestamp, AvatarColor avatarColor) {
    public boolean isGroup() {
        return this.type == Type.GV1 || this.type == Type.GV2;
    }

    public static enum Type {
        ACCOUNT(0),
        CONTACT(1),
        MMS(2),
        GV1(3),
        GV2(4),
        DISTRIBUTION_LIST(5),
        CALL_LINK(6),
        UNKNOWN(7);

        public int type;

        private Type(int type) {
            this.type = type;
        }

        public static Type fromValue(int value) {
            for (Type type : Type.values()) {
                if (type.type != value) continue;
                return type;
            }
            return null;
        }
    }

    public static class Builder {
        RecipientKey key = new RecipientKey();
        Type type;
        boolean blocked;
        int expireMessages;
        int expireTimerVersion = 1;
        long muteUntil = -1L;
        long unregisteredTimestamp;
        AvatarColor avatarColor;

        public Builder avatarColor(AvatarColor avatarColor) {
            this.avatarColor = avatarColor;
            return this;
        }

        public Builder blocked(boolean blocked) {
            this.blocked = blocked;
            return this;
        }

        public Builder key(RecipientKey key) {
            this.key = key;
            return this;
        }

        public Builder muteUntil(long muteUntil) {
            this.muteUntil = muteUntil;
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public RecipientRecord build() {
            if (this.key == null) {
                throw new IllegalStateException("A RecipientKey must be set.");
            }
            return new RecipientRecord(this.key, this.type, this.blocked, this.expireMessages, this.expireTimerVersion, this.muteUntil, this.unregisteredTimestamp, this.avatarColor);
        }
    }
}

