/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata.distributionlist;

import io.privacyresearch.clientdata.DatabaseLayer;
import io.privacyresearch.clientdata.Field;
import io.privacyresearch.clientdata.FieldBuilder;
import io.privacyresearch.clientdata.FieldReference;
import io.privacyresearch.clientdata.FieldType;
import io.privacyresearch.clientdata.IdData;
import io.privacyresearch.clientdata.distributionlist.DistributionListData;
import io.privacyresearch.clientdata.distributionlist.DistributionListKey;
import io.privacyresearch.clientdata.distributionlist.DistributionListMembershipRecord;
import io.privacyresearch.clientdata.recipient.RecipientData;
import io.privacyresearch.clientdata.recipient.RecipientKey;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DistributionListMembershipData
extends IdData<DistributionListMembershipRecord> {
    private static final Logger LOG = Logger.getLogger(DistributionListMembershipData.class.getName());
    public static final String TABLE_NAME = "distribution_list_membership";
    private final DistributionListData distributionListData;
    private final RecipientData recipientData;

    public DistributionListMembershipData(DatabaseLayer databaseLayer, DistributionListData distributionListData, RecipientData recipientData) {
        super(databaseLayer, TABLE_NAME, List.of(Fields.values()));
        this.distributionListData = distributionListData;
        this.recipientData = recipientData;
    }

    @Override
    public DistributionListMembershipRecord construct(ResultSet resultSet) throws SQLException {
        DistributionListKey distributionListKey = (DistributionListKey)this.distributionListData.getKeyById(Fields.DISTRIBUTION_LIST_ID.getValue(resultSet));
        RecipientKey recipientKey = (RecipientKey)this.recipientData.getKeyById(Fields.RECIPIENT_ID.getValue(resultSet));
        return new DistributionListMembershipRecord(distributionListKey, recipientKey);
    }

    public Set<DistributionListMembershipRecord> listByDistributionList(DistributionListKey distributionListKey) {
        LOG.info("List members by distribution list with key " + String.valueOf(distributionListKey));
        try {
            HashSet<DistributionListMembershipRecord> records = new HashSet<DistributionListMembershipRecord>();
            Integer distributionListId = (Integer)this.distributionListData.getIdByKey(distributionListKey);
            if (distributionListId != null) {
                try (ResultSet result = this.databaseLayer.select(this.getFields()).from(this.getTableName()).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.DISTRIBUTION_LIST_ID, distributionListId))).execute();){
                    while (result.next()) {
                        records.add(this.construct(result));
                    }
                }
                LOG.info("Distribution list with key " + String.valueOf(distributionListKey) + " has " + records.size() + " members.");
            }
            return records;
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public static enum Fields implements Field
    {
        ID(FieldBuilder.newField("_id", FieldType.INT).withPrimaryKey(true).withAutoincrement(true)),
        DISTRIBUTION_LIST_ID(FieldBuilder.newField("distribution_list_id", FieldType.INT).withNullable(false).withDefaultValue(0).withReference("distribution_list", DistributionListData.Fields.ID, FieldReference.OnDelete.CASCADE)),
        RECIPIENT_ID(FieldBuilder.newField("recipient_id", FieldType.INT).withNullable(false).withDefaultValue(0).withReference("recipient", RecipientData.Fields.ID, FieldReference.OnDelete.CASCADE));

        public final Field field;

        private Fields(FieldBuilder builder) {
            this.field = builder.build();
        }

        @Override
        public Field getFieldImpl() {
            return this.field;
        }

        @Override
        public String getTableName() {
            return DistributionListMembershipData.TABLE_NAME;
        }
    }
}

