/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata;

import io.privacyresearch.clientdata.BaseData;
import io.privacyresearch.clientdata.DatabaseLayer;
import io.privacyresearch.clientdata.Field;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public abstract class IdData<T>
extends BaseData {
    public IdData(DatabaseLayer databaseLayer, String tableName, List<Field> fields) {
        super(databaseLayer, tableName, fields);
    }

    public abstract T construct(ResultSet var1) throws SQLException;

    public int count() throws SQLException {
        try (ResultSet result = this.databaseLayer.selectRaw(List.of("COUNT(*)")).from(this.getTableName()).execute();){
            if (result.next()) {
                int n = result.getInt(1);
                return n;
            }
        }
        return -1;
    }

    public List<T> findAll() throws SQLException {
        try (ResultSet result = this.databaseLayer.select(this.getFields()).from(this.getTableName()).execute();){
            ArrayList<T> data = new ArrayList<T>();
            while (result.next()) {
                data.add(this.construct(result));
            }
            ArrayList<T> arrayList = data;
            return arrayList;
        }
    }

    public boolean existsById(Object primaryKey) throws SQLException {
        try (ResultSet result = this.getById(primaryKey);){
            boolean bl = result.next();
            return bl;
        }
    }

    public T findById(Object primaryKey) throws SQLException {
        try (ResultSet result = this.getById(primaryKey);){
            if (result.next()) {
                T t = this.construct(result);
                return t;
            }
            T t = null;
            return t;
        }
    }

    private ResultSet getById(Object primaryKey) throws SQLException {
        return this.databaseLayer.select(this.getFields()).from(this.getTableName()).where(List.of(new DatabaseLayer.BinaryOperandField(this.getPrimaryKeyField(), primaryKey))).execute();
    }

    @Override
    protected void setNullableString(PreparedStatement stmt, int idx, String value) throws SQLException {
        if (value == null) {
            stmt.setNull(idx, 12);
        } else {
            stmt.setString(idx, value);
        }
    }

    protected Field getPrimaryKeyField() {
        return this.getFields().stream().filter(Field::isPrimaryKey).findFirst().orElse(null);
    }
}

