/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata.search;

import io.privacyresearch.clientdata.BaseData;
import io.privacyresearch.clientdata.DatabaseLayer;
import io.privacyresearch.clientdata.Field;
import io.privacyresearch.clientdata.FieldBuilder;
import io.privacyresearch.clientdata.FieldType;
import io.privacyresearch.clientdata.message.MessageData;
import io.privacyresearch.clientdata.message.MessageKey;
import io.privacyresearch.clientdata.recipient.RecipientData;
import io.privacyresearch.clientdata.recipient.RecipientKey;
import io.privacyresearch.clientdata.search.SearchMessageRecord;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class SearchMessageData
extends BaseData {
    private static final Logger LOG = Logger.getLogger(SearchMessageData.class.getName());
    private static final String SNIPPET_WRAP = "...";
    public static final String TABLE_NAME = "search_fts";
    private final MessageData messageData;
    private final RecipientData recipientData;

    public SearchMessageData(DatabaseLayer databaseLayer, MessageData messageData, RecipientData recipientData) {
        super(databaseLayer, TABLE_NAME, List.of(Fields.values()));
        this.messageData = messageData;
        this.recipientData = recipientData;
    }

    @Override
    public String getTableName() {
        return TABLE_NAME;
    }

    @Override
    public List<Field> getFields() {
        return List.of(Fields.values());
    }

    @Override
    public void createTable() throws SQLException {
        this.databaseLayer.createVirtualTable(this.getTableName()).using("fts5").content("message", Fields.ID.getColumnName()).fields(this.getFields().stream().filter(Field::includeInCreateTable).collect(Collectors.toList())).execute();
        String triggerAfterInsert = "CREATE TRIGGER IF NOT EXISTS message_ai AFTER INSERT ON %s BEGIN\n    INSERT INTO %s(_id, body, to_recipient_id) VALUES (new._id, new.body, new.to_recipient_id);\nEND;";
        String triggerAfterUpdate = "CREATE TRIGGER IF NOT EXISTS message_au AFTER UPDATE ON %s BEGIN\n    INSERT INTO %s(%s, _id, body, to_recipient_id) VALUES ('delete', old._id, old.body, old.to_recipient_id);\n    INSERT INTO %s(_id, body, to_recipient_id) VALUES (new._id, new.body, new.to_recipient_id);\nEND;";
        String triggerAfterDelete = "CREATE TRIGGER IF NOT EXISTS message_ad AFTER DELETE ON %s BEGIN\n    INSERT INTO %s(%s, _id, body, to_recipient_id) VALUES ('delete', old._id, old.body, old.to_recipient_id);\nEND;";
        this.databaseLayer.executeQuery(String.format(triggerAfterInsert, this.messageData.getTableName(), this.getTableName()));
        this.databaseLayer.executeQuery(String.format(triggerAfterUpdate, this.messageData.getTableName(), this.getTableName(), this.getTableName(), this.getTableName()));
        this.databaseLayer.executeQuery(String.format(triggerAfterDelete, this.messageData.getTableName(), this.getTableName(), this.getTableName()));
    }

    @Override
    public void dropTable() throws SQLException {
        this.databaseLayer.executeQuery("DROP TRIGGER IF EXISTS message_ai");
        this.databaseLayer.executeQuery("DROP TRIGGER IF EXISTS message_au");
        this.databaseLayer.executeQuery("DROP TRIGGER IF EXISTS message_ad");
        this.databaseLayer.dropTable(this.getTableName()).execute();
    }

    public List<SearchMessageRecord> searchMessages(String query) {
        String whereClause = String.format("%s MATCH ?", this.getTableName());
        return this.searchMessages(whereClause, stmt -> stmt.setString(1, String.format("\"%s\"*", query)));
    }

    public List<SearchMessageRecord> searchMessagesByToRecipient(String query, RecipientKey toRecipientKey) {
        try {
            Integer recipientId = (Integer)this.recipientData.getIdByKey(toRecipientKey);
            if (recipientId == null) {
                throw new IllegalStateException("A recipient with key " + String.valueOf(toRecipientKey) + " should exist!");
            }
            String whereClause = String.format("%s MATCH ? AND %s.%s = ?", this.getTableName(), this.messageData.getTableName(), MessageData.Fields.TO_RECIPIENT_ID.getColumnName());
            return this.searchMessages(whereClause, stmt -> {
                stmt.setString(1, String.format("\"%s\"*", query));
                stmt.setLong(2, recipientId.intValue());
            });
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    private List<SearchMessageRecord> searchMessages(String whereClause, DatabaseLayer.TryConsumer<PreparedStatement> statementConsumer) {
        List<String> fields = List.of(String.format("snippet(%s, -1, '', '', '%s', 7)", this.getTableName(), SNIPPET_WRAP), String.format("%s.%s", this.messageData.getTableName(), MessageData.Fields.ENTITY_KEY.getColumnName()), String.format("%s.%s", this.messageData.getTableName(), MessageData.Fields.DATE_RECEIVED.getColumnName()), String.format("%s.%s", this.getTableName(), Fields.TO_RECIPIENT_ID.getColumnName()), String.format("%s.%s", this.getTableName(), Fields.BODY.getColumnName()));
        LinkedList<SearchMessageRecord> records = new LinkedList<SearchMessageRecord>();
        try (ResultSet result = this.databaseLayer.selectRaw(fields).from(this.messageData.getTableName()).join(DatabaseLayer.Join.inner((Field)Fields.ID, MessageData.Fields.ID)).where(whereClause, statementConsumer).orderBy(MessageData.Fields.DATE_RECEIVED, DatabaseLayer.Order.DESC).execute();){
            while (result.next()) {
                RecipientKey recipientKey = null;
                Integer recipientId = result.getInt(4);
                if (recipientId != 0) {
                    recipientKey = (RecipientKey)this.recipientData.getKeyById(recipientId);
                }
                records.add(new SearchMessageRecord(new MessageKey(result.getBytes(2)), recipientKey, result.getString(5), result.getString(1), result.getLong(3)));
            }
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
        return records;
    }

    public static enum Fields implements Field
    {
        ID(FieldBuilder.newField("_id", FieldType.INT).withPrimaryKey(true).withAutoincrement(true)),
        BODY(FieldBuilder.newField("body", FieldType.TEXT)),
        TO_RECIPIENT_ID(FieldBuilder.newField("to_recipient_id", FieldType.INT));

        public final Field field;

        private Fields(FieldBuilder builder) {
            this.field = builder.build();
        }

        @Override
        public Field getFieldImpl() {
            return this.field;
        }

        @Override
        public String getTableName() {
            return SearchMessageData.TABLE_NAME;
        }
    }
}

