/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata.sticker;

import io.privacyresearch.clientdata.DatabaseLayer;
import io.privacyresearch.clientdata.EntityKeyData;
import io.privacyresearch.clientdata.Field;
import io.privacyresearch.clientdata.FieldBuilder;
import io.privacyresearch.clientdata.FieldType;
import io.privacyresearch.clientdata.sticker.StickerPackKey;
import io.privacyresearch.clientdata.sticker.StickerPackRecord;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StickerPackData
extends EntityKeyData<StickerPackRecord, StickerPackKey> {
    private static final Logger LOG = Logger.getLogger(StickerPackData.class.getName());
    public static final String TABLE_NAME = "sticker_pack";

    public StickerPackData(DatabaseLayer databaseLayer) {
        super(databaseLayer, TABLE_NAME, List.of(Fields.values()), StickerPackKey::new);
    }

    @Override
    public StickerPackRecord construct(ResultSet resultSet) throws SQLException {
        return new StickerPackRecord(new StickerPackKey((byte[])Fields.ENTITY_KEY.getValue(resultSet)), (String)Fields.PACK_ID.getValue(resultSet), (String)Fields.PACK_KEY.getValue(resultSet), (String)Fields.TITLE.getValue(resultSet), (String)Fields.AUTHOR.getValue(resultSet));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StickerPackRecord findByPackId(String packId) {
        try (ResultSet result = this.databaseLayer.select(this.getFields()).from(this.getTableName()).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.PACK_ID, packId))).execute();){
            if (result.next()) {
                StickerPackRecord stickerPackRecord2 = this.construct(result);
                return stickerPackRecord2;
            }
            StickerPackRecord stickerPackRecord = null;
            return stickerPackRecord;
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public StickerPackKey createPack(String packId, String packKey, String title, String author) {
        StickerPackKey stickerPackKey = new StickerPackKey();
        Map<Field, Object> values = Map.ofEntries(Map.entry(Fields.ENTITY_KEY, stickerPackKey.getKey()), Map.entry(Fields.PACK_ID, packId), Map.entry(Fields.PACK_KEY, packKey), Map.entry(Fields.TITLE, title), Map.entry(Fields.AUTHOR, author));
        try {
            List<Integer> inserted = this.databaseLayer.insert(this.getTableName()).values(values).execute();
            if (inserted.size() == 1) {
                return stickerPackKey;
            }
            return null;
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public static enum Fields implements Field
    {
        ID(FieldBuilder.newField("_id", FieldType.INT).withPrimaryKey(true).withAutoincrement(true)),
        ENTITY_KEY(FieldBuilder.newField("entity_key", FieldType.BLOB).withEntityKey(true).withNullable(false).withDefaultValue(0)),
        PACK_ID(FieldBuilder.newField("pack_id", FieldType.TEXT).withNullable(false)),
        PACK_KEY(FieldBuilder.newField("pack_key", FieldType.TEXT).withNullable(false)),
        TITLE(FieldBuilder.newField("title", FieldType.TEXT)),
        AUTHOR(FieldBuilder.newField("author", FieldType.TEXT));

        public final Field field;

        private Fields(FieldBuilder builder) {
            this.field = builder.build();
        }

        @Override
        public Field getFieldImpl() {
            return this.field;
        }

        @Override
        public String getTableName() {
            return StickerPackData.TABLE_NAME;
        }
    }
}

