/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata.message;

import io.privacyresearch.clientdata.message.BodyRange;
import io.privacyresearch.clientdata.message.InsertInternalMessageRequest;
import io.privacyresearch.clientdata.message.StoryType;
import java.util.List;

public class InsertInternalMessageRequestBuilder {
    private String content;
    private List<BodyRange> bodyRanges;
    private int senderRecipientId;
    private int receiverRecipientId;
    private int expiration;
    private long timestamp = System.currentTimeMillis();
    private long receivedTimestamp = System.currentTimeMillis();
    private StoryType storyType = StoryType.NONE;
    private boolean viewOnce;

    private InsertInternalMessageRequestBuilder() {
    }

    public static InsertInternalMessageRequestBuilder anInsertInternalMessageRequest() {
        return new InsertInternalMessageRequestBuilder();
    }

    public InsertInternalMessageRequestBuilder bodyRanges(List<BodyRange> bodyRanges) {
        this.bodyRanges = bodyRanges;
        return this;
    }

    public InsertInternalMessageRequestBuilder content(String content) {
        this.content = content;
        return this;
    }

    public InsertInternalMessageRequestBuilder expiration(int expiration) {
        this.expiration = expiration;
        return this;
    }

    public InsertInternalMessageRequestBuilder senderRecipientId(int senderRecipientId) {
        this.senderRecipientId = senderRecipientId;
        return this;
    }

    public InsertInternalMessageRequestBuilder receiverRecipientId(int receiverRecipientId) {
        this.receiverRecipientId = receiverRecipientId;
        return this;
    }

    public InsertInternalMessageRequestBuilder storyType(StoryType storyType) {
        this.storyType = storyType;
        return this;
    }

    public InsertInternalMessageRequestBuilder timestamp(long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public InsertInternalMessageRequestBuilder viewOnce(boolean v) {
        this.viewOnce = v;
        return this;
    }

    public InsertInternalMessageRequest build() {
        InsertInternalMessageRequest request = new InsertInternalMessageRequest();
        request.setContent(this.content);
        request.setExpiration(this.expiration);
        request.setSenderRecipientId(this.senderRecipientId);
        request.setReceiverRecipientId(this.receiverRecipientId);
        request.setTimestamp(this.timestamp);
        request.setReceivedTimestamp(this.receivedTimestamp);
        request.setBodyRanges(this.bodyRanges);
        request.setStoryType(this.storyType);
        request.setViewOnce(this.viewOnce);
        return request;
    }
}

