/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata.keys;

import io.privacyresearch.clientdata.DatabaseLayer;
import io.privacyresearch.clientdata.Field;
import io.privacyresearch.clientdata.FieldBuilder;
import io.privacyresearch.clientdata.FieldType;
import io.privacyresearch.clientdata.IdData;
import io.privacyresearch.clientdata.keys.SessionEntry;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.signal.libsignal.protocol.InvalidMessageException;
import org.signal.libsignal.protocol.ServiceId;
import org.signal.libsignal.protocol.SignalProtocolAddress;
import org.signal.libsignal.protocol.state.SessionRecord;

public class SessionData
extends IdData<SessionRecord> {
    private static final Logger LOG = Logger.getLogger(SessionData.class.getName());
    public static final String TABLE_NAME = "session";

    public SessionData(DatabaseLayer databaseLayer) {
        super(databaseLayer, TABLE_NAME, List.of(Fields.values()));
    }

    @Override
    public SessionRecord construct(ResultSet resultSet) throws SQLException {
        byte[] record = (byte[])Fields.RECORD.getValue(resultSet);
        try {
            return new SessionRecord(record);
        }
        catch (InvalidMessageException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public void store(ServiceId serviceId, SignalProtocolAddress address, SessionRecord sr) throws SQLException {
        LOG.info("Store a SessionRecord for serviceid " + serviceId.toServiceIdString());
        SessionRecord exists = this.loadSession(serviceId, address);
        if (exists != null) {
            this.delete(serviceId, address);
        }
        Map<Field, Object> values = Map.ofEntries(Map.entry(Fields.ACCOUNT_ID, serviceId.toServiceIdString()), Map.entry(Fields.ADDRESS, address.getName()), Map.entry(Fields.DEVICE, address.getDeviceId()), Map.entry(Fields.RECORD, sr.serialize()));
        try {
            this.databaseLayer.insert(this.getTableName()).values(values).execute();
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public SessionRecord loadSession(ServiceId serviceId, SignalProtocolAddress address) {
        String sidString = serviceId.toServiceIdString();
        LOG.info("Load Session for serviceIdstring  " + sidString + " and spa = " + String.valueOf(address));
        try {
            List<DatabaseLayer.BinaryOperandField> where = List.of(new DatabaseLayer.BinaryOperandField(Fields.ACCOUNT_ID, sidString), new DatabaseLayer.BinaryOperandField(Fields.ADDRESS, address.getName()), new DatabaseLayer.BinaryOperandField(Fields.DEVICE, address.getDeviceId()));
            ResultSet result = this.databaseLayer.select(this.getFields()).from(this.getTableName()).where(where).execute();
            if (result.next()) {
                return this.construct(result);
            }
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        return null;
    }

    public List<SessionEntry> getAllFor(ServiceId serviceId, String addressName) {
        LinkedList<SessionEntry> answer = new LinkedList<SessionEntry>();
        try {
            ResultSet result = this.findByAccountIdAndAddress(serviceId, addressName);
            while (result.next()) {
                String name = (String)Fields.ADDRESS.getValue(result);
                int did = (Integer)Fields.DEVICE.getValue(result);
                if (name == null || did < 0) {
                    LOG.warning("Invalid record in sessionstore for " + addressName);
                    continue;
                }
                answer.add(new SessionEntry(name, did, new SessionRecord((byte[])Fields.RECORD.getValue(result))));
            }
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        catch (InvalidMessageException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        return answer;
    }

    public List<Integer> getSubDevices(ServiceId serviceId, String addressName) {
        LinkedList<Integer> answer = new LinkedList<Integer>();
        try {
            ResultSet result = this.findByAccountIdAndAddress(serviceId, addressName);
            while (result.next()) {
                int candidate = (Integer)Fields.DEVICE.getValue(result);
                if (candidate == 0) continue;
                answer.add(candidate);
            }
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        return answer;
    }

    private ResultSet findByAccountIdAndAddress(ServiceId serviceId, String addressName) throws SQLException {
        if (serviceId == null) {
            throw new IllegalArgumentException("Can not retrieve sessions without our serviceId");
        }
        List<DatabaseLayer.BinaryOperandField> where = List.of(new DatabaseLayer.BinaryOperandField(Fields.ACCOUNT_ID, serviceId.toServiceIdString()), new DatabaseLayer.BinaryOperandField(Fields.ADDRESS, addressName));
        return this.databaseLayer.select(this.getFields()).from(this.getTableName()).where(where).execute();
    }

    public void delete(ServiceId serviceId, SignalProtocolAddress address) {
        List<DatabaseLayer.BinaryOperandField> where = List.of(new DatabaseLayer.BinaryOperandField(Fields.ACCOUNT_ID, serviceId.toServiceIdString()), new DatabaseLayer.BinaryOperandField(Fields.ADDRESS, address.getName()), new DatabaseLayer.BinaryOperandField(Fields.DEVICE, address.getDeviceId()));
        try {
            this.databaseLayer.delete(this.getTableName()).where(where).execute();
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    public void deleteAllFor(ServiceId serviceId, String name) {
        List<DatabaseLayer.BinaryOperandField> where = List.of(new DatabaseLayer.BinaryOperandField(Fields.ACCOUNT_ID, serviceId.toServiceIdString()), new DatabaseLayer.BinaryOperandField(Fields.ADDRESS, name));
        try {
            this.databaseLayer.delete(this.getTableName()).where(where).execute();
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    public static enum Fields implements Field
    {
        ACCOUNT_ID(FieldBuilder.newField("account_id", FieldType.SHORT_STRING)),
        ADDRESS(FieldBuilder.newField("address", FieldType.SHORT_STRING)),
        DEVICE(FieldBuilder.newField("device", FieldType.INT)),
        RECORD(FieldBuilder.newField("record", FieldType.BLOB));

        public final Field field;

        private Fields(FieldBuilder builder) {
            this.field = builder.build();
        }

        @Override
        public Field getFieldImpl() {
            return this.field;
        }

        @Override
        public String getTableName() {
            return SessionData.TABLE_NAME;
        }
    }
}

