/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata.message;

public record BodyRange(String mentionAci, Style style, int start, int length) {
    public boolean isMention() {
        return this.mentionAci() != null && !this.mentionAci().isEmpty();
    }

    public boolean isStyled() {
        return this.style() != null && this.style() != Style.NONE;
    }

    public static BodyRange fromStyle(Style style, int start, int length) {
        return new BodyRange("", style, start, length);
    }

    public static BodyRange fromStyleId(int styleId, int start, int length) {
        return new BodyRange("", Style.fromId(styleId), start, length);
    }

    public static BodyRange fromMentionAci(String mentionAci, int start, int length) {
        return new BodyRange(mentionAci, Style.NONE, start, length);
    }

    public static enum Style {
        NONE(0),
        BOLD(1),
        ITALIC(2),
        SPOILER(3),
        STRIKETHROUGH(4),
        MONOSPACE(5);

        private final int id;

        private Style(int id) {
            this.id = id;
        }

        public int id() {
            return this.id;
        }

        public static Style fromId(int id) {
            for (Style style : Style.values()) {
                if (style.id != id) continue;
                return style;
            }
            throw new IllegalArgumentException("Invalid id for BodyRange.Style: " + id);
        }
    }
}

