/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata;

import io.privacyresearch.clientdata.BaseData;
import io.privacyresearch.clientdata.DatabaseLayer;
import io.privacyresearch.clientdata.PatchTablesBean;
import io.privacyresearch.clientdata.attachment.AttachmentData;
import io.privacyresearch.clientdata.badge.BadgeData;
import io.privacyresearch.clientdata.cache.UserCache;
import io.privacyresearch.clientdata.call.CallData;
import io.privacyresearch.clientdata.canvas.CanvasData;
import io.privacyresearch.clientdata.channel.ChannelData;
import io.privacyresearch.clientdata.distributionlist.DistributionListData;
import io.privacyresearch.clientdata.draft.DraftData;
import io.privacyresearch.clientdata.group.GroupData;
import io.privacyresearch.clientdata.keys.IdentityData;
import io.privacyresearch.clientdata.keys.KyberPreKeyData;
import io.privacyresearch.clientdata.keys.PreKeyData;
import io.privacyresearch.clientdata.keys.SenderKeyData;
import io.privacyresearch.clientdata.keys.SenderKeySharedWithData;
import io.privacyresearch.clientdata.keys.SessionData;
import io.privacyresearch.clientdata.keys.SignedPreKeyData;
import io.privacyresearch.clientdata.keyvalue.AccountStorage;
import io.privacyresearch.clientdata.keyvalue.KeyValueData;
import io.privacyresearch.clientdata.keyvalue.PreferenceStorage;
import io.privacyresearch.clientdata.keyvalue.StorageStorage;
import io.privacyresearch.clientdata.message.MessageData;
import io.privacyresearch.clientdata.message.ReceiptData;
import io.privacyresearch.clientdata.proxy.ProxyData;
import io.privacyresearch.clientdata.quote.QuoteData;
import io.privacyresearch.clientdata.reaction.ReactionData;
import io.privacyresearch.clientdata.recipient.RecipientData;
import io.privacyresearch.clientdata.search.SearchMessageData;
import io.privacyresearch.clientdata.sticker.StickerData;
import io.privacyresearch.clientdata.sticker.StickerPackData;
import io.privacyresearch.clientdata.user.UserData;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sqlite.mc.SQLiteMCSqlCipherConfig;

public class SqliteStorageBean {
    public static final String DB_NAME = "wavefx.sqlite.db";
    private final DatabaseLayer databaseLayer;
    Path storageRoot;
    private Map<DataTable, BaseData> dataTables = new HashMap<DataTable, BaseData>();
    private AccountStorage accountStorage;
    private PreferenceStorage preferenceStorage;
    private StorageStorage storageStorage;
    private UserCache userCache;
    private static final Logger LOG = Logger.getLogger(SqliteStorageBean.class.getName());
    private static final String STORAGEDIR_DEFAULTROOT = ".signalfx";

    public SqliteStorageBean() {
        this(Path.of(System.getProperty("equation.root", STORAGEDIR_DEFAULTROOT), new String[0]));
    }

    public SqliteStorageBean(Path storageRoot) {
        System.err.println("STORAGEROOT = " + String.valueOf(storageRoot));
        this.storageRoot = storageRoot.isAbsolute() ? storageRoot : Path.of(System.getProperty("user.home"), new String[0]).resolve(storageRoot.toString());
        this.storageRoot.toFile().mkdirs();
        LOG.log(Level.INFO, "StorageRoot set to: {0}", this.storageRoot);
        boolean databaseExists = Files.exists(this.storageRoot.resolve(DB_NAME), new LinkOption[0]);
        Connection connection = this.createConnection();
        this.databaseLayer = new DatabaseLayer(connection);
        KeyValueData keyValueData = new KeyValueData(this.databaseLayer);
        this.dataTables.put(DataTable.KEY_VALUE, keyValueData);
        this.accountStorage = new AccountStorage(keyValueData);
        this.preferenceStorage = new PreferenceStorage(keyValueData);
        this.storageStorage = new StorageStorage(keyValueData);
        RecipientData recipientData = new RecipientData(this.databaseLayer);
        this.dataTables.put(DataTable.RECIPIENT, recipientData);
        ChannelData channelData = new ChannelData(this.databaseLayer, recipientData);
        this.dataTables.put(DataTable.CHANNEL, channelData);
        UserData userData = new UserData(this.databaseLayer, channelData, recipientData);
        this.dataTables.put(DataTable.USER, userData);
        MessageData messageData = new MessageData(this.databaseLayer, recipientData, userData);
        this.dataTables.put(DataTable.MESSAGE, messageData);
        StickerPackData stickerPackData = new StickerPackData(this.databaseLayer);
        this.dataTables.put(DataTable.STICKER_PACK, stickerPackData);
        this.dataTables.put(DataTable.IDENTITY, new IdentityData(this.databaseLayer));
        this.dataTables.put(DataTable.KYBER_PRE_KEY, new KyberPreKeyData(this.databaseLayer));
        this.dataTables.put(DataTable.PRE_KEY, new PreKeyData(this.databaseLayer));
        this.dataTables.put(DataTable.SENDER_KEY, new SenderKeyData(this.databaseLayer));
        this.dataTables.put(DataTable.SENDER_KEY_SHARED_WITH, new SenderKeySharedWithData(this.databaseLayer, userData));
        this.dataTables.put(DataTable.SESSION, new SessionData(this.databaseLayer));
        this.dataTables.put(DataTable.SIGNED_PRE_KEY, new SignedPreKeyData(this.databaseLayer));
        this.dataTables.put(DataTable.ATTACHMENT, new AttachmentData(this.databaseLayer, messageData));
        this.dataTables.put(DataTable.BADGE, new BadgeData(this.databaseLayer, userData));
        this.dataTables.put(DataTable.CALL, new CallData(this.databaseLayer, recipientData));
        this.dataTables.put(DataTable.CANVAS, new CanvasData(this.databaseLayer, channelData, recipientData, userData));
        this.dataTables.put(DataTable.DISTRIBUTIONLIST, new DistributionListData(this.databaseLayer, recipientData));
        this.dataTables.put(DataTable.DRAFT, new DraftData(this.databaseLayer, channelData));
        this.dataTables.put(DataTable.GROUP, new GroupData(this.databaseLayer, channelData, recipientData, userData, this.accountStorage));
        this.dataTables.put(DataTable.PROXY, new ProxyData(this.databaseLayer));
        this.dataTables.put(DataTable.QUOTE, new QuoteData(this.databaseLayer, messageData));
        this.dataTables.put(DataTable.REACTION, new ReactionData(this.databaseLayer, messageData, recipientData));
        this.dataTables.put(DataTable.RECEIPT, new ReceiptData(this.databaseLayer, messageData, userData));
        this.dataTables.put(DataTable.SEARCH_MESSAGE, new SearchMessageData(this.databaseLayer, messageData, recipientData));
        this.dataTables.put(DataTable.STICKER, new StickerData(this.databaseLayer, stickerPackData));
        this.userCache = new UserCache(this.accountStorage, userData);
        if (!databaseExists) {
            this.createTables();
        } else {
            this.patchTables();
        }
    }

    public Path getStorageRoot() {
        return this.storageRoot;
    }

    public void shutdown() {
        this.databaseLayer.shutdown();
    }

    public Connection getConnection() {
        return this.databaseLayer.getConnection();
    }

    public void resetConnection() {
        this.shutdown();
        Connection connection = this.createConnection();
        this.databaseLayer.setConnection(connection);
    }

    public AccountStorage account() {
        return this.accountStorage;
    }

    public PreferenceStorage preference() {
        return this.preferenceStorage;
    }

    public StorageStorage storage() {
        return this.storageStorage;
    }

    public PreKeyData getPreKeyData() {
        return (PreKeyData)this.dataTables.get((Object)DataTable.PRE_KEY);
    }

    public KyberPreKeyData getKyberPreKeyData() {
        return (KyberPreKeyData)this.dataTables.get((Object)DataTable.KYBER_PRE_KEY);
    }

    public SignedPreKeyData getSignedPreKeyData() {
        return (SignedPreKeyData)this.dataTables.get((Object)DataTable.SIGNED_PRE_KEY);
    }

    public SenderKeyData getSenderKeyData() {
        return (SenderKeyData)this.dataTables.get((Object)DataTable.SENDER_KEY);
    }

    public SenderKeySharedWithData getSenderKeySharedWithData() {
        return (SenderKeySharedWithData)this.dataTables.get((Object)DataTable.SENDER_KEY_SHARED_WITH);
    }

    public IdentityData getIdentityData() {
        return (IdentityData)this.dataTables.get((Object)DataTable.IDENTITY);
    }

    public SessionData getSessionData() {
        return (SessionData)this.dataTables.get((Object)DataTable.SESSION);
    }

    public RecipientData getRecipientData() {
        return (RecipientData)this.dataTables.get((Object)DataTable.RECIPIENT);
    }

    public UserData getUserData() {
        return (UserData)this.dataTables.get((Object)DataTable.USER);
    }

    public GroupData getGroupData() {
        return (GroupData)this.dataTables.get((Object)DataTable.GROUP);
    }

    public DistributionListData getDistributionListData() {
        return (DistributionListData)this.dataTables.get((Object)DataTable.DISTRIBUTIONLIST);
    }

    public BadgeData getBadgeData() {
        return (BadgeData)this.dataTables.get((Object)DataTable.BADGE);
    }

    public CallData getCallData() {
        return (CallData)this.dataTables.get((Object)DataTable.CALL);
    }

    public ChannelData getChannelData() {
        return (ChannelData)this.dataTables.get((Object)DataTable.CHANNEL);
    }

    public CanvasData getCanvasData() {
        return (CanvasData)this.dataTables.get((Object)DataTable.CANVAS);
    }

    public MessageData getMessageData() {
        return (MessageData)this.dataTables.get((Object)DataTable.MESSAGE);
    }

    public DraftData getDraftData() {
        return (DraftData)this.dataTables.get((Object)DataTable.DRAFT);
    }

    public ReactionData getReactionData() {
        return (ReactionData)this.dataTables.get((Object)DataTable.REACTION);
    }

    public QuoteData getQuoteData() {
        return (QuoteData)this.dataTables.get((Object)DataTable.QUOTE);
    }

    public AttachmentData getAttachmentData() {
        return (AttachmentData)this.dataTables.get((Object)DataTable.ATTACHMENT);
    }

    public ReceiptData getReceiptData() {
        return (ReceiptData)this.dataTables.get((Object)DataTable.RECEIPT);
    }

    public SearchMessageData getSearchMessageData() {
        return (SearchMessageData)this.dataTables.get((Object)DataTable.SEARCH_MESSAGE);
    }

    public StickerData getStickerData() {
        return (StickerData)this.dataTables.get((Object)DataTable.STICKER);
    }

    public StickerPackData getStickerPackData() {
        return (StickerPackData)this.dataTables.get((Object)DataTable.STICKER_PACK);
    }

    public ProxyData getProxyData() {
        return (ProxyData)this.dataTables.get((Object)DataTable.PROXY);
    }

    public UserCache getUserCache() {
        return this.userCache;
    }

    public void createIndexes() {
        LOG.info("Creating indexes");
        try {
            for (DataTable dataTable : DataTable.values()) {
                this.dataTables.get((Object)dataTable).createIndexes();
            }
        }
        catch (SQLException ex) {
            LOG.log(Level.WARNING, "Something went wrong while creating indexes.", ex);
        }
    }

    private Connection createConnection() {
        try {
            Connection connection;
            String enableDatabaseEncryption = System.getenv().getOrDefault("SQLITE_DB_ENCRYPTION", "on");
            String url = String.format("jdbc:sqlite:%s/%s", this.storageRoot.toString(), DB_NAME);
            LOG.info("URL: " + url);
            if ("off".equalsIgnoreCase(enableDatabaseEncryption)) {
                LOG.info("Using plain db");
                connection = DriverManager.getConnection(url);
            } else {
                LOG.info("Using encrypted db");
                connection = SQLiteMCSqlCipherConfig.getV4Defaults().withHexKey("736F796C656E74677265656E697370656F706C65".getBytes()).build().createConnection(url);
            }
            LOG.info("Connection to SQLite has been established: " + String.valueOf(connection));
            return connection;
        }
        catch (SQLException ex) {
            LOG.log(Level.WARNING, "Something went wrong while creating database connection.", ex);
            throw new IllegalStateException("Something went wrong while creating database connection.", ex);
        }
    }

    private void createTables() {
        LOG.info("Creating tables");
        try {
            for (DataTable dataTable : DataTable.values()) {
                this.dataTables.get((Object)dataTable).createTable();
            }
        }
        catch (SQLException ex) {
            LOG.log(Level.WARNING, "Something went wrong while creating tables.", ex);
            throw new IllegalArgumentException(ex);
        }
    }

    private void patchTables() {
        LOG.info("Patching tables");
        try {
            PatchTablesBean patchTablesBean = new PatchTablesBean(this);
            patchTablesBean.patchTables();
        }
        catch (SQLException ex) {
            LOG.log(Level.WARNING, "Something went wrong while patching tables.", ex);
            throw new IllegalArgumentException(ex);
        }
    }

    private static enum DataTable {
        KEY_VALUE,
        RECIPIENT,
        CHANNEL,
        USER,
        MESSAGE,
        STICKER_PACK,
        IDENTITY,
        KYBER_PRE_KEY,
        PRE_KEY,
        SENDER_KEY,
        SENDER_KEY_SHARED_WITH,
        SESSION,
        SIGNED_PRE_KEY,
        ATTACHMENT,
        BADGE,
        CALL,
        CANVAS,
        DISTRIBUTIONLIST,
        DRAFT,
        GROUP,
        PROXY,
        QUOTE,
        REACTION,
        RECEIPT,
        SEARCH_MESSAGE,
        STICKER;

    }
}

