/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata.group;

import io.privacyresearch.clientdata.DatabaseLayer;
import io.privacyresearch.clientdata.Field;
import io.privacyresearch.clientdata.FieldBuilder;
import io.privacyresearch.clientdata.FieldReference;
import io.privacyresearch.clientdata.FieldType;
import io.privacyresearch.clientdata.IdData;
import io.privacyresearch.clientdata.group.GroupData;
import io.privacyresearch.clientdata.group.GroupKey;
import io.privacyresearch.clientdata.group.MembershipRecord;
import io.privacyresearch.clientdata.user.UserData;
import io.privacyresearch.clientdata.user.UserKey;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.signal.storageservice.protos.groups.Member;

public class MembershipData
extends IdData<MembershipRecord> {
    private static final Logger LOG = Logger.getLogger(MembershipData.class.getName());
    public static final String TABLE_NAME = "group_membership";
    private final GroupData groupData;
    private final UserData userData;

    public MembershipData(DatabaseLayer databaseLayer, GroupData groupData, UserData userData) {
        super(databaseLayer, TABLE_NAME, List.of(Fields.values()));
        this.groupData = groupData;
        this.userData = userData;
    }

    @Override
    public MembershipRecord construct(ResultSet resultSet) throws SQLException {
        GroupKey groupKey = (GroupKey)this.groupData.getKeyById(Fields.GROUP_ID.getValue(resultSet));
        UserKey userKey = (UserKey)this.userData.getKeyById(Fields.USER_ID.getValue(resultSet));
        return new MembershipRecord(groupKey, userKey, Member.Role.forNumber((int)((Integer)Fields.ROLE.getValue(resultSet))));
    }

    public Set<MembershipRecord> listByGroup(GroupKey groupKey) {
        LOG.info("List members by group with key " + String.valueOf(groupKey));
        try {
            HashSet<MembershipRecord> records = new HashSet<MembershipRecord>();
            Integer groupId = (Integer)this.groupData.getIdByKey(groupKey);
            if (groupId != null) {
                try (ResultSet result = this.databaseLayer.select(this.getFields()).from(this.getTableName()).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.GROUP_ID, groupId))).execute();){
                    while (result.next()) {
                        records.add(this.construct(result));
                    }
                }
                LOG.info("Group with key " + String.valueOf(groupKey) + " has " + records.size() + " members.");
            }
            return records;
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public static enum Fields implements Field
    {
        ID(FieldBuilder.newField("_id", FieldType.INT).withPrimaryKey(true).withAutoincrement(true)),
        GROUP_ID(FieldBuilder.newField("group_id", FieldType.INT).withNullable(false).withDefaultValue(0).withReference("groups", GroupData.Fields.ID, FieldReference.OnDelete.CASCADE)),
        USER_ID(FieldBuilder.newField("user_id", FieldType.INT).withNullable(false).withDefaultValue(0).withReference("users", UserData.Fields.ID, FieldReference.OnDelete.CASCADE)),
        ROLE(FieldBuilder.newField("role", FieldType.INT).withDefaultValue(Member.Role.DEFAULT.getNumber()));

        public final Field field;

        private Fields(FieldBuilder builder) {
            this.field = builder.build();
        }

        @Override
        public Field getFieldImpl() {
            return this.field;
        }

        @Override
        public String getTableName() {
            return MembershipData.TABLE_NAME;
        }
    }
}

