/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata.canvas;

import io.privacyresearch.clientdata.DatabaseLayer;
import io.privacyresearch.clientdata.EntityKeyData;
import io.privacyresearch.clientdata.Field;
import io.privacyresearch.clientdata.FieldBuilder;
import io.privacyresearch.clientdata.FieldReference;
import io.privacyresearch.clientdata.FieldType;
import io.privacyresearch.clientdata.canvas.CanvasDbRecord;
import io.privacyresearch.clientdata.canvas.CanvasKey;
import io.privacyresearch.clientdata.canvas.CreateCanvasRequest;
import io.privacyresearch.clientdata.canvas.UpdateCanvasRequest;
import io.privacyresearch.clientdata.channel.ChannelData;
import io.privacyresearch.clientdata.channel.ChannelKey;
import io.privacyresearch.clientdata.message.BodyRange;
import io.privacyresearch.clientdata.recipient.RecipientData;
import io.privacyresearch.clientdata.recipient.RecipientKey;
import io.privacyresearch.clientdata.user.UserData;
import io.privacyresearch.clientdata.user.UserDbRecord;
import io.privacyresearch.clientdata.user.UserKey;
import io.privacyresearch.clientdata.util.BodyRangeUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CanvasData
extends EntityKeyData<CanvasDbRecord, CanvasKey> {
    private static final Logger LOG = Logger.getLogger(CanvasData.class.getName());
    public static final String TABLE_NAME = "canvas";
    private final ChannelData channelData;
    private final RecipientData recipientData;
    private final UserData userData;

    public CanvasData(DatabaseLayer databaseLayer, ChannelData channelData, RecipientData recipientData, UserData userData) {
        super(databaseLayer, TABLE_NAME, List.of(Fields.values()), CanvasKey::new);
        this.channelData = channelData;
        this.recipientData = recipientData;
        this.userData = userData;
    }

    @Override
    public CanvasDbRecord construct(ResultSet resultSet) throws SQLException {
        ChannelKey channelKey = (ChannelKey)this.channelData.getKeyById(Fields.CHANNEL_ID.getValue(resultSet));
        Integer authorRecipientId = (Integer)Fields.AUTHOR_RECIPIENT_ID.getValue(resultSet);
        UserDbRecord author = this.userData.findByRecipientId(authorRecipientId);
        if (author == null) {
            LOG.severe("No user found for recipientId " + authorRecipientId);
            throw new IllegalArgumentException("Can't create a canvas without author");
        }
        UserKey authorKey = author.key();
        return new CanvasDbRecord(new CanvasKey((byte[])Fields.ENTITY_KEY.getValue(resultSet)), (String)Fields.UUID.getValue(resultSet), (String)Fields.BODY.getValue(resultSet), BodyRangeUtil.rawToBodyRanges((String)Fields.BODY_RANGES.getValue(resultSet)), channelKey, authorKey, (Long)Fields.DATE_MODIFIED.getValue(resultSet), (Long)Fields.VERSION.getValue(resultSet));
    }

    public CanvasKey createCanvas(CreateCanvasRequest request) {
        if (request.channelKey() == null) {
            throw new IllegalArgumentException("ChannelKey not provided");
        }
        try {
            return this.doInsertCanvas(request.channelKey(), request.identifier(), request.authorRecipientKey(), request.body(), request.bodyRanges(), request.version());
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public CanvasKey updateCanvas(UpdateCanvasRequest request) {
        try {
            CanvasDbRecord canvas = (CanvasDbRecord)this.findByKey(request.canvasKey());
            if (canvas == null) {
                throw new IllegalStateException("A canvas with key " + String.valueOf(request.canvasKey()) + " should exist!");
            }
            return this.doInsertCanvas(canvas.channelKey(), canvas.identifier(), request.authorRecipientKey(), request.body(), request.bodyRanges(), request.version());
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public List<CanvasDbRecord> getByChannel(ChannelKey channelKey) {
        ArrayList<CanvasDbRecord> arrayList;
        block10: {
            Integer channelId = (Integer)this.channelData.getIdByKey(channelKey);
            if (channelId == null) {
                return new ArrayList<CanvasDbRecord>();
            }
            ResultSet result = this.databaseLayer.select(this.getFields()).from(this.getTableName()).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.CHANNEL_ID, channelId))).orderBy(Fields.VERSION, DatabaseLayer.Order.DESC).execute();
            try {
                ArrayList<CanvasDbRecord> records = new ArrayList<CanvasDbRecord>();
                while (result.next()) {
                    records.add(this.construct(result));
                }
                arrayList = records;
                if (result == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                    throw new IllegalArgumentException(ex);
                }
            }
            result.close();
        }
        return arrayList;
    }

    private CanvasKey doInsertCanvas(ChannelKey channelKey, String identifier, RecipientKey authorRecipientKey, String body, List<BodyRange> bodyRanges, long version) throws SQLException {
        Integer channelId = (Integer)this.channelData.getIdByKey(channelKey);
        if (channelId == null) {
            throw new IllegalStateException("A channel with key " + String.valueOf(channelKey) + " should exist!");
        }
        Integer authorRecipientId = (Integer)this.recipientData.getIdByKey(authorRecipientKey);
        if (authorRecipientId == null) {
            throw new IllegalStateException("A recipient with key " + String.valueOf(authorRecipientKey) + " should exist!");
        }
        CanvasKey canvasKey = new CanvasKey();
        Map<Field, Object> values = Map.ofEntries(Map.entry(Fields.ENTITY_KEY, canvasKey.getKey()), Map.entry(Fields.CHANNEL_ID, channelId), Map.entry(Fields.UUID, identifier), Map.entry(Fields.AUTHOR_RECIPIENT_ID, authorRecipientId), Map.entry(Fields.BODY, body), Map.entry(Fields.BODY_RANGES, BodyRangeUtil.bodyRangesToRaw(bodyRanges)), Map.entry(Fields.DATE_MODIFIED, System.currentTimeMillis()), Map.entry(Fields.VERSION, version));
        List<Integer> inserted = this.databaseLayer.insert(this.getTableName()).values(values).execute();
        if (inserted.size() == 1) {
            return canvasKey;
        }
        return null;
    }

    public static enum Fields implements Field
    {
        ID(FieldBuilder.newField("_id", FieldType.INT).withPrimaryKey(true).withAutoincrement(true)),
        ENTITY_KEY(FieldBuilder.newField("entity_key", FieldType.BLOB).withEntityKey(true).withNullable(false).withDefaultValue(0)),
        DATE_MODIFIED(FieldBuilder.newField("date_modified", FieldType.LONG).withNullable(false)),
        UUID(FieldBuilder.newField("uuid", FieldType.TEXT).withNullable(false)),
        BODY(FieldBuilder.newField("body", FieldType.TEXT)),
        BODY_RANGES(FieldBuilder.newField("body_ranges", FieldType.TEXT)),
        CHANNEL_ID(FieldBuilder.newField("channel_id", FieldType.INT).withNullable(false).withReference("channel", ChannelData.Fields.ID, FieldReference.OnDelete.CASCADE)),
        AUTHOR_RECIPIENT_ID(FieldBuilder.newField("author_recipient_id", FieldType.INT).withNullable(false).withReference("recipient", RecipientData.Fields.ID, FieldReference.OnDelete.CASCADE)),
        VERSION(FieldBuilder.newField("version", FieldType.LONG).withDefaultValue(0));

        public final Field field;

        private Fields(FieldBuilder builder) {
            this.field = builder.build();
        }

        @Override
        public Field getFieldImpl() {
            return this.field;
        }

        @Override
        public String getTableName() {
            return CanvasData.TABLE_NAME;
        }
    }
}

