/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata.sticker;

import io.privacyresearch.clientdata.DatabaseLayer;
import io.privacyresearch.clientdata.EntityKeyData;
import io.privacyresearch.clientdata.Field;
import io.privacyresearch.clientdata.FieldBuilder;
import io.privacyresearch.clientdata.FieldReference;
import io.privacyresearch.clientdata.FieldType;
import io.privacyresearch.clientdata.sticker.StickerKey;
import io.privacyresearch.clientdata.sticker.StickerPackData;
import io.privacyresearch.clientdata.sticker.StickerPackKey;
import io.privacyresearch.clientdata.sticker.StickerPackRecord;
import io.privacyresearch.clientdata.sticker.StickerRecord;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StickerData
extends EntityKeyData<StickerRecord, StickerKey> {
    private static final Logger LOG = Logger.getLogger(StickerData.class.getName());
    public static final String TABLE_NAME = "sticker";
    private final StickerPackData stickerPackData;

    public StickerData(Connection connection, StickerPackData stickerPackData) {
        super(connection, TABLE_NAME, List.of(Fields.values()), StickerKey::new);
        this.stickerPackData = stickerPackData;
    }

    @Override
    public StickerRecord construct(ResultSet resultSet) throws SQLException {
        StickerPackRecord stickerPack = (StickerPackRecord)this.stickerPackData.findById(Fields.PACK_ID.getValue(resultSet));
        return new StickerRecord(new StickerKey((byte[])Fields.ENTITY_KEY.getValue(resultSet)), stickerPack.key(), (Integer)Fields.STICKER_ID.getValue(resultSet), (String)Fields.EMOJI.getValue(resultSet), (String)Fields.CONTENT_TYPE.getValue(resultSet), (Boolean)Fields.COVER.getValue(resultSet), (String)Fields.FILE_PATH.getValue(resultSet));
    }

    public List<StickerRecord> findByPack(StickerPackKey stickerPackKey) {
        ArrayList<StickerRecord> arrayList;
        block10: {
            Integer stickerPackId = (Integer)this.stickerPackData.getIdByKey(stickerPackKey);
            if (stickerPackId == null) {
                return new ArrayList<StickerRecord>();
            }
            ResultSet result = this.databaseLayer.select(this.getFields()).from(this.getTableName()).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.PACK_ID, stickerPackId))).orderBy(Fields.STICKER_ID, DatabaseLayer.Order.ASC).execute();
            try {
                ArrayList<StickerRecord> stickers = new ArrayList<StickerRecord>();
                while (result.next()) {
                    stickers.add(this.construct(result));
                }
                arrayList = stickers;
                if (result == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                    throw new IllegalArgumentException(ex);
                }
            }
            result.close();
        }
        return arrayList;
    }

    public StickerKey createSticker(StickerPackKey stickerPackKey, int stickerId, String emoji, String contentType, boolean cover, String filePath) {
        try {
            Integer stickerPackId = (Integer)this.stickerPackData.getIdByKey(stickerPackKey);
            if (stickerPackId == null) {
                throw new IllegalStateException("A sticker pack with key " + String.valueOf(stickerPackKey) + " should exist!");
            }
            StickerKey stickerKey = new StickerKey();
            Map<Field, Object> values = Map.ofEntries(Map.entry(Fields.ENTITY_KEY, stickerKey.getKey()), Map.entry(Fields.PACK_ID, stickerPackId), Map.entry(Fields.STICKER_ID, stickerId), Map.entry(Fields.EMOJI, emoji), Map.entry(Fields.CONTENT_TYPE, contentType), Map.entry(Fields.COVER, cover), Map.entry(Fields.FILE_PATH, filePath));
            int inserted = this.databaseLayer.insert(this.getTableName()).values(values).execute();
            if (inserted == 1) {
                return stickerKey;
            }
            return null;
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public static enum Fields implements Field
    {
        ID(FieldBuilder.newField("_id", FieldType.INT).withPrimaryKey(true).withAutoincrement(true)),
        ENTITY_KEY(FieldBuilder.newField("entity_key", FieldType.BLOB).withEntityKey(true).withNullable(false).withDefaultValue(0)),
        PACK_ID(FieldBuilder.newField("pack_id", FieldType.INT).withNullable(false).withReference("sticker_pack", StickerPackData.Fields.ID, FieldReference.OnDelete.CASCADE)),
        STICKER_ID(FieldBuilder.newField("sticker_id", FieldType.INT)),
        EMOJI(FieldBuilder.newField("emoji", FieldType.TEXT).withNullable(false)),
        COVER(FieldBuilder.newField("cover", FieldType.BOOLEAN)),
        CONTENT_TYPE(FieldBuilder.newField("content_type", FieldType.TEXT).withDefaultNull()),
        FILE_PATH(FieldBuilder.newField("file_path", FieldType.TEXT));

        public final Field field;

        private Fields(FieldBuilder builder) {
            this.field = builder.build();
        }

        @Override
        public Field getFieldImpl() {
            return this.field;
        }

        @Override
        public String getTableName() {
            return StickerData.TABLE_NAME;
        }
    }
}

