/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata.message;

import io.privacyresearch.clientdata.DatabaseLayer;
import io.privacyresearch.clientdata.EntityKeyData;
import io.privacyresearch.clientdata.Field;
import io.privacyresearch.clientdata.FieldBuilder;
import io.privacyresearch.clientdata.FieldReference;
import io.privacyresearch.clientdata.FieldType;
import io.privacyresearch.clientdata.message.MessageData;
import io.privacyresearch.clientdata.message.MessageKey;
import io.privacyresearch.clientdata.message.ReceiptDbRecord;
import io.privacyresearch.clientdata.message.ReceiptKey;
import io.privacyresearch.clientdata.message.ReceiptProtocol;
import io.privacyresearch.clientdata.message.ReceiptType;
import io.privacyresearch.clientdata.user.UserData;
import io.privacyresearch.clientdata.user.UserKey;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReceiptData
extends EntityKeyData<ReceiptDbRecord, ReceiptKey> {
    private static final Logger LOG = Logger.getLogger(ReceiptData.class.getName());
    public static final String TABLE_NAME = "receipt";
    private final MessageData messageData;
    private final UserData userData;

    public ReceiptData(Connection connection, MessageData messageData, UserData userData) {
        super(connection, TABLE_NAME, List.of(Fields.values()), ReceiptKey::new);
        this.messageData = messageData;
        this.userData = userData;
    }

    @Override
    public ReceiptDbRecord construct(ResultSet resultSet) throws SQLException {
        MessageKey messageKey = (MessageKey)this.messageData.getKeyById(Fields.MESSAGE_ID.getValue(resultSet));
        Integer userId = (Integer)Fields.USER_ID.getValue(resultSet);
        UserKey userKey = null;
        if (userId != null) {
            userKey = (UserKey)this.userData.getKeyById(userId);
        }
        return new ReceiptDbRecord(new ReceiptKey((byte[])Fields.ENTITY_KEY.getValue(resultSet)), userKey, messageKey, ReceiptType.valueOf((Integer)Fields.TYPE.getValue(resultSet)), (Long)Fields.TIMESTAMP.getValue(resultSet), ReceiptProtocol.valueOf((Integer)Fields.PROTOCOL.getValue(resultSet)));
    }

    public ReceiptKey addReceipt(ReceiptDbRecord receipt) {
        try {
            int inserted;
            Integer messageId = (Integer)this.messageData.getIdByKey(receipt.messageKey());
            if (messageId == null) {
                throw new IllegalStateException("A message with key " + String.valueOf(receipt.messageKey()) + " should exist!");
            }
            HashMap<Field, Object> values = new HashMap<Field, Object>(Map.ofEntries(Map.entry(Fields.ENTITY_KEY, receipt.key().getKey()), Map.entry(Fields.MESSAGE_ID, messageId), Map.entry(Fields.TYPE, receipt.type().getV()), Map.entry(Fields.TIMESTAMP, receipt.timestamp()), Map.entry(Fields.PROTOCOL, receipt.protocol().getValue())));
            if (receipt.userKey() != null) {
                Integer userId = (Integer)this.userData.getIdByKey(receipt.userKey());
                if (userId == null) {
                    throw new IllegalStateException("A user with key " + String.valueOf(receipt.userKey()) + " should exist!");
                }
                values.put(Fields.USER_ID, userId);
            }
            if ((inserted = this.databaseLayer.insert(this.getTableName()).values(values).execute()) == 1) {
                return receipt.key();
            }
            return null;
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public List<ReceiptDbRecord> findByMessageKey(MessageKey messageKey) {
        LinkedList<ReceiptDbRecord> linkedList;
        block10: {
            Integer messageId = (Integer)this.messageData.getIdByKey(messageKey);
            if (messageId == null) {
                return new LinkedList<ReceiptDbRecord>();
            }
            ResultSet result = this.databaseLayer.select(this.getFields()).from(this.getTableName()).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.MESSAGE_ID, messageId))).execute();
            try {
                LinkedList<ReceiptDbRecord> receipts = new LinkedList<ReceiptDbRecord>();
                while (result.next()) {
                    receipts.add(this.construct(result));
                }
                linkedList = receipts;
                if (result == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                    throw new IllegalArgumentException(ex);
                }
            }
            result.close();
        }
        return linkedList;
    }

    public static enum Fields implements Field
    {
        ID(FieldBuilder.newField("_id", FieldType.INT).withPrimaryKey(true).withAutoincrement(true)),
        ENTITY_KEY(FieldBuilder.newField("entity_key", FieldType.BLOB).withEntityKey(true).withNullable(false).withDefaultValue(0)),
        USER_ID(FieldBuilder.newField("user_id", FieldType.INT).withReference("users", UserData.Fields.ID, FieldReference.OnDelete.CASCADE)),
        MESSAGE_ID(FieldBuilder.newField("message_id", FieldType.INT).withNullable(false).withReference("message", MessageData.Fields.ID, FieldReference.OnDelete.CASCADE)),
        TYPE(FieldBuilder.newField("type", FieldType.INT).withDefaultValue(0)),
        TIMESTAMP(FieldBuilder.newField("timestamp", FieldType.LONG).withDefaultValue(0)),
        PROTOCOL(FieldBuilder.newField("protocol", FieldType.INT).withDefaultValue(0));

        public final Field field;

        private Fields(FieldBuilder builder) {
            this.field = builder.build();
        }

        @Override
        public Field getFieldImpl() {
            return this.field;
        }

        @Override
        public String getTableName() {
            return ReceiptData.TABLE_NAME;
        }
    }
}

